/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCLicenseChecker;
import com.tencent.ugc.UGCWatermarkFilter;
import com.tencent.ugc.datereport.UGCDataReport;
import com.tencent.ugc.videoprocessor.a;
import com.tencent.ugc.videoprocessor.b;
import com.tencent.ugc.videoprocessor.c;
import com.tencent.ugc.videoprocessor.d;
import com.tencent.ugc.videoprocessor.e;
import com.tencent.ugc.videoprocessor.util.BitmapUtils;
import com.tencent.ugc.videoprocessor.watermark.AnimatedPasterFilterChain;
import com.tencent.ugc.videoprocessor.watermark.PasterFilterChain;
import com.tencent.ugc.videoprocessor.watermark.SubtitleFilterChain;
import com.tencent.ugc.videoprocessor.watermark.TailWaterMarkChain;
import com.tencent.ugc.videoprocessor.watermark.data.AnimatedPaster;
import com.tencent.ugc.videoprocessor.watermark.data.TailWaterMark;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class WatermarkProcessor {
    private static final String TAG = "WatermarkProcessor";
    private UGCWatermarkFilter mWatermarkFilter;
    private SubtitleFilterChain mSubtitleFilterChain;
    private PasterFilterChain mPasterFilterChain;
    private AnimatedPasterFilterChain mAnimatedPasterFilterChain;
    private TailWaterMarkChain mTailWaterMarkChain;
    private com.tencent.liteav.videobase.frame.e mGLTexturePool;
    private ArrayList<o> mLastWaterMarkList = new ArrayList();
    private int mRenderMode = 1;
    private com.tencent.liteav.videobase.utils.d mDelayQueue = new com.tencent.liteav.videobase.utils.d();
    private boolean mHasSetWaterMark = false;
    private boolean mIsReverse = false;
    private long mVideoDuration = 0L;
    private Size mRenderTargetSize = null;

    public WatermarkProcessor() {
        this.mWatermarkFilter = new UGCWatermarkFilter();
        this.mSubtitleFilterChain = new SubtitleFilterChain();
        this.mPasterFilterChain = new PasterFilterChain();
        this.mAnimatedPasterFilterChain = new AnimatedPasterFilterChain();
        this.mTailWaterMarkChain = new TailWaterMarkChain();
    }

    public void initialize(com.tencent.liteav.videobase.frame.e glTexturePool, int width, int height) {
        this.mGLTexturePool = glTexturePool;
        this.mWatermarkFilter.initialize(glTexturePool);
        this.mWatermarkFilter.enableWatermark(true);
        this.mWatermarkFilter.onOutputSizeChanged(width, height);
        if (width > 1 && height > 1) {
            this.mRenderTargetSize = new Size(width, height);
        }
    }

    public void setRenderTargetSize(int width, int height) {
        LiteavLog.i(TAG, "setRenderResolution: width:" + width + "  height:" + height);
        if (width <= 0 || height <= 0) {
            return;
        }
        this.mRenderTargetSize = new Size(width, height);
    }

    public void setReverse(boolean isReverse, long videoDuration) {
        this.mIsReverse = isReverse;
        this.mVideoDuration = videoDuration;
    }

    public float getBlurLevel() {
        return this.mTailWaterMarkChain.getBlurLevel();
    }

    public PixelFrame process(PixelFrame frame, FloatBuffer cubeVertise, FloatBuffer textureCoords) {
        this.mDelayQueue.a();
        if (!this.updateWaterMarkList(frame)) {
            return null;
        }
        com.tencent.liteav.videobase.frame.d d2 = this.mGLTexturePool.a(frame.getWidth(), frame.getHeight());
        this.mWatermarkFilter.onDraw(frame.getTextureId(), d2, cubeVertise, textureCoords);
        PixelFrame pixelFrame = d2.a(frame.getGLContext());
        pixelFrame.setTimestamp(frame.getTimestamp());
        d2.release();
        return pixelFrame;
    }

    private boolean updateWaterMarkList(PixelFrame frame) {
        ArrayList<o> arrayList = new ArrayList<o>();
        this.collectWaterMarkFromSubtitle(arrayList, frame);
        this.collectWaterMarkFromStaticPaster(arrayList, frame);
        this.collectWaterMarkFromAnimatedPaster(arrayList, frame);
        this.collectWaterMarkFromTail(arrayList, frame);
        WatermarkProcessor watermarkProcessor = this;
        if (!watermarkProcessor.compareWaterMarkList(watermarkProcessor.mLastWaterMarkList, arrayList)) {
            this.mWatermarkFilter.setWaterMarkList(arrayList);
            this.mLastWaterMarkList.clear();
            this.mLastWaterMarkList = arrayList;
            return true;
        }
        if (this.mLastWaterMarkList != null && this.mLastWaterMarkList.size() > 0) {
            return true;
        }
        return this.mHasSetWaterMark;
    }

    private boolean compareWaterMarkList(@Nullable List<o> src1, @Nullable List<o> src2) {
        if (src1.size() != src2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < src1.size(); ++i2) {
            o o2 = src1.get(i2);
            o o3 = src2.get(i2);
            if (o2.a.equals(o3.a) && !((double)Math.abs(o2.b - o3.b) > 1.0E-5) && !((double)Math.abs(o2.c - o3.c) > 1.0E-5) && !((double)Math.abs(o2.d - o3.d) > 1.0E-5)) continue;
            return false;
        }
        return true;
    }

    private void collectWaterMarkFromAnimatedPaster(ArrayList<o> list, PixelFrame frame) {
        List<AnimatedPaster> list2 = this.mAnimatedPasterFilterChain.getAnimatedPasterList();
        if (list2 == null || list2.size() == 0) {
            this.mAnimatedPasterFilterChain.normalized(frame.getWidth(), frame.getHeight(), this.mRenderMode);
            list2 = this.mAnimatedPasterFilterChain.getAnimatedPasterList();
        }
        for (AnimatedPaster animatedPaster : list2) {
            Bitmap bitmap;
            long l2 = this.getTimeInEffect(frame);
            if (l2 < animatedPaster.mStartTime || l2 > animatedPaster.mEndTime || (bitmap = BitmapFactory.decodeFile((String)animatedPaster.mPasterPath)) == null) continue;
            if (animatedPaster.mRotation == 0.0f) {
                list.add(this.newWaterMarkTag(bitmap, animatedPaster.mFrame));
                continue;
            }
            Bitmap bitmap2 = BitmapUtils.rotateImage(animatedPaster.mRotation, bitmap);
            list.add(this.newWaterMarkTag(bitmap2, animatedPaster.mFrame));
        }
    }

    private void collectWaterMarkFromStaticPaster(ArrayList<o> list, PixelFrame frame) {
        List<TXVideoEditConstants.TXPaster> list2 = this.mPasterFilterChain.getPasterList();
        if (list2 == null || list2.size() == 0) {
            this.mPasterFilterChain.normalized(frame.getWidth(), frame.getHeight(), this.mRenderMode);
            list2 = this.mPasterFilterChain.getPasterList();
        }
        for (TXVideoEditConstants.TXPaster tXPaster : list2) {
            long l2 = this.getTimeInEffect(frame);
            if (l2 < tXPaster.startTime || l2 > tXPaster.endTime) continue;
            list.add(this.newWaterMarkTag(tXPaster.pasterImage, tXPaster.frame));
        }
    }

    private void collectWaterMarkFromSubtitle(ArrayList<o> list, PixelFrame frame) {
        List<TXVideoEditConstants.TXSubtitle> list2 = this.mSubtitleFilterChain.getSubtitleList();
        if (list2 == null || list2.size() == 0) {
            this.mSubtitleFilterChain.normalized(frame.getWidth(), frame.getHeight(), this.mRenderMode);
            list2 = this.mSubtitleFilterChain.getSubtitleList();
        }
        for (TXVideoEditConstants.TXSubtitle tXSubtitle : list2) {
            long l2 = this.getTimeInEffect(frame);
            if (l2 < tXSubtitle.startTime || l2 > tXSubtitle.endTime) continue;
            list.add(this.newWaterMarkTag(tXSubtitle.titleImage, tXSubtitle.frame));
        }
    }

    private long getTimeInEffect(PixelFrame frame) {
        long l2 = frame.getTimestamp();
        if (this.mIsReverse) {
            l2 = h.a(this.mVideoDuration - l2, 0L, this.mVideoDuration);
        }
        return l2;
    }

    private void collectWaterMarkFromTail(ArrayList<o> list, PixelFrame frame) {
        TailWaterMark tailWaterMark = this.mTailWaterMarkChain.getTailWaterMark(frame);
        if (tailWaterMark == null) {
            return;
        }
        list.add(this.newWaterMarkTag(tailWaterMark.getWaterMark(), tailWaterMark.getmWaterMarkRect()));
        this.mWatermarkFilter.setAlpha(this.mTailWaterMarkChain.getAlpha());
    }

    private o newWaterMarkTag(Bitmap titleImage, TXVideoEditConstants.TXRect rect) {
        o o2 = new o();
        new o().a = titleImage;
        o2.b = rect.x;
        o2.c = rect.y;
        o2.d = rect.width;
        return o2;
    }

    public void setWaterMark(Bitmap watermark, TXVideoEditConstants.TXRect rect) {
        this.mDelayQueue.a(a.a(this, watermark, rect));
    }

    private void setTailWaterMarkInternal(Bitmap tailWatermarkBitmap, TXVideoEditConstants.TXRect rect, long startTime, int duration) {
        LiteavLog.i(TAG, "setTailWaterMarkInternal: " + tailWatermarkBitmap + ", rect: " + rect + ", startTime: " + startTime + ", duration: " + duration);
        UGCDataReport.reportDAU(1029);
        int n2 = duration * 1000;
        TXVideoEditConstants.TXRect tXRect = new TXVideoEditConstants.TXRect();
        new TXVideoEditConstants.TXRect().width = rect.width;
        tXRect.x = rect.x;
        tXRect.y = rect.y;
        TailWaterMark tailWaterMark = new TailWaterMark(tailWatermarkBitmap, tXRect, startTime, n2);
        this.mTailWaterMarkChain.setTailWaterMark(tailWaterMark);
    }

    public void setTailWaterMark(Bitmap tailWatermarkBitmap, TXVideoEditConstants.TXRect rect, long startTime, int duration) {
        this.mDelayQueue.a(b.a(this, tailWatermarkBitmap, rect, startTime, duration));
    }

    private void setSubtitleListInternal(List<TXVideoEditConstants.TXSubtitle> subtitleList, Size renderSize) {
        if (renderSize == null) {
            Size size = renderSize = this.mRenderTargetSize == null ? null : new Size(this.mRenderTargetSize);
        }
        if (renderSize == null) {
            return;
        }
        LiteavLog.i(TAG, "setSubtitleListInternal subtitleList: ".concat(String.valueOf(subtitleList)));
        if (subtitleList != null) {
            UGCDataReport.reportDAU(1027);
            ArrayList<TXVideoEditConstants.TXSubtitle> arrayList = new ArrayList<TXVideoEditConstants.TXSubtitle>();
            for (int i2 = 0; i2 < subtitleList.size(); ++i2) {
                TXVideoEditConstants.TXSubtitle tXSubtitle = subtitleList.get(i2);
                TXVideoEditConstants.TXSubtitle tXSubtitle2 = new TXVideoEditConstants.TXSubtitle();
                TXVideoEditConstants.TXRect tXRect = new TXVideoEditConstants.TXRect();
                new TXVideoEditConstants.TXRect().width = tXSubtitle.frame.width;
                tXRect.x = tXSubtitle.frame.x;
                tXRect.y = tXSubtitle.frame.y;
                tXSubtitle2.frame = tXRect;
                tXSubtitle2.titleImage = tXSubtitle.titleImage;
                tXSubtitle2.startTime = tXSubtitle.startTime;
                tXSubtitle2.endTime = tXSubtitle.endTime;
                arrayList.add(tXSubtitle2);
            }
            this.mSubtitleFilterChain.setSubtitleList(arrayList, renderSize);
            return;
        }
        this.mSubtitleFilterChain.setSubtitleList(null, renderSize);
    }

    public void setSubtitleList(List<TXVideoEditConstants.TXSubtitle> subtitleList) {
        Size size = this.mRenderTargetSize == null ? null : new Size(this.mRenderTargetSize);
        this.mDelayQueue.a(c.a(this, subtitleList, size));
    }

    private void setAnimatedPasterListInternal(List<TXVideoEditConstants.TXAnimatedPaster> animatedPasterList, Size renderSize) {
        LiteavLog.i(TAG, "setAnimatedPasterListInternal animatedPasterList: ".concat(String.valueOf(animatedPasterList)));
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setAnimatedPasterList is not supported in UGC_Smart license");
            return;
        }
        if (renderSize == null) {
            Size size = renderSize = this.mRenderTargetSize == null ? null : new Size(this.mRenderTargetSize);
        }
        if (renderSize == null) {
            return;
        }
        if (animatedPasterList != null) {
            UGCDataReport.reportDAU(1026);
            ArrayList<TXVideoEditConstants.TXAnimatedPaster> arrayList = new ArrayList<TXVideoEditConstants.TXAnimatedPaster>();
            for (int i2 = 0; i2 < animatedPasterList.size(); ++i2) {
                TXVideoEditConstants.TXAnimatedPaster tXAnimatedPaster = animatedPasterList.get(i2);
                TXVideoEditConstants.TXAnimatedPaster tXAnimatedPaster2 = new TXVideoEditConstants.TXAnimatedPaster();
                TXVideoEditConstants.TXRect tXRect = new TXVideoEditConstants.TXRect();
                new TXVideoEditConstants.TXRect().width = tXAnimatedPaster.frame.width;
                tXRect.x = tXAnimatedPaster.frame.x;
                tXRect.y = tXAnimatedPaster.frame.y;
                tXAnimatedPaster2.frame = tXRect;
                tXAnimatedPaster2.animatedPasterPathFolder = tXAnimatedPaster.animatedPasterPathFolder;
                tXAnimatedPaster2.startTime = tXAnimatedPaster.startTime;
                tXAnimatedPaster2.endTime = tXAnimatedPaster.endTime;
                tXAnimatedPaster2.rotation = tXAnimatedPaster.rotation;
                arrayList.add(tXAnimatedPaster2);
            }
            this.mAnimatedPasterFilterChain.setAnimatedPasterList(arrayList, renderSize);
            return;
        }
        this.mAnimatedPasterFilterChain.setAnimatedPasterList(null, renderSize);
    }

    public void setAnimatedPasterList(List<TXVideoEditConstants.TXAnimatedPaster> animatedPasterList) {
        Size size = this.mRenderTargetSize == null ? null : new Size(this.mRenderTargetSize);
        this.mDelayQueue.a(d.a(this, animatedPasterList, size));
    }

    private void setPasterListInternal(List<TXVideoEditConstants.TXPaster> pasterList, Size renderSize) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setPasterList is not supported in UGC_Smart license");
            return;
        }
        if (renderSize == null) {
            Size size = renderSize = this.mRenderTargetSize == null ? null : new Size(this.mRenderTargetSize);
        }
        if (renderSize == null) {
            return;
        }
        LiteavLog.i(TAG, "==== setPasterList ==== pasterList: ".concat(String.valueOf(pasterList)));
        if (pasterList != null) {
            UGCDataReport.reportDAU(1025);
            ArrayList<TXVideoEditConstants.TXPaster> arrayList = new ArrayList<TXVideoEditConstants.TXPaster>();
            for (int i2 = 0; i2 < pasterList.size(); ++i2) {
                TXVideoEditConstants.TXPaster tXPaster = pasterList.get(i2);
                TXVideoEditConstants.TXPaster tXPaster2 = new TXVideoEditConstants.TXPaster();
                TXVideoEditConstants.TXRect tXRect = new TXVideoEditConstants.TXRect();
                new TXVideoEditConstants.TXRect().width = tXPaster.frame.width;
                tXRect.x = tXPaster.frame.x;
                tXRect.y = tXPaster.frame.y;
                tXPaster2.frame = tXRect;
                tXPaster2.pasterImage = tXPaster.pasterImage;
                tXPaster2.startTime = tXPaster.startTime;
                tXPaster2.endTime = tXPaster.endTime;
                arrayList.add(tXPaster2);
            }
            this.mPasterFilterChain.setPasterList(arrayList, renderSize);
            return;
        }
        this.mPasterFilterChain.setPasterList(null, renderSize);
    }

    public void setPasterList(List<TXVideoEditConstants.TXPaster> pasterList) {
        Size size = this.mRenderTargetSize == null ? null : new Size(this.mRenderTargetSize);
        this.mDelayQueue.a(e.a(this, pasterList, size));
    }

    public void uninitialize() {
        this.mWatermarkFilter.uninitialize();
        if (this.mTailWaterMarkChain != null) {
            this.mTailWaterMarkChain.clear();
            this.mTailWaterMarkChain = null;
        }
        if (this.mAnimatedPasterFilterChain != null) {
            this.mAnimatedPasterFilterChain.clear();
            this.mAnimatedPasterFilterChain = null;
        }
        if (this.mSubtitleFilterChain != null) {
            this.mSubtitleFilterChain.clear();
            this.mSubtitleFilterChain = null;
        }
        if (this.mPasterFilterChain != null) {
            this.mPasterFilterChain.clear();
            this.mPasterFilterChain = null;
        }
    }

    public void setRenderMode(int renderMode) {
        this.mRenderMode = renderMode;
    }

    static /* synthetic */ void lambda$setPasterList$4(WatermarkProcessor this_, List pasterList, Size renderSize) {
        this_.setPasterListInternal(pasterList, renderSize);
    }

    static /* synthetic */ void lambda$setAnimatedPasterList$3(WatermarkProcessor this_, List animatedPasterList, Size renderSize) {
        this_.setAnimatedPasterListInternal(animatedPasterList, renderSize);
    }

    static /* synthetic */ void lambda$setSubtitleList$2(WatermarkProcessor this_, List subtitleList, Size renderSize) {
        this_.setSubtitleListInternal(subtitleList, renderSize);
    }

    static /* synthetic */ void lambda$setTailWaterMark$1(WatermarkProcessor this_, Bitmap tailWatermarkBitmap, TXVideoEditConstants.TXRect rect, long startTime, int duration) {
        this_.setTailWaterMarkInternal(tailWatermarkBitmap, rect, startTime, duration);
    }

    static /* synthetic */ void lambda$setWaterMark$0(WatermarkProcessor this_, Bitmap watermark, TXVideoEditConstants.TXRect rect) {
        this_.mHasSetWaterMark = true;
        this_.mWatermarkFilter.enableWatermark(true);
        this_.mWatermarkFilter.setWatermark(watermark, rect.x, rect.y, rect.width);
    }
}

