/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.basemap.data;

public class DoublePoint {
    public double x;
    public double y;

    public DoublePoint() {
    }

    public DoublePoint(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public void set(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public boolean IsInUnitRange() {
        return this.x >= 0.0 && this.x <= 1.0 && this.y >= 0.0 && this.y <= 1.0;
    }

    public DoublePoint plus(double x2, double y2) {
        return new DoublePoint(this.x + x2, this.y + y2);
    }

    public DoublePoint plus(DoublePoint point) {
        return this.plus(point.x, point.y);
    }

    public DoublePoint minus(double x2, double y2) {
        return new DoublePoint(this.x - x2, this.y - y2);
    }

    public DoublePoint minus(DoublePoint point) {
        return this.minus(point.x, point.y);
    }

    public DoublePoint times(double s2) {
        return new DoublePoint(this.x * s2, this.y * s2);
    }

    public DoublePoint mult(double x2, double y2) {
        return new DoublePoint(this.x * x2, this.y * y2);
    }

    public float length() {
        return (float)Math.hypot(this.x, this.y);
    }

    public float distanceTo(DoublePoint p2) {
        return p2.minus(this).length();
    }

    public DoublePoint scaledTo(double length) {
        return this.times(length / (double)this.length());
    }

    public DoublePoint normalize() {
        return this.scaledTo(1.0);
    }

    public DoublePoint rotated90(int count) {
        double nx2 = this.x;
        double ny2 = this.y;
        for (int i2 = 0; i2 < count; ++i2) {
            double ox2 = nx2;
            nx2 = ny2;
            ny2 = -ox2;
        }
        return new DoublePoint(nx2, ny2);
    }

    public DoublePoint rotated(float radians) {
        return new DoublePoint((float)(Math.cos(radians) * this.x - Math.sin(radians) * this.y), (float)(Math.sin(radians) * this.x + Math.cos(radians) * this.y));
    }

    public DoublePoint rotatedAround(DoublePoint center, float radians) {
        return this.minus(center).rotated(radians).plus(center);
    }

    public boolean equals(Object object) {
        if (object instanceof DoublePoint) {
            DoublePoint o2 = (DoublePoint)object;
            return this.x == o2.x && this.y == o2.y;
        }
        return false;
    }

    public String toString() {
        return this.x + "," + this.y;
    }
}

