/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.a;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.location.Location;
import com.tencent.map.lib.basemap.data.DoublePoint;
import com.tencent.map.lib.basemap.data.GeoPoint;
import com.tencent.map.sdk.a.fu;
import com.tencent.map.sdk.a.fw;
import com.tencent.map.sdk.a.fz;
import com.tencent.map.sdk.a.kf;
import com.tencent.map.sdk.a.lj;
import com.tencent.map.sdk.a.lz;
import com.tencent.map.sdk.a.pn;

public final class kg
implements fu {
    private kf a;
    private pn b;
    private lz c;

    public kg(kf mapParam, lj mapContext) {
        this.a = mapParam;
        this.b = mapContext.g();
        this.c = (lz)mapContext;
    }

    @Override
    public final GeoPoint a(DoublePoint location) {
        Rect margin;
        if (location == null) {
            return null;
        }
        float screenX = (float)location.x;
        float screenY = (float)location.y;
        if (this.c != null && (margin = this.c.A) != null) {
            screenX -= (float)margin.left;
            screenY -= (float)margin.top;
        }
        return this.b.a(screenX, screenY);
    }

    @Override
    public final DoublePoint a(GeoPoint location) {
        Rect margin;
        if (location == null) {
            return null;
        }
        double lat = (double)location.getLatitudeE6() / 1000000.0;
        double lon = (double)location.getLongitudeE6() / 1000000.0;
        PointF screenPoint = this.b.a(lat, lon);
        float x2 = screenPoint.x;
        float y2 = screenPoint.y;
        if (this.c != null && (margin = this.c.A) != null) {
            x2 += (float)margin.left;
            y2 += (float)margin.top;
        }
        return new DoublePoint(x2, y2);
    }

    public static DoublePoint a(kf mapParam, GeoPoint geoPoint) {
        if (geoPoint == null) {
            return null;
        }
        double x2 = 0.0;
        double y2 = 0.0;
        int worldHalfPixels = mapParam.d >> 1;
        double pixelsPerLngDegree = mapParam.e;
        double pixelsPerLngRadian = mapParam.f;
        if (geoPoint != null) {
            double siny = Math.min(Math.max(Math.sin((double)geoPoint.getLatitudeE6() / 1000000.0 * (Math.PI / 180)), -0.9999), 0.9999);
            x2 = (double)worldHalfPixels + (double)geoPoint.getLongitudeE6() / 1000000.0 * pixelsPerLngDegree;
            y2 = (double)worldHalfPixels + Math.log((1.0 + siny) / (1.0 - siny)) * pixelsPerLngRadian * 0.5;
        }
        return new DoublePoint(x2, y2);
    }

    @Override
    public final double a(double lat) {
        float scale = this.a.b.f;
        double dglScale = this.a.b.a();
        scale = (float)((double)scale + Math.log(dglScale) / Math.log(2.0));
        double worldPixels = Math.pow(2.0, scale) * 256.0 * (double)fz.v;
        return 4.0076E7 / worldPixels * Math.cos(lat * Math.PI / 180.0);
    }

    @Override
    public final double a(Point leftCenter, Point rightCenter) {
        GeoPoint leftPoint = this.a(new DoublePoint(leftCenter.x, leftCenter.y));
        GeoPoint rightPoint = this.a(new DoublePoint(rightCenter.x, rightCenter.y));
        float[] result = new float[1];
        Location.distanceBetween((double)((double)leftPoint.getLatitudeE6() / 1000000.0), (double)((double)leftPoint.getLongitudeE6() / 1000000.0), (double)((double)rightPoint.getLatitudeE6() / 1000000.0), (double)((double)rightPoint.getLongitudeE6() / 1000000.0), (float[])result);
        int pixelDistance = (int)Math.sqrt(Math.pow(leftCenter.x - rightCenter.x, 2.0) + Math.pow(leftCenter.y - rightCenter.y, 2.0));
        return result[0] / (float)pixelDistance;
    }

    public static fw b(GeoPoint geoPoint) {
        if (geoPoint == null) {
            return null;
        }
        double fLat = (double)geoPoint.getLatitudeE6() / 1000000.0;
        double x2 = (double)geoPoint.getLongitudeE6() / 1000000.0 * 2.003750834E7 / 180.0;
        double y2 = Math.log(Math.tan((90.0 + fLat) * Math.PI / 360.0)) / (Math.PI / 180) * 2.003750834E7 / 180.0;
        return new fw(x2, y2);
    }
}

