/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.heatmap;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.LongSparseArray;
import com.tencent.map.lib.basemap.data.DoublePoint;
import com.tencent.map.sdk.a.hl;
import com.tencent.map.sdk.a.ho;
import com.tencent.map.sdk.a.oo;
import com.tencent.map.sdk.a.oy;
import com.tencent.map.sdk.utilities.heatmap.Gradient;
import com.tencent.map.sdk.utilities.heatmap.WeightedLatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.Tile;
import com.tencent.tencentmap.mapsdk.maps.model.TileProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HeatMapTileProvider
implements TileProvider {
    public static final int DEFAULT_RADIUS = 40;
    public static final double DEFAULT_OPACITY = 0.6;
    private static final int[] a = new int[]{Color.argb((int)0, (int)25, (int)0, (int)255), Color.argb((int)170, (int)30, (int)0, (int)255), Color.rgb((int)0, (int)191, (int)255), Color.rgb((int)0, (int)255, (int)0), Color.rgb((int)255, (int)255, (int)0), Color.rgb((int)255, (int)0, (int)0)};
    private static final float[] b = new float[]{0.0f, 0.4f, 0.6f, 0.75f, 0.8f, 1.0f};
    public static final Gradient DEFAULT_GRADIENT = new Gradient(a, b);
    private final OnHeatMapReadyListener c;
    private HeatTileGenerator d;
    private hl<WeightedLatLng> e;
    private Collection<WeightedLatLng> f;
    private ho g;
    private int h;
    private Gradient i;
    private int[] j;
    private double[] k;
    private double l;
    private double[] m;
    private boolean n;

    private HeatMapTileProvider(Builder builder) {
        this.f = builder.a;
        this.h = builder.b;
        this.i = builder.c;
        this.l = builder.d;
        this.c = builder.f;
        this.d = builder.e;
        HeatMapTileProvider heatMapTileProvider = this;
        if (heatMapTileProvider.f != null) {
            Boolean bl2 = Boolean.FALSE;
            oo.a(new oo.e<Boolean>(){

                @Override
                public final /* synthetic */ Object call() throws Exception {
                    1 var1_1 = this;
                    if (var1_1.HeatMapTileProvider.this.n) {
                        return Boolean.FALSE;
                    }
                    if (var1_1.HeatMapTileProvider.this.d != null) {
                        HeatMapTileProvider.a(var1_1.HeatMapTileProvider.this, var1_1.HeatMapTileProvider.this.d.generateKernel(var1_1.HeatMapTileProvider.this.h));
                    } else {
                        HeatMapTileProvider.a(var1_1.HeatMapTileProvider.this, HeatMapTileProvider.a(var1_1.HeatMapTileProvider.this.h, (double)var1_1.HeatMapTileProvider.this.h / 3.0));
                    }
                    var1_1.HeatMapTileProvider.this.setGradient(var1_1.HeatMapTileProvider.this.i);
                    var1_1.HeatMapTileProvider.this.setWeightedData(var1_1.HeatMapTileProvider.this.f);
                    HeatMapTileProvider.f(var1_1.HeatMapTileProvider.this);
                    if (var1_1.HeatMapTileProvider.this.c != null) {
                        var1_1.HeatMapTileProvider.this.c.onHeatMapReady();
                    }
                    return Boolean.TRUE;
                }
            }).a(new oo.d<Boolean>(bl2)).a();
        }
    }

    @Override
    public Tile getTile(int x2, int y2, int zoom) {
        int bucketY;
        int bucketX;
        ho overlapBounds;
        if (!this.n) {
            oy.c("TileOverlay", "\u70ed\u529b\u56fe\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u8fd4\u56de\u7a7a\u74e6\u5757");
            return TileProvider.NO_TILE;
        }
        double tileWidth = 1.0 / Math.pow(2.0, zoom);
        double padding = tileWidth * (double)this.h / 256.0;
        double bucketWidth = (tileWidth + 2.0 * padding) / (double)(256 + this.h * 2);
        double minX = (double)x2 * tileWidth - padding;
        double maxX = (double)(x2 + 1) * tileWidth + padding;
        double minY = (double)y2 * tileWidth - padding;
        double maxY = (double)(y2 + 1) * tileWidth + padding;
        double xOffset = 0.0;
        Collection<Object> wrappedPoints = new ArrayList();
        if (minX < 0.0) {
            overlapBounds = new ho(minX + 1.0, 1.0, minY, maxY);
            xOffset = -1.0;
            wrappedPoints = this.e.a(overlapBounds);
        } else if (maxX > 1.0) {
            overlapBounds = new ho(0.0, maxX - 1.0, minY, maxY);
            xOffset = 1.0;
            wrappedPoints = this.e.a(overlapBounds);
        }
        ho tileBounds = new ho(minX, maxX, minY, maxY);
        ho paddedBounds = new ho(this.g.a - padding, this.g.c + padding, this.g.b - padding, this.g.d + padding);
        if (!tileBounds.a(paddedBounds)) {
            oy.c("TileOverlay", "\u70ed\u529b\u56fe\u8d85\u51fa\u6709\u6548\u8fb9\u754c\uff0c\u8fd4\u56de\u7a7a\u74e6\u5757-" + x2 + ":" + y2 + ":" + zoom);
            return TileProvider.NO_TILE;
        }
        Collection<WeightedLatLng> points = this.e.a(tileBounds);
        if (points.isEmpty()) {
            oy.c("TileOverlay", "\u70ed\u529b\u56fe\u6ca1\u6709\u70ed\u529b\u6570\u636e\uff0c\u8fd4\u56de\u7a7a\u74e6\u5757-" + x2 + ":" + y2 + ":" + zoom);
            return TileProvider.NO_TILE;
        }
        double[][] intensity = new double[256 + this.h * 2][256 + this.h * 2];
        for (WeightedLatLng weightedLatLng : points) {
            DoublePoint p2 = weightedLatLng.getItemPoint();
            bucketX = (int)((p2.x - minX) / bucketWidth);
            bucketY = (int)((p2.y - minY) / bucketWidth);
            double[] dArray = intensity[bucketX];
            int n2 = bucketY;
            dArray[n2] = dArray[n2] + weightedLatLng.getIntensity();
        }
        for (WeightedLatLng weightedLatLng : wrappedPoints) {
            DoublePoint p2 = weightedLatLng.getItemPoint();
            bucketX = (int)((p2.x + xOffset - minX) / bucketWidth);
            bucketY = (int)((p2.y - minY) / bucketWidth);
            double[] dArray = intensity[bucketX];
            int n3 = bucketY;
            dArray[n3] = dArray[n3] + weightedLatLng.getIntensity();
        }
        Bitmap bitmap = HeatMapTileProvider.a(HeatMapTileProvider.a(intensity, this.k), this.j, this.m[zoom]);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return new Tile(256, 256, byteArrayOutputStream.toByteArray());
    }

    public void setWeightedData(Collection<WeightedLatLng> data) {
        this.f = data;
        if (this.f.isEmpty()) {
            throw new IllegalArgumentException("No input points.");
        }
        this.g = HeatMapTileProvider.b(this.f);
        this.e = new hl(this.g);
        Iterator<WeightedLatLng> iterator = this.f.iterator();
        while (iterator.hasNext()) {
            WeightedLatLng l2;
            WeightedLatLng weightedLatLng = l2 = iterator.next();
            hl<WeightedLatLng> hl2 = this.e;
            DoublePoint doublePoint = weightedLatLng.getItemPoint();
            if (!hl2.a.a(doublePoint.x, doublePoint.y)) continue;
            hl2.a(doublePoint.x, doublePoint.y, weightedLatLng);
        }
        this.m = this.a(this.h);
    }

    public void setData(Collection<LatLng> data) {
        this.setWeightedData(HeatMapTileProvider.c(data));
    }

    public void setGradient(Gradient gradient) {
        this.i = gradient;
        if (this.d != null) {
            this.j = this.d.generateColorMap(this.l);
            return;
        }
        this.j = this.i.generateColorMap(this.l);
    }

    public void setRadius(int radius) {
        this.h = radius;
        this.k = this.d != null ? this.d.generateKernel(this.h) : HeatMapTileProvider.a(this.h, (double)this.h / 3.0);
        this.m = this.a(this.h);
    }

    public void setOpacity(double opacity) {
        this.l = opacity;
        HeatMapTileProvider heatMapTileProvider = this;
        heatMapTileProvider.setGradient(heatMapTileProvider.i);
    }

    public void setHeatTileGenerator(HeatTileGenerator heatTileGenerator) {
        this.d = heatTileGenerator;
        if (this.d != null) {
            this.k = this.d.generateKernel(this.h);
            this.j = this.d.generateColorMap(this.l);
        }
    }

    private double[] a(int radius) {
        int i2;
        double[] maxIntensityArray = new double[22];
        for (i2 = 5; i2 < 11; ++i2) {
            maxIntensityArray[i2] = HeatMapTileProvider.a(this.f, this.g, radius, (int)(1280.0 * Math.pow(2.0, i2 - 3)));
            if (i2 != 5) continue;
            for (int j2 = 0; j2 < i2; ++j2) {
                maxIntensityArray[j2] = maxIntensityArray[i2];
            }
        }
        for (i2 = 11; i2 < 22; ++i2) {
            maxIntensityArray[i2] = maxIntensityArray[10];
        }
        return maxIntensityArray;
    }

    private static ho b(Collection<WeightedLatLng> points) {
        Iterator<WeightedLatLng> iter = points.iterator();
        WeightedLatLng first = iter.next();
        double minX = first.getItemPoint().x;
        double maxX = first.getItemPoint().x;
        double minY = first.getItemPoint().y;
        double maxY = first.getItemPoint().y;
        while (iter.hasNext()) {
            WeightedLatLng l2 = iter.next();
            double x2 = l2.getItemPoint().x;
            double y2 = l2.getItemPoint().y;
            if (x2 < minX) {
                minX = x2;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y2 < minY) {
                minY = y2;
            }
            if (!(y2 > maxY)) continue;
            maxY = y2;
        }
        return new ho(minX, maxX, minY, maxY);
    }

    static double[] a(int radius, double sd) {
        double[] kernel = new double[radius * 2 + 1];
        for (int i2 = -radius; i2 <= radius; ++i2) {
            kernel[i2 + radius] = Math.exp((double)(-i2 * i2) / (2.0 * sd * sd));
        }
        return kernel;
    }

    private static double[][] a(double[][] grid, double[] kernel) {
        double val;
        int y2;
        int x2;
        int radius = (int)Math.floor((double)kernel.length / 2.0);
        int dimOld = grid.length;
        int dim = dimOld - 2 * radius;
        int upperLimit = radius + dim - 1;
        int n2 = dimOld;
        double[][] intermediate = new double[n2][n2];
        for (x2 = 0; x2 < dimOld; ++x2) {
            for (y2 = 0; y2 < dimOld; ++y2) {
                int x22;
                val = grid[x2][y2];
                if (val == 0.0) continue;
                int xUpperLimit = (upperLimit < x2 + radius ? upperLimit : x2 + radius) + 1;
                int n3 = x22 = radius > x2 - radius ? radius : x2 - radius;
                while (x22 < xUpperLimit) {
                    double[] dArray = intermediate[x22];
                    int n4 = y2;
                    dArray[n4] = dArray[n4] + val * kernel[x22 - (x2 - radius)];
                    ++x22;
                }
            }
        }
        int n5 = dim;
        double[][] outputGrid = new double[n5][n5];
        for (x2 = radius; x2 < upperLimit + 1; ++x2) {
            for (y2 = 0; y2 < dimOld; ++y2) {
                int y22;
                val = intermediate[x2][y2];
                if (val == 0.0) continue;
                int yUpperLimit = (upperLimit < y2 + radius ? upperLimit : y2 + radius) + 1;
                int n6 = y22 = radius > y2 - radius ? radius : y2 - radius;
                while (y22 < yUpperLimit) {
                    double[] dArray = outputGrid[x2 - radius];
                    int n7 = y22 - radius;
                    dArray[n7] = dArray[n7] + val * kernel[y22 - (y2 - radius)];
                    ++y22;
                }
            }
        }
        return outputGrid;
    }

    private static Bitmap a(double[][] grid, int[] colorMap, double max) {
        int maxColor = colorMap[colorMap.length - 1];
        double colorMapScaling = (double)(colorMap.length - 1) / max;
        int dim = grid.length;
        int[] colors = new int[dim * dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            for (int j2 = 0; j2 < dim; ++j2) {
                double val = grid[j2][i2];
                int index = i2 * dim + j2;
                int col = (int)(val * colorMapScaling);
                if (val != 0.0) {
                    if (col < colorMap.length) {
                        colors[index] = colorMap[col];
                        continue;
                    }
                    colors[index] = maxColor;
                    continue;
                }
                colors[index] = 0;
            }
        }
        int n2 = dim;
        Bitmap tile = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n3 = dim;
        tile.setPixels(colors, 0, dim, 0, 0, n3, n3);
        return tile;
    }

    private static double a(Collection<WeightedLatLng> points, ho bounds, int radius, int screenDim) {
        double maxX = bounds.c;
        double minX = bounds.a;
        double maxY = bounds.d;
        double minY = bounds.b;
        double boundsDim = maxX - minX > maxY - minY ? maxX - minX : maxY - minY;
        double scale = (double)((int)((double)(screenDim / (2 * radius)) + 0.5)) / boundsDim;
        LongSparseArray buckets = new LongSparseArray();
        double max = 0.0;
        for (WeightedLatLng l2 : points) {
            Double value;
            double x2 = l2.getItemPoint().x;
            double y2 = l2.getItemPoint().y;
            int xBucket = (int)((x2 - minX) * scale);
            int yBucket = (int)((y2 - minY) * scale);
            LongSparseArray column = (LongSparseArray)buckets.get((long)xBucket);
            if (column == null) {
                column = new LongSparseArray();
                buckets.put((long)xBucket, (Object)column);
            }
            if ((value = (Double)column.get((long)yBucket)) == null) {
                value = 0.0;
            }
            value = value + l2.getIntensity();
            column.put((long)yBucket, (Object)value);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private static Collection<WeightedLatLng> c(Collection<LatLng> data) {
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
        for (LatLng l2 : data) {
            weightedData.add(new WeightedLatLng(l2));
        }
        return weightedData;
    }

    /* synthetic */ HeatMapTileProvider(Builder x0, byte by2) {
        this(x0);
    }

    static /* synthetic */ double[] a(HeatMapTileProvider x0, double[] x1) {
        x0.k = x1;
        return x1;
    }

    static /* synthetic */ boolean f(HeatMapTileProvider x0) {
        x0.n = true;
        return true;
    }

    public static interface HeatTileGenerator {
        public double[] generateKernel(int var1);

        public int[] generateColorMap(double var1);
    }

    public static interface OnHeatMapReadyListener {
        public void onHeatMapReady();
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private int b = 40;
        private Gradient c = DEFAULT_GRADIENT;
        private double d = 0.6;
        private HeatTileGenerator e;
        private OnHeatMapReadyListener f;

        public Builder data(Collection<LatLng> val) {
            return this.weightedData(HeatMapTileProvider.c(val));
        }

        public Builder weightedData(Collection<WeightedLatLng> val) {
            if (val.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            this.a = val;
            return this;
        }

        public Builder gradient(Gradient val) {
            this.c = val;
            return this;
        }

        public Builder opacity(double val) {
            if (val < 0.0 || val > 1.0) {
                throw new IllegalArgumentException("Opacity must be in range [0, 1]");
            }
            this.d = val;
            return this;
        }

        public Builder radius(int radius) {
            if (radius < 10 || radius > 50) {
                throw new IllegalArgumentException("Radius not within bounds.");
            }
            this.b = radius;
            return this;
        }

        public Builder tileGenerator(HeatTileGenerator tileGenerator) {
            this.e = tileGenerator;
            return this;
        }

        public Builder readyListener(OnHeatMapReadyListener listener) {
            this.f = listener;
            return this;
        }

        public HeatMapTileProvider build() {
            if (this.a == null) {
                throw new IllegalStateException("No input data: you must use either .data or .weightedData before building");
            }
            return new HeatMapTileProvider(this, 0);
        }
    }
}

