/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;

@SuppressLint(value={"MissingPermission"})
public class NetUtil {
    public static final int TYPE_NET_WORK_DISABLED = 0;
    public static final int TYPE_CMWAP = 1;
    public static final int TYPE_UNIWAP = 2;
    public static final int TYPE_3GWAP = 3;
    public static final int TYPE_CTWAP = 4;
    public static final int TYPE_WIFI = 5;
    public static final int TYPE_OTHER_NET = 6;
    public static final String MAP_USER_AGENT = "QQ Map Mobile";
    public static final String STR_UserAgent = "androidsdk";

    public static NetworkInfo getNetworkInfo(Context ctx) {
        try {
            return ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getNetType(Context ctx) {
        NetworkInfo networkInfo = NetUtil.getNetworkInfo(ctx);
        if (networkInfo == null || !networkInfo.isAvailable()) {
            return 0;
        }
        int n2 = networkInfo.getType();
        if (n2 == 1) {
            return 5;
        }
        if (n2 != 0) {
            return 6;
        }
        String string = networkInfo.getExtraInfo();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 6;
        }
        if (string.equalsIgnoreCase("cmwap")) {
            return 1;
        }
        if (!string.equalsIgnoreCase("3gwap")) {
            if (string.equalsIgnoreCase("uniwap")) {
                return 2;
            }
            if (string.equalsIgnoreCase("ctwap")) {
                return 4;
            }
        }
        return 3;
    }

    public static String getNetTypeStr(Context ctx) {
        int netType = NetUtil.getNetType(ctx);
        String netTypeStr = "";
        switch (netType) {
            case 5: {
                netTypeStr = "wifi";
                break;
            }
            case 3: {
                netTypeStr = "3gwap";
                break;
            }
            case 2: {
                netTypeStr = "uniwap";
                break;
            }
            case 1: {
                netTypeStr = "cmwap";
                break;
            }
            case 4: {
                netTypeStr = "ctwap";
            }
        }
        return netTypeStr;
    }

    public static String getNetworkType(Context ctx) {
        try {
            NetworkInfo networkInfo = ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo != null) {
                int type = networkInfo.getType();
                if (type == 1) {
                    return "wifi";
                }
                if (type == 0) {
                    switch (networkInfo.getSubtype()) {
                        case 4: {
                            return "2g";
                        }
                        case 2: {
                            return "2g";
                        }
                        case 5: {
                            return "3g";
                        }
                        case 6: {
                            return "3g";
                        }
                        case 1: {
                            return "2g";
                        }
                        case 8: {
                            return "3g";
                        }
                        case 3: {
                            return "3g";
                        }
                    }
                    return "other";
                }
                return "other";
            }
            return "unknown";
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public static boolean isNetAvailable(Context ctx) {
        try {
            ConnectivityManager manager = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo active = NetUtil.getNetworkInfo(ctx);
            if (active != null) {
                return active.isAvailable();
            }
            for (NetworkInfo info : manager.getAllNetworkInfo()) {
                if (!info.isAvailable() || !info.isConnectedOrConnecting()) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean isWifi(Context ctx) {
        return NetUtil.getNetType(ctx) == 5;
    }

    public static boolean isMobile(Context ctx) {
        int netType = NetUtil.getNetType(ctx);
        return netType != 0 && netType != 5;
    }
}

