/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tencent.map.sdk.a.hn;
import com.tencent.map.sdk.a.hp;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public class LatLngBounds
implements Parcelable {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    public final LatLng northeast;
    public final LatLng southwest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new Parcelable.Creator<LatLngBounds>(){

        public final /* synthetic */ Object createFromParcel(@NonNull Parcel parcel) {
            return LatLngBounds.readFromParcel(parcel);
        }
    };

    private LatLngBounds(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        this.a = northLatitude;
        this.c = eastLongitude;
        this.b = southLatitude;
        this.d = westLongitude;
        this.northeast = new LatLng(northLatitude, eastLongitude);
        this.southwest = new LatLng(southLatitude, westLongitude);
    }

    public LatLngBounds(LatLng northeast, LatLng southwest) {
        this.northeast = northeast;
        this.southwest = southwest;
        this.a = northeast.latitude;
        this.c = northeast.longitude;
        this.b = southwest.latitude;
        this.d = southwest.longitude;
    }

    public static LatLngBounds world() {
        return LatLngBounds.from(90.0, 180.0, -90.0, -180.0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public LatLngBounds including(LatLng latlng) {
        return this.include(latlng);
    }

    @NonNull
    public LatLng getCenter() {
        double latCenter = (this.a + this.b) / 2.0;
        double longCenter = (this.c + this.d) / 2.0;
        return new LatLng(latCenter, longCenter);
    }

    public double getLatNorth() {
        return this.a;
    }

    public double getLatSouth() {
        return this.b;
    }

    public double getLonEast() {
        return this.c;
    }

    public double getLonWest() {
        return this.d;
    }

    @NonNull
    public LatLng getSouthWest() {
        return new LatLng(this.b, this.d);
    }

    @NonNull
    public LatLng getNorthEast() {
        return new LatLng(this.a, this.c);
    }

    @NonNull
    public LatLng getSouthEast() {
        return new LatLng(this.b, this.c);
    }

    @NonNull
    public LatLng getNorthWest() {
        return new LatLng(this.a, this.d);
    }

    @NonNull
    public hp getSpan() {
        return new hp(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public double getLatitudeSpan() {
        return Math.abs(this.a - this.b);
    }

    public double getLongitudeSpan() {
        return Math.abs(this.c - this.d);
    }

    public boolean isEmptySpan() {
        return this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
    }

    @NonNull
    public String toString() {
        return "N:" + this.a + "; E:" + this.c + "; S:" + this.b + "; W:" + this.d;
    }

    static LatLngBounds a(List<? extends LatLng> latLngs) {
        double minLat = 90.0;
        double minLon = Double.MAX_VALUE;
        double maxLat = -90.0;
        double maxLon = -1.7976931348623157E308;
        for (LatLng latLng : latLngs) {
            double latitude = latLng.getLatitude();
            double longitude = latLng.getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new LatLngBounds(maxLat, maxLon, minLat, minLon);
    }

    @NonNull
    public LatLng[] toLatLngs() {
        return new LatLng[]{this.getNorthEast(), this.getSouthWest()};
    }

    public static LatLngBounds from(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
        LatLngBounds.a(latNorth, lonEast, latSouth, lonWest);
        return new LatLngBounds(latNorth, lonEast, latSouth, lonWest);
    }

    private static void a(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
        if (Double.isNaN(latNorth) || Double.isNaN(latSouth)) {
            throw new IllegalArgumentException("latitude must not be NaN");
        }
        if (Double.isNaN(lonEast) || Double.isNaN(lonWest)) {
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        if (Double.isInfinite(lonEast) || Double.isInfinite(lonWest)) {
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        if (latNorth > 90.0 || latNorth < -90.0 || latSouth > 90.0 || latSouth < -90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        if (latNorth < latSouth) {
            throw new IllegalArgumentException("latNorth cannot be less than latSouth");
        }
        if (lonEast < lonWest) {
            throw new IllegalArgumentException("lonEast cannot be less than lonWest");
        }
    }

    private static double a(int z2, int y2) {
        double n2 = Math.PI - Math.PI * 2 * (double)y2 / Math.pow(2.0, z2);
        return Math.toDegrees(Math.atan(0.5 * (Math.exp(n2) - Math.exp(-n2))));
    }

    private static double b(int z2, int x2) {
        return (double)x2 / Math.pow(2.0, z2) * 360.0 - 180.0;
    }

    public static LatLngBounds from(int z2, int x2, int y2) {
        return new LatLngBounds(LatLngBounds.a(z2, y2), LatLngBounds.b(z2, x2 + 1), LatLngBounds.a(z2, y2 + 1), LatLngBounds.b(z2, x2));
    }

    @NonNull
    public LatLngBounds include(@NonNull LatLng latLng) {
        return new Builder().include(this.getNorthEast()).include(this.getSouthWest()).include(latLng).build();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof LatLngBounds) {
            LatLngBounds other = (LatLngBounds)o2;
            return this.a == other.getLatNorth() && this.b == other.getLatSouth() && this.c == other.getLonEast() && this.d == other.getLonWest();
        }
        return false;
    }

    public boolean contains(@NonNull LatLng latLng) {
        double d2 = latLng.getLatitude();
        LatLngBounds latLngBounds = this;
        if (d2 <= latLngBounds.a && d2 >= latLngBounds.b) {
            d2 = latLng.getLongitude();
            latLngBounds = this;
            if (d2 <= latLngBounds.c && d2 >= latLngBounds.d) {
                return true;
            }
        }
        return false;
    }

    public boolean contains(@NonNull LatLngBounds other) {
        return this.contains(other.getNorthEast()) && this.contains(other.getSouthWest());
    }

    @NonNull
    public LatLngBounds union(@NonNull LatLngBounds bounds) {
        return this.b(bounds.getLatNorth(), bounds.getLonEast(), bounds.getLatSouth(), bounds.getLonWest());
    }

    @NonNull
    public LatLngBounds union(double northLat, double eastLon, double southLat, double westLon) {
        LatLngBounds.a(northLat, eastLon, southLat, westLon);
        return this.b(northLat, eastLon, southLat, westLon);
    }

    private LatLngBounds b(double northLat, double eastLon, double southLat, double westLon) {
        return new LatLngBounds(this.a < northLat ? northLat : this.a, this.c < eastLon ? eastLon : this.c, this.b > southLat ? southLat : this.b, this.d > westLon ? westLon : this.d);
    }

    @Nullable
    public LatLngBounds intersect(@NonNull LatLngBounds box) {
        return this.c(box.getLatNorth(), box.getLonEast(), box.getLatSouth(), box.getLonWest());
    }

    @NonNull
    public LatLngBounds intersect(double northLat, double eastLon, double southLat, double westLon) {
        LatLngBounds.a(northLat, eastLon, southLat, westLon);
        return this.c(northLat, eastLon, southLat, westLon);
    }

    private LatLngBounds c(double northLat, double eastLon, double southLat, double westLon) {
        double d2;
        double minLonWest = Math.max(this.d, westLon);
        double maxLonEast = Math.min(this.c, eastLon);
        if (d2 >= minLonWest) {
            double d3;
            double minLatSouth = Math.max(this.b, southLat);
            double maxLatNorth = Math.min(this.a, northLat);
            if (d3 >= minLatSouth) {
                return new LatLngBounds(maxLatNorth, maxLonEast, minLatSouth, minLonWest);
            }
        }
        return null;
    }

    public int hashCode() {
        return (int)(this.a + 90.0 + (this.b + 90.0) * 1000.0 + (this.c + 180.0) * 1000000.0 + (this.d + 180.0) * 1.0E9);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeDouble(this.a);
        out.writeDouble(this.c);
        out.writeDouble(this.b);
        out.writeDouble(this.d);
    }

    protected static LatLngBounds readFromParcel(Parcel in2) {
        double northLat = in2.readDouble();
        double eastLon = in2.readDouble();
        double southLat = in2.readDouble();
        double westLon = in2.readDouble();
        return new LatLngBounds(northLat, eastLon, southLat, westLon);
    }

    public static final class Builder {
        private final List<LatLng> a = new ArrayList<LatLng>();

        public final LatLngBounds build() {
            if (this.a.size() < 2) {
                throw new hn(this.a.size());
            }
            return LatLngBounds.a(this.a);
        }

        @NonNull
        public final Builder include(@NonNull List<LatLng> latLngs) {
            this.a.addAll(latLngs);
            return this;
        }

        @NonNull
        public final Builder include(@NonNull LatLng latLng) {
            this.a.add(latLng);
            return this;
        }
    }
}

