/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.RoutePlanningParam;
import com.tencent.lbssearch.object.result.DrivingResultObject;
import com.tencent.mapsdk.internal.gz;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DrivingParam
extends RoutePlanningParam {
    private static final int MAX_WAT_POINTS = 10;
    private List<LatLng> waypoints = new ArrayList<LatLng>();
    private String policy;
    private String carNumber;
    private String fromPOI;
    private int heading = -1;
    private int speed = -1;
    private int accuracy = -1;
    private RoadType roadType = RoadType.DEF;
    private Travel fromTravel;
    private CarType carType = CarType.DEF;
    private int noStep = 0;
    private boolean trafficSpeed;
    private List<List<LatLng>> avoidPolygons;
    private int multRoute;
    private final Set<String> mExtraFields = new HashSet<String>();
    private boolean cache;

    public DrivingParam() {
    }

    public DrivingParam(LatLng from, LatLng to) {
        super(from, to);
    }

    public DrivingParam fromTravel(Travel travel) {
        this.fromTravel = travel;
        return this;
    }

    public DrivingParam fromPOI(String fromPOI) {
        this.fromPOI = fromPOI;
        return this;
    }

    @Override
    public DrivingParam toPOI(String toPOI) {
        return (DrivingParam)super.toPOI(toPOI);
    }

    public DrivingParam heading(int heading) {
        this.heading = heading;
        return this;
    }

    public DrivingParam speed(int speed) {
        this.speed = speed;
        return this;
    }

    public DrivingParam accuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public DrivingParam roadType(RoadType roadType) {
        this.roadType = roadType;
        return this;
    }

    public void setMultyPlan(boolean isMultyPlan) {
    }

    public DrivingParam trafficSpeed(boolean enable) {
        this.trafficSpeed = enable;
        return this;
    }

    public DrivingParam policy(Policy policy, Preference ... preferences) {
        StringBuilder stringBuilder = new StringBuilder();
        if (policy != null) {
            stringBuilder.append(policy.name());
        }
        if (preferences != null && preferences.length > 0) {
            Preference[] preferenceArray = preferences;
            int n2 = preferences.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Preference preference = preferenceArray[i2];
                stringBuilder.append(",").append(preference.name());
            }
        }
        this.policy = stringBuilder.toString();
        return this;
    }

    public DrivingParam policy(RoutePlanningParam.DrivingPolicy policy) {
        StringBuilder stringBuilder = new StringBuilder();
        if (policy != null) {
            stringBuilder.append(policy.name());
        }
        this.policy = stringBuilder.toString();
        return this;
    }

    public DrivingParam addWayPoint(LatLng l2) {
        if (this.waypoints.size() < 10) {
            this.waypoints.add(l2);
        }
        return this;
    }

    public DrivingParam addWayPoints(Iterable<LatLng> ls2) {
        if (ls2 != null) {
            int i2 = 0;
            for (LatLng l2 : ls2) {
                this.waypoints.add(l2);
                if (++i2 <= 10) continue;
                return this;
            }
        }
        return this;
    }

    public DrivingParam setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public DrivingParam setCarType(CarType carType) {
        this.carType = carType;
        return this;
    }

    public DrivingParam setNoStep(int noStep) {
        this.noStep = noStep;
        return this;
    }

    public DrivingParam setAvoidPolygons(List<List<LatLng>> avoidPolygons) {
        this.avoidPolygons = avoidPolygons;
        return this;
    }

    public DrivingParam setMultRoute(int multRoute) {
        this.multRoute = multRoute;
        return this;
    }

    public DrivingParam setExtraFields(String ... extraFields) {
        this.mExtraFields.addAll(Arrays.asList(extraFields));
        return this;
    }

    public DrivingParam cache(boolean enable) {
        this.cache = enable;
        return this;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = super.buildParameters();
        if (!TextUtils.isEmpty((CharSequence)this.fromPOI)) {
            params.put("from_poi", this.fromPOI);
        }
        if (this.heading != -1) {
            params.put("heading", this.heading);
        }
        if (this.speed != -1) {
            params.put("speed", this.speed);
        }
        if (this.accuracy != -1) {
            params.put("accuracy", this.accuracy);
        }
        if (this.trafficSpeed) {
            params.put("get_speed", 1);
        }
        params.put("road_type", this.roadType.ordinal());
        params.put("no_step", this.noStep);
        params.put("get_mp", this.multRoute);
        if (this.fromTravel != null && this.fromTravel.points.size() > 0) {
            params.put("from_track", this.fromTravel.toString());
        }
        if (this.waypoints.size() > 0) {
            StringBuilder b2 = new StringBuilder();
            for (LatLng l2 : this.waypoints) {
                b2.append(this.locationToParamsString(l2));
                b2.append(";");
            }
            StringBuilder stringBuilder = b2;
            stringBuilder.setLength(stringBuilder.length() - 1);
            params.put("waypoints", b2.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.policy)) {
            params.put("policy", this.policy);
        }
        if (!TextUtils.isEmpty((CharSequence)this.carNumber)) {
            params.put("plate_number", this.carNumber);
        }
        params.put("car_type", this.carType.ordinal());
        if (!this.mExtraFields.isEmpty()) {
            params.put("added_fields", gz.a(this.mExtraFields, ","));
        }
        params.put("is_cache", this.cache ? "1" : "0");
        if (this.avoidPolygons != null) {
            StringBuffer points = new StringBuffer();
            for (int i2 = 0; i2 < this.avoidPolygons.size(); ++i2) {
                List<LatLng> polygon = this.avoidPolygons.get(i2);
                for (int j2 = 0; j2 < polygon.size(); ++j2) {
                    LatLng p2 = polygon.get(j2);
                    points.append(p2.latitude).append(',').append(p2.longitude);
                    if (j2 == polygon.size() - 1) continue;
                    points.append(';');
                }
                if (i2 == this.avoidPolygons.size() - 1) continue;
                points.append('|');
            }
            params.put("avoid_polygons", points.toString());
        }
        return params;
    }

    @Override
    public String getUrl() {
        return "https://apis.map.qq.com/ws/direction/v1/driving";
    }

    public Class<DrivingResultObject> getResultClass() {
        return DrivingResultObject.class;
    }

    public static class Travel {
        public List<Point> points = new ArrayList<Point>();

        public void addPoints(Point ... points) {
            if (points != null) {
                this.points.addAll(Arrays.asList(points));
            }
        }

        public String toString() {
            int count = this.points.size();
            if (count > 50) {
                count = 50;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < count; ++i2) {
                stringBuilder.append(this.points.get(i2)).append(";");
            }
            return super.toString();
        }

        public static class Point {
            private LatLng latLng;
            private int speed = -1;
            private int accuracy = -1;
            private int directionOfCar = -1;
            private int directionOfDevice = -1;
            private int time = 0;

            public Point(LatLng latLng) {
                this.latLng = latLng;
            }

            public Point setSpeed(int speed) {
                this.speed = speed;
                return this;
            }

            public Point setAccuracy(int accuracy) {
                this.accuracy = accuracy;
                return this;
            }

            public Point setDirectionOfCar(int directionOfCar) {
                this.directionOfCar = directionOfCar;
                return this;
            }

            public Point setDirectionOfDevice(int directionOfDevice) {
                this.directionOfDevice = directionOfDevice;
                return this;
            }

            public Point setTime(int time) {
                this.time = time;
                return this;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.latLng != null) {
                    stringBuilder.append(this.latLng.latitude).append(",");
                    stringBuilder.append(this.latLng.longitude).append(",");
                }
                stringBuilder.append(this.speed).append(",");
                stringBuilder.append(this.accuracy).append(",");
                stringBuilder.append(this.directionOfCar).append(",");
                stringBuilder.append(this.directionOfDevice).append(",");
                stringBuilder.append(this.time);
                return stringBuilder.toString();
            }
        }
    }

    public static enum CarType {
        DEF,
        NEW_ENERGY;

    }

    public static enum RoadType {
        DEF,
        ABOVE_BRIDGE,
        BELOW_BRIDGE,
        ON_MAIN_ROAD,
        ON_SIDE_ROAD,
        OPPOSITE_SIDE,
        ON_MAIN_ROAD_BELOW_BRIDGE,
        ON_SIDE_ROAD_BELOW_BRIDGE;

    }

    public static enum Preference {
        REAL_TRAFFIC,
        LEAST_FEE,
        AVOID_HIGHWAY,
        NAV_POINT_FIRST;

    }

    public static enum Policy {
        LEAST_TIME,
        PICKUP,
        TRIP;

    }
}

