/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.graphics.Color;
import android.support.annotation.Keep;
import com.tencent.map.sdk.utilities.visualization.datamodels.FromToLatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Keep
public class ArcLineOverlayInfo {
    protected int mType = 0;
    protected FromToLatLng[] notes;
    protected int[] nodeIndexes;
    protected int mZIndex = 0;
    protected int activeIndex = 0;
    protected float mOpacity = 1.0f;
    private static final float DEFAULT_MIN_OPACITY = 0.0f;
    private static final float DEFAULT_MAX_OPACITY = 1.0f;
    protected boolean mVisibility = true;
    protected int mMinZoom = 3;
    protected int mMaxZoom = 22;
    protected int mDisplayLevel = 1;
    protected float mWidth = 4.0f;
    protected int[] mColors = new int[]{Color.argb((int)255, (int)0, (int)255, (int)170), Color.argb((int)255, (int)0, (int)255, (int)170), Color.argb((int)255, (int)0, (int)255, (int)170)};
    protected float[] mColorPoints = new float[]{0.0f, 0.5f, 1.0f};
    protected int mColorMapSize = 200;
    protected boolean mDraw3D = false;
    protected boolean mAnimate = false;
    protected int mHighLightDuration = 5000;
    protected int mAnimateDuration = 5000;
    protected int mAnimateColor = -16776961;

    public ArcLineOverlayInfo() {
        this.notes = new FromToLatLng[0];
        this.nodeIndexes = new int[0];
    }

    public void setDataList(List<Collection<FromToLatLng>> dataList) {
        if (dataList == null || dataList.size() == 0) {
            this.notes = new FromToLatLng[0];
            this.nodeIndexes = new int[0];
            return;
        }
        this.nodeIndexes = new int[dataList.size()];
        ArrayList<FromToLatLng> allData = new ArrayList<FromToLatLng>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            Collection<FromToLatLng> latLngs = dataList.get(i2);
            this.nodeIndexes[i2] = latLngs.size();
            allData.addAll(latLngs);
        }
        this.notes = allData.toArray(new FromToLatLng[0]);
    }

    public void setzIndex(int zIndex) {
        this.mZIndex = zIndex;
    }

    public void setDisplayLevel(int displayLevel) {
        if (displayLevel == 1 || displayLevel == 2) {
            this.mDisplayLevel = displayLevel;
        }
    }

    public void setType(int type) {
        this.mType = type;
    }

    public void setNodes(FromToLatLng[] nodes) {
        this.notes = nodes;
    }

    public void setOpacity(float opacity) {
        if (opacity > 1.0f) {
            this.mOpacity = 1.0f;
            return;
        }
        if (opacity < 0.0f) {
            this.mOpacity = 0.0f;
            return;
        }
        this.mOpacity = opacity;
    }

    public void setVisibility(boolean visibility) {
        this.mVisibility = visibility;
    }

    public void setActiveDataIndex(int index) {
        this.activeIndex = index;
    }

    public void setMinZoom(int minZoom) {
        this.mMinZoom = minZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.mMaxZoom = maxZoom;
    }

    public void setWidth(float width) {
        this.mWidth = width;
    }

    public void setDraw3D(boolean draw3D) {
        this.mDraw3D = draw3D;
    }

    public void setAnimate(boolean animate) {
        this.mAnimate = animate;
    }

    public void setHighLightDuration(int highLightDuration) {
        this.mHighLightDuration = highLightDuration;
    }

    public void setAnimateDuration(int animateDuration) {
        this.mAnimateDuration = animateDuration;
    }

    public boolean getIsAnimate() {
        return this.mAnimate;
    }

    public void setAnimateColor(int animateColor) {
        this.mAnimateColor = animateColor;
    }

    public int getAnimateColor() {
        return this.mAnimateColor;
    }
}

