/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.support.annotation.Keep;
import com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Keep
public class HeatmapInfo {
    protected WeightedLatLng[] notes = new WeightedLatLng[0];
    protected int[] nodeIndexes = new int[0];
    protected int activeIndex = 0;
    protected int radius;
    protected int[] colors;
    protected float[] colorPoints;
    protected int colorMapSize;
    protected boolean visible;
    protected int minZoom;
    protected int maxZoom;
    protected float opacity;
    private static final float DEFAULT_MIN_OPACITY = 0.0f;
    private static final float DEFAULT_MAX_OPACITY = 1.0f;
    protected int level = 1;
    protected int zIndex = 0;
    protected int sample = 4;
    protected float maxHeight = 1000.0f;
    protected boolean draw3D = false;
    protected boolean intensityFlag = false;
    protected float maxIntensity = 0.0f;
    protected float minIntensity = 0.0f;
    protected boolean mAnimate = false;
    protected int mAnimateDuration = 5000;

    public void setDataList(List<Collection<WeightedLatLng>> dataList) {
        if (dataList == null) {
            this.notes = new WeightedLatLng[0];
            this.nodeIndexes = new int[0];
            return;
        }
        this.nodeIndexes = new int[dataList.size()];
        ArrayList<WeightedLatLng> allData = new ArrayList<WeightedLatLng>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            Collection<WeightedLatLng> latLngs = dataList.get(i2);
            this.nodeIndexes[i2] = latLngs.size();
            allData.addAll(latLngs);
        }
        this.notes = allData.toArray(new WeightedLatLng[0]);
    }

    public void setActiveIndex(int activeIndex) {
        this.activeIndex = activeIndex;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setColors(int[] colors) {
        this.colors = colors;
    }

    public void setColorPoints(float[] colorPoints) {
        this.colorPoints = colorPoints;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setOpacity(float opacity) {
        if (opacity > 1.0f) {
            this.opacity = 1.0f;
            return;
        }
        if (opacity < 0.0f) {
            this.opacity = 0.0f;
            return;
        }
        this.opacity = opacity;
    }

    public void setLevel(int level) {
        if (level == 1 || level == 2) {
            this.level = level;
        }
    }

    public void setzIndex(int zIndex) {
        this.zIndex = zIndex;
    }

    public void setSample(int sample) {
        this.sample = sample;
    }

    public void setMaxHeight(float maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setDraw3D(boolean draw3D) {
        this.draw3D = draw3D;
    }

    public void setAnimate(boolean animate) {
        this.mAnimate = animate;
    }

    public void setAnimateTime(int animateDuration) {
        this.mAnimateDuration = animateDuration;
    }

    public boolean isAnimate() {
        return this.mAnimate;
    }
}

