/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import com.tencent.map.lib.models.AccessibleTouchItem;
import java.util.ArrayList;
import java.util.List;

public abstract class MapExploreByTouchHelper
extends ExploreByTouchHelper {
    protected static final int MAP_ACTION_CLICKED = 1;
    protected static final int NO_ITEM = -1;
    public List<AccessibleTouchItem> accessibleTouchItems = new ArrayList<AccessibleTouchItem>();

    public MapExploreByTouchHelper(@NonNull View host) {
        super(host);
    }

    protected int getVirtualViewAt(float x2, float y2) {
        int index = this.getTargetPoiItemIdx(x2, y2);
        if (index == -1) {
            return Integer.MIN_VALUE;
        }
        return index;
    }

    protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
        for (int i2 = 0; i2 < this.accessibleTouchItems.size(); ++i2) {
            virtualViewIds.add(i2);
        }
    }

    protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
        if (virtualViewId >= this.accessibleTouchItems.size()) {
            event.getText().add("");
            return;
        }
        AccessibleTouchItem item = this.accessibleTouchItems.get(virtualViewId);
        if (item == null) {
            throw new IllegalArgumentException("Invalid virtual view id");
        }
        event.getText().add(item.getContentDescription());
    }

    protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
        if (virtualViewId >= this.accessibleTouchItems.size()) {
            node.setText((CharSequence)"");
            node.setBoundsInParent(new Rect());
            return;
        }
        AccessibleTouchItem item = this.accessibleTouchItems.get(virtualViewId);
        if (item == null) {
            throw new IllegalArgumentException("Invalid virtual view id");
        }
        node.setText((CharSequence)item.getContentDescription());
        node.setBoundsInParent(item.getBounds());
        node.addAction(16);
    }

    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
        if (action == 16) {
            return this.onItemClicked(virtualViewId);
        }
        return false;
    }

    public void onTalkBackActivate(View view) {
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)this);
    }

    public void onTalkBackDeActivate(View view) {
        ViewCompat.setAccessibilityDelegate((View)view, null);
    }

    protected abstract int getTargetPoiItemIdx(float var1, float var2);

    protected abstract boolean onItemClicked(int var1);
}

