/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.graphics.Bitmap;
import android.support.annotation.Keep;
import com.tencent.map.sdk.utilities.visualization.datamodels.ScatterLatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Keep
public class ScatterPlotInfo {
    protected ScatterLatLng[] notes = new ScatterLatLng[0];
    protected int[] nodeIndexes = new int[0];
    protected int activeIndex = 0;
    protected int mType = 0;
    protected int radius;
    protected boolean visible;
    protected int minZoom;
    protected int maxZoom;
    protected float opacity;
    protected int level = 1;
    protected int zIndex = 0;
    protected boolean draw3D = false;
    protected int[] colors;
    protected float[] colorsPoints;
    protected double[] circleStartPoints;
    protected int colorMapSize = 200;
    protected boolean mAnimate = false;
    protected Bitmap[] mBitmaps = new Bitmap[0];
    protected int mBitmapHeight;
    protected int mBitmapWidth;
    protected float minIntensity;
    protected float maxIntensity;
    protected boolean intensityFlag = false;
    protected int mMinRadius = 0;
    protected int mMaxRadius = 30;
    protected int mStrokeColor = -1;
    protected int mStrokeWidth = 4;

    public void setDataList(List<Collection<ScatterLatLng>> dataList) {
        if (dataList == null) {
            this.notes = new ScatterLatLng[0];
            this.nodeIndexes = new int[0];
            return;
        }
        this.nodeIndexes = new int[dataList.size()];
        ArrayList<ScatterLatLng> allData = new ArrayList<ScatterLatLng>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            Collection<ScatterLatLng> latLngs = dataList.get(i2);
            this.nodeIndexes[i2] = latLngs.size();
            allData.addAll(latLngs);
        }
        this.notes = allData.toArray(new ScatterLatLng[0]);
    }

    public void setActiveIndex(int activeIndex) {
        this.activeIndex = activeIndex;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setzIndex(int zIndex) {
        this.zIndex = zIndex;
    }

    public void setDraw3D(boolean draw3D) {
        this.draw3D = draw3D;
    }

    public void setColors(int[] colors) {
        this.colors = colors;
    }

    public void setColorsPoints(float[] colorsPoints) {
        this.colorsPoints = colorsPoints;
    }

    public void setColorsPoints(double[] startPoints) {
        this.circleStartPoints = startPoints;
    }

    public void setAnimate(boolean animate) {
        this.mAnimate = animate;
    }

    public boolean isAnimate() {
        return this.mAnimate;
    }
}

