/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.support.annotation.Keep;
import com.tencent.map.sdk.utilities.visualization.datamodels.TrailLatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Keep
public class TrailOverlayInfo {
    protected int mType = 0;
    protected TrailLatLng[] notes = new TrailLatLng[0];
    protected int[] nodeIndexes = new int[0];
    protected int mZIndex = 0;
    protected int activeIndex = 0;
    protected float mOpacity = 1.0f;
    protected boolean mVisibility = true;
    protected int mMinZoom = 3;
    protected int mMaxZoom = 22;
    protected int mDisplayLevel = 1;
    protected float mWidth = 4.0f;
    protected boolean mAnimate = true;
    protected int mHighLightDuration = 5000;
    protected int mAnimateStartTime = 0;
    protected int mAnimateEndTime = 2000;
    protected int mAnimateColor = -16776961;
    protected int[] colors;
    protected float[] colorPoints;
    protected int colorMapSize = 200;
    protected float mPlayRatio = 1.0f;
    protected int mPulseInterval = 200;

    public void setDataList(List<Collection<TrailLatLng>> dataList) {
        if (dataList == null || dataList.size() == 0) {
            this.notes = new TrailLatLng[0];
            this.nodeIndexes = new int[0];
            return;
        }
        this.nodeIndexes = new int[dataList.size()];
        ArrayList<TrailLatLng> allData = new ArrayList<TrailLatLng>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            Collection<TrailLatLng> latLngs = dataList.get(i2);
            this.nodeIndexes[i2] = latLngs.size();
            allData.addAll(latLngs);
        }
        this.notes = allData.toArray(new TrailLatLng[0]);
    }

    public void setzIndex(int zIndex) {
        this.mZIndex = zIndex;
    }

    public void setDisplayLevel(int displayLevel) {
        this.mDisplayLevel = displayLevel;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public void setNodes(TrailLatLng[] nodes) {
        this.notes = nodes;
    }

    public void setOpacity(float opacity) {
        this.mOpacity = opacity;
    }

    public void setVisibility(boolean visibility) {
        this.mVisibility = visibility;
    }

    public void setActiveDataIndex(int index) {
        this.activeIndex = index;
    }

    public void setMinZoom(int minZoom) {
        this.mMinZoom = minZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.mMaxZoom = maxZoom;
    }

    public void setWidth(float width) {
        this.mWidth = width;
    }

    public void setAnimate(boolean animate) {
        this.mAnimate = animate;
    }

    public void setHighLightDuration(int highLightDuration) {
        this.mHighLightDuration = highLightDuration;
    }

    public void setAnimateStartTime(int animateStartTime) {
        this.mAnimateStartTime = animateStartTime;
    }

    public void setAnimateEndTime(int animateEndTime) {
        this.mAnimateEndTime = animateEndTime;
    }

    public boolean getIsAnimate() {
        return this.mAnimate;
    }

    public void setAnimateColor(int animateColor) {
        this.mAnimateColor = animateColor;
    }

    public int getAnimateColor() {
        return this.mAnimateColor;
    }

    public void setPlayRatio(float playRatio) {
        this.mPlayRatio = playRatio;
    }
}

