/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.heatmap;

import android.graphics.Color;
import com.tencent.map.sdk.utilities.heatmap.Gradient;
import com.tencent.map.sdk.utilities.heatmap.WeightedLatLng;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.TileProvider;
import java.util.ArrayList;
import java.util.Collection;

public abstract class HeatMapTileProvider
implements TileProvider {
    public static final int DEFAULT_RADIUS = 40;
    public static final double DEFAULT_OPACITY = 0.6;
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.argb((int)0, (int)25, (int)0, (int)255), Color.argb((int)170, (int)30, (int)0, (int)255), Color.rgb((int)0, (int)191, (int)255), Color.rgb((int)0, (int)255, (int)0), Color.rgb((int)255, (int)255, (int)0), Color.rgb((int)255, (int)0, (int)0)};
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.0f, 0.4f, 0.6f, 0.75f, 0.8f, 1.0f};
    public static final Gradient DEFAULT_GRADIENT = new Gradient(DEFAULT_GRADIENT_COLORS, DEFAULT_GRADIENT_START_POINTS);
    private static final int MIN_RADIUS = 10;
    private static final int MAX_RADIUS = 50;
    static final double WORLD_WIDTH = 1.0;

    public abstract <T extends com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng> void setWeightedData(Collection<T> var1);

    public abstract void setData(Collection<LatLng> var1);

    public abstract void setGradient(Gradient var1);

    public abstract void setRadius(int var1);

    public abstract void setOpacity(double var1);

    public abstract void setHeatTileGenerator(HeatTileGenerator var1);

    private static Collection<WeightedLatLng> wrapData(Collection<LatLng> data) {
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
        for (LatLng l2 : data) {
            weightedData.add(new WeightedLatLng(l2));
        }
        return weightedData;
    }

    public static interface HeatTileGenerator {
        public double[] generateKernel(int var1);

        public int[] generateColorMap(double var1);
    }

    public static interface OnHeatMapReadyListener {
        public void onHeatMapReady();
    }

    public static class Builder {
        private Collection<WeightedLatLng> data;
        private int radius = 40;
        private Gradient gradient = DEFAULT_GRADIENT;
        private double opacity = 0.6;
        private HeatTileGenerator heatTileGenerator;
        private OnHeatMapReadyListener readyListener;

        public Builder data(Collection<LatLng> val) {
            return this.weightedData(HeatMapTileProvider.wrapData(val));
        }

        public <T extends com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng> Builder weightedData(Collection<T> val) {
            if (val.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
            for (com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng l2 : val) {
                weightedData.add(new WeightedLatLng(l2.getPoint(), l2.getIntensity()));
            }
            this.data = weightedData;
            return this;
        }

        public Builder gradient(Gradient val) {
            this.gradient = val;
            return this;
        }

        public Builder opacity(double val) {
            if (val < 0.0 || val > 1.0) {
                throw new IllegalArgumentException("Opacity must be in range [0, 1]");
            }
            this.opacity = val;
            return this;
        }

        public Builder radius(int radius) {
            if (radius < 10 || radius > 50) {
                throw new IllegalArgumentException("Radius not within bounds.");
            }
            this.radius = radius;
            return this;
        }

        public Builder tileGenerator(HeatTileGenerator tileGenerator) {
            this.heatTileGenerator = tileGenerator;
            return this;
        }

        public Builder readyListener(OnHeatMapReadyListener listener) {
            this.readyListener = listener;
            return this;
        }

        public Collection<WeightedLatLng> getData() {
            return this.data;
        }

        public int getRadius() {
            return this.radius;
        }

        public Gradient getGradient() {
            return this.gradient;
        }

        public double getOpacity() {
            return this.opacity;
        }

        public HeatTileGenerator getHeatTileGenerator() {
            return this.heatTileGenerator;
        }

        public OnHeatMapReadyListener getReadyListener() {
            return this.readyListener;
        }

        public HeatMapTileProvider build(TencentMap map) {
            if (map != null) {
                return map.getMapContext().createHeatMapTileProvider(this);
            }
            return null;
        }
    }
}

