/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization;

import com.tencent.tencentmap.mapsdk.maps.model.VectorOverlayProvider;

public abstract class BaseOverlayProvider
implements VectorOverlayProvider {
    protected float mOpacity = 1.0f;
    private static final float DEFAULT_MIN_OPACITY = 0.0f;
    private static final float DEFAULT_MAX_OPACITY = 1.0f;
    private static final float DEFAULT_OPACITY = 1.0f;
    protected boolean mVisibility = true;
    protected int mMinZoom = 4;
    protected int mMaxZoom = 22;
    private static final int DEFAULT_MIN_ZOOM = 3;
    private static final int DEFAULT_MAX_ZOOM = 22;
    protected int mDisplayLevel = 1;
    protected int mZIndex = 0;
    private static final int DEFAULT_ZINDEX = 0;

    @Override
    public BaseOverlayProvider opacity(float opacity) {
        this.mOpacity = opacity > 1.0f ? 1.0f : (opacity < 0.0f ? 0.0f : opacity);
        return this;
    }

    @Override
    public BaseOverlayProvider visibility(boolean visibility) {
        this.mVisibility = visibility;
        return this;
    }

    @Override
    public BaseOverlayProvider minZoom(int minZoom) {
        this.mMinZoom = minZoom >= 3 ? minZoom : 3;
        return this;
    }

    @Override
    public BaseOverlayProvider maxZoom(int maxZoom) {
        this.mMaxZoom = maxZoom <= 22 ? maxZoom : 22;
        return this;
    }

    @Override
    public BaseOverlayProvider displayLevel(int displayLevel) {
        if (displayLevel == 1 || displayLevel == 2) {
            this.mDisplayLevel = displayLevel;
        }
        return this;
    }

    @Override
    public BaseOverlayProvider zIndex(int zIndex) {
        this.mZIndex = zIndex;
        return this;
    }

    @Override
    public float getOpacity() {
        return this.mOpacity;
    }

    @Override
    public boolean isVisibility() {
        return this.mVisibility;
    }

    @Override
    public int getMinZoom() {
        return this.mMinZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    @Override
    public int getZIndex() {
        return this.mZIndex;
    }

    @Override
    public int getDisplayLevel() {
        return this.mDisplayLevel;
    }

    public String toString() {
        return "BaseOverlayProvider{mOpacity=" + this.mOpacity + ", mVisibility=" + this.mVisibility + ", mMinZoom=" + this.mMinZoom + ", mMaxZoom=" + this.mMaxZoom + ", mDisplayLevel=" + this.mDisplayLevel + ", mZIndex=" + this.mZIndex + '}';
    }
}

