/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization.od;

import android.graphics.Color;
import com.tencent.map.sdk.utilities.visualization.BaseOverlayProvider;
import com.tencent.map.sdk.utilities.visualization.datamodels.FromToLatLng;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ArcLineOverlayProvider
extends BaseOverlayProvider {
    private List<FromToLatLng> dataList = new ArrayList<FromToLatLng>();
    private float mWidth = 6.0f;
    private float mRadian = 45.0f;
    private boolean mDraw3D = false;
    private boolean mAnimate = true;
    private int mHighLightDuration = 200;
    private int mAnimationDuration = 2000;
    private int mAnimateColor = -10046465;
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.argb((int)255, (int)0, (int)128, (int)255), Color.argb((int)51, (int)0, (int)170, (int)255), Color.argb((int)255, (int)0, (int)128, (int)255)};
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.0f, 0.5f, 1.0f};
    private static final int DEFAULT_COLOR_MAP_SIZE = 200;
    private int[] mColors = DEFAULT_GRADIENT_COLORS;
    private float[] mColorPoints = DEFAULT_GRADIENT_START_POINTS;
    protected int mColorMapSize = 200;

    public final List<FromToLatLng> getData() {
        return this.dataList;
    }

    public final ArcLineOverlayProvider data(List<FromToLatLng> val) {
        if (val != null) {
            this.dataList = val;
        }
        return this;
    }

    @Override
    public final float getOpacity() {
        return super.getOpacity();
    }

    @Override
    public final ArcLineOverlayProvider opacity(float opacity) {
        super.opacity(opacity);
        return this;
    }

    @Override
    public final int getZIndex() {
        return super.getZIndex();
    }

    @Override
    public final ArcLineOverlayProvider zIndex(int zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    @Override
    public final int getDisplayLevel() {
        return super.getDisplayLevel();
    }

    @Override
    public final ArcLineOverlayProvider displayLevel(int displayLevel) {
        super.displayLevel(displayLevel);
        return this;
    }

    @Override
    public final boolean isVisibility() {
        return super.isVisibility();
    }

    @Override
    public final ArcLineOverlayProvider visibility(boolean visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public final int getMinZoom() {
        return super.getMinZoom();
    }

    @Override
    public final int getMaxZoom() {
        return super.getMaxZoom();
    }

    public final ArcLineOverlayProvider zoomRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            super.minZoom(minZoom);
            super.maxZoom(maxZoom);
        }
        return this;
    }

    public final ArcLineOverlayProvider gradient(int[] colors) {
        if (colors != null) {
            if (colors.length == 1) {
                this.mColors = new int[]{colors[0], colors[0], colors[0]};
                this.mColorPoints = new float[]{0.0f, 0.5f, 1.0f};
            } else if (colors.length == 2) {
                this.mColors = colors;
                this.mColorPoints = new float[]{0.0f, 1.0f};
            } else if (colors.length == 3) {
                this.mColors = colors;
                this.mColorPoints = new float[]{0.0f, 0.5f, 1.0f};
            }
        }
        return this;
    }

    public final int[] getColors() {
        return this.mColors;
    }

    public final float[] getColorPoints() {
        return this.mColorPoints;
    }

    public final int getColorMapSize() {
        return this.mColorMapSize;
    }

    public final float getWidth() {
        return this.mWidth;
    }

    public final ArcLineOverlayProvider width(float width) {
        if (width > 0.0f) {
            this.mWidth = width;
        }
        return this;
    }

    public final ArcLineOverlayProvider radian(float radian) {
        if (radian > 0.0f && radian <= 90.0f) {
            this.mRadian = radian;
            Iterator<FromToLatLng> iterator = this.dataList.iterator();
            while (iterator.hasNext()) {
                iterator.next().setArc(this.mRadian);
            }
        }
        return this;
    }

    public final float getRadian() {
        return this.mRadian;
    }

    public final boolean isEnable3D() {
        return this.mDraw3D;
    }

    public final ArcLineOverlayProvider enable3D(boolean enable3D) {
        this.mDraw3D = enable3D;
        return this;
    }

    public final ArcLineOverlayProvider setHighlightDuration(int highlightDuration) {
        if (highlightDuration >= 0) {
            this.mHighLightDuration = highlightDuration;
        }
        return this;
    }

    public final int getHighLightDuration() {
        return this.mHighLightDuration;
    }

    public final ArcLineOverlayProvider setAnimateDuration(int animateDuration) {
        if (animateDuration == 0) {
            this.mAnimate = false;
            this.mAnimationDuration = 0;
        } else if (animateDuration > 0) {
            this.mAnimationDuration = animateDuration;
            this.mAnimate = true;
        }
        return this;
    }

    public final int getAnimateDuration() {
        return this.mAnimationDuration;
    }

    public final ArcLineOverlayProvider animateColor(int animateColor) {
        this.mAnimateColor = animateColor;
        return this;
    }

    public final int getAnimateColor() {
        return this.mAnimateColor;
    }

    public final boolean isAnimate() {
        return this.mAnimate;
    }
}

