/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptAesUtils {
    private static final String CipherMode = "AES/CBC/PKCS5Padding";
    private static final byte[] EMPYT_BYTE_ARR = new byte[0];
    private static final String EMPTY_STRING = "";

    private static Cipher getCipher(String pwd, AlgorithmParameterSpec params, int opmode) throws UnsupportedEncodingException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKeySpec secKeySpec = new SecretKeySpec(pwd.getBytes("UTF-8"), "AES");
        Cipher cipher = Cipher.getInstance(CipherMode);
        cipher.init(opmode, (Key)secKeySpec, params);
        return cipher;
    }

    private static String EnDeCryptBase64(String content, String pwd, AlgorithmParameterSpec params, int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("wrong mode.");
        }
        if (content == null || content.length() == 0) {
            return EMPTY_STRING;
        }
        try {
            byte[] in2 = null;
            if (mode == 1) {
                in2 = content.getBytes();
            } else if (mode == 2) {
                in2 = Base64.decode((byte[])content.getBytes(), (int)2);
            }
            if (in2 == null || in2.length == 0) {
                return EMPTY_STRING;
            }
            byte[] out = EncryptAesUtils.EnDeCrypt(in2, pwd, params, mode);
            if (mode == 1) {
                return Base64.encodeToString((byte[])out, (int)2);
            }
            if (mode == 2) {
                return new String(out);
            }
            return null;
        }
        catch (Throwable throwable) {
            return EMPTY_STRING;
        }
    }

    private static byte[] EnDeCrypt(byte[] bytes, String pwd, AlgorithmParameterSpec params, int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("wrong mode.");
        }
        if (bytes == null || bytes.length == 0) {
            return EMPYT_BYTE_ARR;
        }
        try {
            Cipher cipher = EncryptAesUtils.getCipher(pwd, params, mode);
            if (cipher == null) {
                return EMPYT_BYTE_ARR;
            }
            return cipher.doFinal(bytes);
        }
        catch (Throwable throwable) {
            return EMPYT_BYTE_ARR;
        }
    }

    public static String encryptAes256Base64(String content, String pwd, AlgorithmParameterSpec params) {
        return EncryptAesUtils.EnDeCryptBase64(content, pwd, params, 1);
    }

    public static String decryptAes256Base64(String content, String pwd, AlgorithmParameterSpec params) {
        return EncryptAesUtils.EnDeCryptBase64(content, pwd, params, 2);
    }

    public static byte[] encryptAes256(byte[] srcBytes, String pwd, AlgorithmParameterSpec params) {
        return EncryptAesUtils.EnDeCrypt(srcBytes, pwd, params, 1);
    }

    public static byte[] decryptAes256(byte[] encBytes, String pwd, AlgorithmParameterSpec params) {
        return EncryptAesUtils.EnDeCrypt(encBytes, pwd, params, 2);
    }
}

