/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import android.text.TextUtils;
import com.tencent.map.tools.net.NetAdapter;
import com.tencent.map.tools.net.NetMethod;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.NetUtil;
import com.tencent.map.tools.net.http.HttpCanceler;
import com.tencent.map.tools.net.http.HttpProxy;
import com.tencent.map.tools.net.http.HttpProxyRule;
import com.tencent.map.tools.net.processor.Processor;
import com.tencent.mapsdk.internal.lm;
import com.tencent.mapsdk.internal.ln;
import com.tencent.mapsdk.internal.lo;
import com.tencent.mapsdk.internal.lq;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetRequest {
    public final long mRequestId = System.nanoTime();
    public NetMethod mNetMethod;
    public String url;
    public byte[] postData;
    public int retryMethod;
    public final Map<String, String> mapHeaders = new HashMap<String, String>();
    public final Set<String> respHeaders = new HashSet<String>();
    public final Set<Processor> processors = new HashSet<Processor>();
    public HttpCanceler canceler;
    public int timeout;
    public HttpProxy proxy;
    private NetAdapter mNetAdapter;
    private File mCacheFile;
    private boolean mForceHttps = true;
    private String mSecretKey;
    private boolean mIsLogEnable;
    private List<HttpProxyRule> mProxyRules;

    public NetRequest() {
    }

    public NetRequest(NetMethod netMethod, String url) {
        this.mNetMethod = netMethod;
        this.url = url;
    }

    public NetRequest setNetMethod(NetMethod netMethod) {
        this.mNetMethod = netMethod;
        return this;
    }

    public NetRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public NetRequest setUserAgent(String userAgent) {
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            this.mapHeaders.put("User-Agent", userAgent);
        }
        return this;
    }

    public NetRequest setPostData(byte[] postData) {
        this.postData = postData;
        return this;
    }

    public NetRequest setRetryMethod(int retryMethod) {
        this.retryMethod = retryMethod;
        return this;
    }

    public NetRequest setMapHeaders(Map<String, String> mapHeaders) {
        if (mapHeaders == null) {
            return this;
        }
        this.mapHeaders.putAll(mapHeaders);
        return this;
    }

    public NetRequest setMapHeaders(String key, String value) {
        this.mapHeaders.put(key, value);
        return this;
    }

    public NetRequest setRespHeaders(String ... headerKeys) {
        this.respHeaders.addAll(Arrays.asList((Object[])headerKeys.clone()));
        return this;
    }

    public NetRequest setCanceler(HttpCanceler canceler) {
        this.canceler = canceler;
        return this;
    }

    public NetRequest setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public NetRequest setToken(String token) {
        if (!TextUtils.isEmpty((CharSequence)token)) {
            this.mapHeaders.put("Sign", token);
        }
        return this;
    }

    public NetRequest setNonce(String nonce) {
        if (!TextUtils.isEmpty((CharSequence)nonce)) {
            this.mapHeaders.put("nonce", nonce);
        }
        return this;
    }

    public NetRequest setTimeStamp(String timeStamp) {
        if (!TextUtils.isEmpty((CharSequence)timeStamp)) {
            this.mapHeaders.put("timestamp", timeStamp);
        }
        return this;
    }

    public NetRequest setStart(String start) {
        if (!TextUtils.isEmpty((CharSequence)start)) {
            this.mapHeaders.put("Range", "bytes=" + start + "-");
        }
        return this;
    }

    public NetRequest addProcessor(Processor processor) {
        this.processors.add(processor);
        return this;
    }

    public String toString() {
        return "NetRequest{mRequestId=" + this.mRequestId + ", mNetMethod=" + (Object)((Object)this.mNetMethod) + ", url='" + this.url + '\'' + ", postData=" + Arrays.toString(this.postData) + ", retryMethod=" + this.retryMethod + ", mapHeaders=" + this.mapHeaders + ", respHeaders=" + this.respHeaders + ", processorSet=" + this.processors + ", canceler=" + this.canceler + ", timeout=" + this.timeout + ", proxy=" + this.proxy + '}';
    }

    private NetResponse doGet() {
        this.setNetMethod(NetMethod.GET);
        return this.mNetAdapter.doRequest(this);
    }

    private NetResponse doPost() {
        this.setNetMethod(NetMethod.POST);
        return this.mNetAdapter.doRequest(this);
    }

    private NetResponse doRequest() {
        return this.mNetAdapter.doRequest(this);
    }

    private NetResponse doStream() {
        this.setNetMethod(NetMethod.GET);
        return this.mNetAdapter.openStream(this);
    }

    public static class NetRequestBuilder {
        private final NetRequest mNetRequest;

        NetRequestBuilder(NetAdapter netAdapter, String secretKey) {
            this(netAdapter, secretKey, null);
        }

        NetRequestBuilder(NetAdapter netAdapter, String secretKey, NetRequest request) {
            this.mNetRequest = request == null ? new NetRequest().setTimeout(10000).setRetryMethod(1) : request;
            this.mNetRequest.mNetAdapter = netAdapter;
            this.mNetRequest.mSecretKey = secretKey;
            this.mNetRequest.mProxyRules = netAdapter.getProxyRuleList();
            this.mNetRequest.mIsLogEnable = netAdapter.isLogEnable();
        }

        public NetRequestBuilder url(String url) {
            this.mNetRequest.url = url;
            return this;
        }

        public NetRequestBuilder userAgent(String userAgent) {
            this.mNetRequest.setUserAgent(userAgent);
            return this;
        }

        public NetRequestBuilder postData(byte[] postData) {
            this.mNetRequest.postData = postData;
            return this;
        }

        public NetRequestBuilder retryNum(int retryNum) {
            this.mNetRequest.retryMethod = retryNum;
            return this;
        }

        public NetRequestBuilder timeOut(int timeout) {
            this.mNetRequest.timeout = timeout;
            return this;
        }

        public NetRequestBuilder header(HashMap<String, String> headers) {
            this.mNetRequest.setMapHeaders(headers);
            return this;
        }

        public NetRequestBuilder header(String key, String value) {
            this.mNetRequest.setMapHeaders(key, value);
            return this;
        }

        public NetRequestBuilder canceler(HttpCanceler canceler) {
            this.mNetRequest.canceler = canceler;
            return this;
        }

        public NetRequestBuilder token(String token) {
            this.mNetRequest.setToken(token);
            return this;
        }

        public NetRequestBuilder nonce(String nonce) {
            this.mNetRequest.setNonce(nonce);
            return this;
        }

        public NetRequestBuilder timestamp(String timestamp) {
            this.mNetRequest.setTimeStamp(timestamp);
            return this;
        }

        public NetRequestBuilder startTag(String startTag) {
            this.mNetRequest.setStart(startTag);
            return this;
        }

        public NetRequestBuilder file(File file) {
            this.mNetRequest.mCacheFile = file;
            return this;
        }

        public NetRequestBuilder forceHttps(boolean forceHttps) {
            this.mNetRequest.mForceHttps = forceHttps;
            return this;
        }

        public NetRequestBuilder proxy(HttpProxy proxy) {
            this.mNetRequest.proxy = proxy;
            return this;
        }

        public NetRequestBuilder gzip() {
            this.header("Accept-Encoding", "gzip");
            return this;
        }

        public NetRequestBuilder addProcessor(Processor processor) {
            this.mNetRequest.addProcessor(processor);
            return this;
        }

        public NetResponse doPost() {
            this.onRequestStart("doPost", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.mNetRequest.doPost());
        }

        public NetResponse doGet() {
            this.onRequestStart("doGet", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.mNetRequest.doGet());
        }

        public NetResponse downloadTo(File file) {
            this.onRequestStart("downloadTo[" + file + "]", this);
            return this.file(file).doGet();
        }

        NetResponse doRequest() {
            this.onRequestStart("doRequest", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.mNetRequest.doRequest());
        }

        public NetResponse doStream() {
            this.onRequestStart("doStream", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.mNetRequest.doStream());
        }

        private void onRequestStart(String method, NetRequestBuilder builder) {
            builder.addProcessor(new lo(this.mNetRequest.mIsLogEnable));
            builder.addProcessor(lm.a(this.mNetRequest.mForceHttps));
            builder.addProcessor(ln.a(this.mNetRequest.mProxyRules));
            builder.addProcessor(lq.a(this.mNetRequest.mSecretKey));
        }

        private NetResponse onRequestFinish(NetResponse netResponse) {
            if (netResponse != null) {
                File mCacheFile = this.mNetRequest.mCacheFile;
                if (mCacheFile != null) {
                    FileOutputStream fos = null;
                    try {
                        if (mCacheFile.isFile()) {
                            if (mCacheFile.exists()) {
                                mCacheFile.delete();
                            }
                            mCacheFile.getParentFile().mkdirs();
                            mCacheFile.createNewFile();
                        }
                        fos = new FileOutputStream(mCacheFile);
                        NetUtil.writeBytesWithoutClose(netResponse.data, fos);
                    }
                    catch (Exception e2) {
                        try {
                            NetUtil.safeClose(fos);
                            netResponse.exception(e2);
                        }
                        catch (Throwable throwable) {
                            NetUtil.safeClose(fos);
                            throw throwable;
                        }
                        NetUtil.safeClose(fos);
                    }
                    NetUtil.safeClose(fos);
                }
                return netResponse;
            }
            NetResponse response = new NetResponse(this.mNetRequest);
            new NetResponse(this.mNetRequest).errorCode = -100;
            response.errorData = "\u672a\u77e5".getBytes();
            return response;
        }

        public NetRequest getNetRequest() {
            return this.mNetRequest;
        }

        public String toString() {
            return "NetRequestBuilder{, mRequestId=" + this.mNetRequest.mRequestId + ", mNetRequest=" + this.mNetRequest + '}';
        }
    }
}

