/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.internal;

import android.graphics.Point;
import android.location.Location;
import com.tencent.map.lib.models.GeoPoint;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public final class jz {
    private static final int d = 20037508;
    private static final int e = 30240971;
    public static final int a = 256;
    public static final int b = 20;
    public static final double c = 4.272282972352698E7;
    private static final double f = 111319.49077777778;
    private static final double g = Math.PI / 180;
    private static final double h = Math.PI / 360;
    private static final double i = 114.59155902616465;

    private static int a(int serverX) {
        return serverX + 20037508;
    }

    private static int b(int serverY) {
        return serverY + 30240971;
    }

    private static int c(int clientX) {
        return clientX - 20037508;
    }

    private static int d(int clientY) {
        return clientY - 30240971;
    }

    private static int a(double lon) {
        return (int)(lon * 111319.49077777778 + 2.0037508E7);
    }

    private static int b(double lat) {
        return (int)(Math.log(Math.tan((90.0 + lat) * (Math.PI / 360))) / (Math.PI / 180) * 111319.49077777778 + 3.0240971E7);
    }

    private static double e(int clientX) {
        return (double)(clientX - 20037508) / 111319.49077777778;
    }

    private static double f(int clientY) {
        return Math.atan(Math.exp((double)(clientY - 30240971) / 111319.49077777778 * (Math.PI / 180))) * 114.59155902616465 - 90.0;
    }

    private static float a(GeoPoint p1, GeoPoint p2) {
        if (p1 == null || p2 == null) {
            throw new IllegalArgumentException("point is null");
        }
        double lat1 = (double)p1.getLatitudeE6() / 1000000.0;
        double lon1 = (double)p1.getLongitudeE6() / 1000000.0;
        double lat2 = (double)p2.getLatitudeE6() / 1000000.0;
        double lon2 = (double)p2.getLongitudeE6() / 1000000.0;
        return (float)jz.a(lat1, lon1, lat2, lon2);
    }

    private static void a(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) {
        float d2;
        Location.distanceBetween((double)startLatitude, (double)startLongitude, (double)endLatitude, (double)endLongitude, (float[])results);
        results[0] = d2 = (float)jz.a(startLatitude, startLongitude, endLatitude, endLongitude);
    }

    private static double a(double lat1, double lon1, double lat2, double lon2) {
        double dLat = jz.c(lat2 - lat1);
        double dLon = jz.c(lon2 - lon1);
        double gclat1 = jz.c(lat1);
        double gclat2 = jz.c(lat2);
        double a2 = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(gclat1) * Math.cos(gclat2);
        double c2 = 2.0 * Math.atan2(Math.sqrt(a2), Math.sqrt(1.0 - a2));
        return 6371.0 * c2 * 1000.0;
    }

    private static double c(double degree) {
        return degree * Math.PI / 180.0;
    }

    private static void b(double lat1, double lon1, double lat2, double lon2, float[] results) {
        float distance;
        double L = lon2 * (Math.PI / 180) - (lon1 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan(0.996647189328169 * Math.tan(lat1 *= Math.PI / 180));
        double U2 = Math.atan(0.996647189328169 * Math.tan(lat2 *= Math.PI / 180));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = L;
        for (int iter = 0; iter < 20; ++iter) {
            double sinAlpha;
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double d2 = t1;
            double d3 = t2;
            double sinSigma = Math.sqrt(d2 * d2 + d3 * d3);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double d4 = sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double cosSqAlpha = 1.0 - d4 * d4;
            double cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * 0.006739496756586903;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = 2.0955066698943685E-4 * cosSqAlpha * (4.0 + 0.0033528106718309896 * (4.0 - 3.0 * cosSqAlpha));
            double d5 = cos2SM;
            double cos2SMSq = d5 * d5;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * 0.0033528106718309896 * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            if (Math.abs((lambda - lambdaOrig) / lambda) < 1.0E-12) break;
        }
        results[0] = distance = (float)(6356752.3142 * A * (sigma - deltaSigma));
        if (results.length > 1) {
            float initialBearing;
            results[1] = initialBearing = (float)((double)((float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda)) * 57.29577951308232);
            if (results.length > 2) {
                float finalBearing;
                results[2] = finalBearing = (float)((double)((float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda)) * 57.29577951308232);
            }
        }
    }

    private static GeoPoint b(int x2, int y2) {
        return new GeoPoint((int)(jz.f(y2) * 1000000.0), (int)(jz.e(x2) * 1000000.0));
    }

    private static Point b(GeoPoint p2) {
        if (p2 == null) {
            throw new IllegalArgumentException("point is null");
        }
        return new Point(jz.a((double)p2.getLongitudeE6() / 1000000.0), jz.b((double)p2.getLatitudeE6() / 1000000.0));
    }

    private static GeoPoint c(int x2, int y2) {
        return new GeoPoint((int)(jz.f(y2 += 30240971) * 1000000.0), (int)(jz.e(x2 += 20037508) * 1000000.0));
    }

    private static Point c(GeoPoint p2) {
        if (p2 == null) {
            throw new IllegalArgumentException("point is null");
        }
        return new Point(jz.a((double)p2.getLongitudeE6() / 1000000.0) - 20037508, jz.b((double)p2.getLatitudeE6() / 1000000.0) - 30240971);
    }

    private static Point d(int lonE6, int latE6) {
        return new Point(jz.a((double)lonE6 / 1000000.0) - 20037508, jz.b((double)latE6 / 1000000.0) - 30240971);
    }

    private static Point d(GeoPoint geoCenter) {
        if (geoCenter == null) {
            throw new IllegalArgumentException("point is null");
        }
        double latitude = (double)geoCenter.getLatitudeE6() / 1000000.0;
        double longitude = (double)geoCenter.getLongitudeE6() / 1000000.0;
        double dblMercatorLat = Math.log(Math.tan((90.0 + latitude) * (Math.PI / 360))) / 0.01745329238474369;
        Point engineCenter = new Point();
        new Point().x = (int)((longitude + 180.0) / 360.0 * 2.68435456E8);
        engineCenter.y = (int)((180.0 - dblMercatorLat) / 360.0 * 2.68435456E8);
        return engineCenter;
    }

    public static GeoPoint a(int x2, int y2) {
        double leftTopX = (double)x2 / 4.272282972352698E7;
        double leftTopY = (double)y2 / 4.272282972352698E7;
        double mercatorX = leftTopX - Math.PI;
        double mercatorY = Math.PI - leftTopY;
        double longRadian = mercatorX;
        double latRadian = 2.0 * (Math.atan(Math.exp(mercatorY)) - 0.7853981633974483);
        return new GeoPoint((int)(Math.toDegrees(latRadian) * 1000000.0), (int)(Math.toDegrees(longRadian) * 1000000.0));
    }

    private static float b(GeoPoint p1, GeoPoint p2) {
        float f2;
        if (p1 == null || p2 == null) {
            return 0.0f;
        }
        float[] results = new float[10];
        double lat1 = (double)p1.getLatitudeE6() / 1000000.0;
        double lon1 = (double)p1.getLongitudeE6() / 1000000.0;
        double lat2 = (double)p2.getLatitudeE6() / 1000000.0;
        double lon2 = (double)p2.getLongitudeE6() / 1000000.0;
        float[] fArray = results;
        Location.distanceBetween((double)lat1, (double)lon1, (double)lat2, (double)lon2, (float[])fArray);
        fArray[0] = f2 = (float)jz.a(lat1, lon1, lat2, lon2);
        return results[1];
    }

    public static LatLng a(GeoPoint geoPt) {
        if (geoPt == null) {
            return null;
        }
        return new LatLng((double)geoPt.getLatitudeE6() / 1000000.0, (double)geoPt.getLongitudeE6() / 1000000.0);
    }

    public static List<LatLng> a(List<GeoPoint> points) {
        if (points == null || points.isEmpty()) {
            return null;
        }
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>(points.size());
        for (GeoPoint p2 : points) {
            latLngs.add(jz.a(p2));
        }
        return latLngs;
    }
}

