/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.internal;

import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.Pair;
import com.tencent.map.lib.models.GeoPoint;
import com.tencent.map.tools.IndexCallback;
import com.tencent.map.tools.Util;
import com.tencent.mapsdk.internal.kb;
import com.tencent.mapsdk.internal.kh;
import com.tencent.tencentmap.mapsdk.maps.interfaces.Coordinate;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class kr {
    private static double a(double value, int num) {
        try {
            return new BigDecimal(value).setScale(num, 4).doubleValue();
        }
        catch (Exception exception) {
            return value;
        }
    }

    private static float a(float value, int num) {
        try {
            return new BigDecimal(value).setScale(num, 4).floatValue();
        }
        catch (Exception exception) {
            return value;
        }
    }

    private static PointF a(PointF p1, PointF p2, PointF p3, PointF p4) {
        if (p2.x == p1.x || p4.x == p3.x) {
            return null;
        }
        float k1 = (p2.y - p1.y) / (p2.x - p1.x);
        float k2 = (p4.y - p3.y) / (p4.x - p3.x);
        if (k1 == k2) {
            return null;
        }
        float b1 = (p1.y * p2.x - p2.y * p1.x) / (p2.x - p1.x);
        float b2 = (p3.y * p4.x - p4.y * p3.x) / (p4.x - p3.x);
        float x2 = (b2 - b1) / (k1 - k2);
        float y2 = k2 * x2 + b2;
        return new PointF(x2, y2);
    }

    public static double a(double src) {
        double d2;
        src %= 360.0;
        if (d2 > 180.0) {
            src -= 360.0;
        } else if (src < -180.0) {
            src += 360.0;
        }
        return src;
    }

    private static Rect a(GeoPoint center, Rect bound) {
        int delLeft = Math.abs(bound.left - center.getLongitudeE6());
        int delRight = Math.abs(bound.right - center.getLongitudeE6());
        int delX = Math.max(delLeft, delRight);
        int delTop = Math.abs(bound.top - center.getLatitudeE6());
        int delBottom = Math.abs(bound.bottom - center.getLatitudeE6());
        int delY = Math.max(delTop, delBottom);
        return new Rect(center.getLongitudeE6() - delY, center.getLatitudeE6() - delX, center.getLongitudeE6() + delY, center.getLatitudeE6() + delX);
    }

    private static Rect a(GeoPoint center, GeoPoint edge) {
        if (center == null || edge == null || center.equals(edge)) {
            return null;
        }
        int delY = Math.abs(center.getLongitudeE6() - edge.getLongitudeE6());
        int delX = Math.abs(center.getLatitudeE6() - edge.getLatitudeE6());
        return new Rect(center.getLongitudeE6() - delY, center.getLatitudeE6() - delX, center.getLongitudeE6() + delY, center.getLatitudeE6() + delX);
    }

    private static GeoPoint a(GeoPoint p1, GeoPoint p2, GeoPoint pt2) {
        double d2;
        int dLat = p2.getLatitudeE6() - p1.getLatitudeE6();
        int dLon = p2.getLongitudeE6() - p1.getLongitudeE6();
        if (dLat == 0 && dLon == 0) {
            return null;
        }
        int dx2 = pt2.getLatitudeE6() - p1.getLatitudeE6();
        int dy2 = pt2.getLongitudeE6() - p1.getLongitudeE6();
        int n2 = dLat;
        int n3 = dLon;
        double t2 = (double)(dx2 * dLat + dy2 * dLon) / (double)(n2 * n2 + n3 * n3);
        if (d2 < 0.0) {
            return new GeoPoint(p1);
        }
        if (t2 > 1.0) {
            return new GeoPoint(p2);
        }
        return new GeoPoint(p1.getLatitudeE6() + (int)((double)dLat * t2), p1.getLongitudeE6() + (int)((double)dLon * t2));
    }

    private static double b(double degree) {
        return degree * Math.PI / 180.0;
    }

    private static double c(double degree) {
        return degree * 180.0 / Math.PI;
    }

    private static double[] a(LatLng p1, LatLng p2) {
        double b2;
        double k2;
        if (Math.abs(p1.longitude - p2.longitude) < 1.0E-6) {
            k2 = Double.NaN;
            b2 = Double.NaN;
        } else if (Math.abs(p1.latitude - p2.latitude) < 1.0E-6) {
            k2 = 0.0;
            b2 = p1.latitude;
        } else {
            k2 = (p2.latitude - p1.latitude) / (p2.longitude - p1.longitude);
            b2 = (p2.longitude * p1.latitude - p1.longitude * p2.latitude) / (p2.longitude - p1.latitude);
        }
        return new double[]{k2, b2};
    }

    public static double a(Coordinate p2, Coordinate p1, Coordinate p22) {
        double d3;
        double d2;
        double d1 = kr.a(p2, p1);
        if (d1 + (d2 = kr.a(p2, p22)) == (d3 = kr.a(p1, p22))) {
            return 0.0;
        }
        if (d3 <= 1.0E-6) {
            return d1;
        }
        double d4 = d2;
        double d5 = d1;
        double d6 = d3;
        if (d4 * d4 >= d5 * d5 + d6 * d6) {
            return d1;
        }
        double d7 = d1;
        double d8 = d2;
        double d9 = d3;
        if (d7 * d7 >= d8 * d8 + d9 * d9) {
            return d2;
        }
        double pp2 = (d1 + d2 + d3) / 2.0;
        double s2 = Math.sqrt(pp2 * (pp2 - d1) * (pp2 - d2) * (pp2 - d3));
        return 2.0 * s2 / d3;
    }

    private static double[] b(LatLng p2, LatLng p1, LatLng p22) {
        double bp2;
        double kp2;
        double[] lineParam = kr.a(p1, p22);
        if (Double.isNaN(lineParam[0])) {
            kp2 = 0.0;
            bp2 = p2.latitude;
        } else if (lineParam[0] == 0.0) {
            kp2 = Double.NaN;
            bp2 = Double.NaN;
        } else {
            kp2 = -1.0 / lineParam[0];
            bp2 = 1.0 / lineParam[0] * p2.longitude + p2.latitude;
        }
        return new double[]{kp2, bp2};
    }

    public static LatLng a(LatLng p2, LatLng p1, LatLng p22) {
        double y2;
        double x2;
        double[] lineParam = kr.a(p1, p22);
        if (Double.isNaN(lineParam[0])) {
            x2 = p1.longitude;
            y2 = p2.latitude;
        } else if (lineParam[0] == 0.0) {
            x2 = p2.longitude;
            y2 = p1.latitude;
        } else {
            double k2 = lineParam[0];
            double kp2 = k2 * k2;
            x2 = (kp2 * p1.longitude + k2 * (p2.latitude - p1.latitude) + p2.longitude) / (kp2 + 1.0);
            y2 = k2 * (x2 - p1.longitude) + p1.latitude;
        }
        return new LatLng(y2, x2);
    }

    public static LatLng a(LatLng p1, LatLng p2, int offset) {
        double x2 = p2.longitude > p1.longitude ? p1.longitude - (double)offset : p1.longitude + (double)offset;
        double y2 = p2.latitude > p1.latitude ? p1.latitude - (double)offset : p1.latitude + (double)offset;
        return new LatLng(y2, x2);
    }

    public static double a(Coordinate p1, Coordinate p2) {
        double d1 = p1.x() - p2.x();
        double d2 = p1.y() - p2.y();
        double d3 = d1;
        double d4 = d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public static boolean a(LatLng center, double radius, LatLng p1, LatLng p2) {
        if (kr.a((Coordinate)center, (Coordinate)p1, (Coordinate)p2) - radius > 1.0E-6) {
            return false;
        }
        LatLng latLng = p2;
        LatLng latLng2 = p1;
        LatLng latLng3 = kr.a(center, p1, p2);
        double d2 = kr.a((Coordinate)latLng3, (Coordinate)latLng2);
        double d3 = kr.a((Coordinate)latLng3, (Coordinate)latLng);
        return kr.a((Coordinate)latLng2, (Coordinate)latLng) - d2 - d3 < 1.0E-6;
    }

    private static boolean c(LatLng p2, LatLng p1, LatLng p22) {
        double d1 = kr.a((Coordinate)p2, (Coordinate)p1);
        double d2 = kr.a((Coordinate)p2, (Coordinate)p22);
        return kr.a((Coordinate)p1, (Coordinate)p22) - d1 - d2 < 1.0E-6;
    }

    public static double a(double startX, double startY, double endX, double endY, double targetX, double targetY) {
        return (startY - endY) * targetX + (endX - startX) * targetY + startX * endY - endX * startY;
    }

    private static double b(Coordinate p1, Coordinate p2) {
        return (p1.y() - p2.y()) / (p1.x() - p2.x());
    }

    private static double c(Coordinate p1, Coordinate p2) {
        Coordinate coordinate = p2;
        Coordinate coordinate2 = p1;
        return Math.atan((coordinate2.y() - coordinate.y()) / (coordinate2.x() - coordinate.x())) * 180.0 / Math.PI;
    }

    private static double c(Coordinate start, Coordinate end, Coordinate center) {
        double lineLength = kr.a(start, end);
        double centerToLineDistance = kr.a(center, start, end);
        return 2.0 * Math.atan(lineLength / 2.0 / centerToLineDistance);
    }

    public static double b(Coordinate start, Coordinate end, Coordinate center) {
        Coordinate coordinate = center;
        Coordinate coordinate2 = end;
        Coordinate coordinate3 = start;
        double d2 = kr.a(coordinate3, coordinate2);
        double d3 = kr.a(coordinate, coordinate3, coordinate2);
        double centerAngle = 2.0 * Math.atan(d2 / 2.0 / d3);
        double radius = kr.a(start, center);
        return centerAngle * radius;
    }

    private static String a() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return new String(bytes);
    }

    private static int a(int max) {
        if (max - 0 > 0) {
            return new SecureRandom().nextInt(max - 0) + 0;
        }
        if (max - 0 == 0) {
            return 0;
        }
        return 0;
    }

    public static String a(String target) {
        if (TextUtils.isEmpty((CharSequence)target)) {
            return target;
        }
        return Util.getMD5String(target.getBytes());
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static String a(File file) {
        String string;
        FileInputStream in2 = null;
        try {
            int len;
            in2 = new FileInputStream(file);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[0xA00000];
            while ((len = in2.read(buffer)) > 0) {
                digest.update(buffer, 0, len);
            }
            String sha1 = new BigInteger(1, digest.digest()).toString(16);
            int length = 40 - sha1.length();
            if (length > 0) {
                for (int i2 = 0; i2 < length; ++i2) {
                    sha1 = "0".concat(String.valueOf(sha1));
                }
            }
            string = sha1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            kb.a((Closeable)in2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            {
                catch (Throwable throwable) {
                    kb.a(in2);
                    throw throwable;
                }
            }
            kb.a((Closeable)in2);
        }
        kb.a((Closeable)in2);
        return string;
        return "";
    }

    public static double a(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate outCenter) {
        double A1 = 2.0 * (p2.x() - p1.x());
        double B1 = 2.0 * (p2.y() - p1.y());
        double C1 = p2.x() * p2.x() + p2.y() * p2.y() - p1.x() * p1.x() - p1.y() * p1.y();
        double A2 = 2.0 * (p3.x() - p2.x());
        double B2 = 2.0 * (p3.y() - p2.y());
        double C2 = p3.x() * p3.x() + p3.y() * p3.y() - p2.x() * p2.x() - p2.y() * p2.y();
        double Ox = (C1 * B2 - C2 * B1) / (A1 * B2 - A2 * B1);
        double Oy = (A1 * C2 - A2 * C1) / (A1 * B2 - A2 * B1);
        outCenter.setX(Ox);
        outCenter.setY(Oy);
        return Math.sqrt(Math.pow(p1.x() - Ox, 2.0) + Math.pow(p1.y() - Oy, 2.0));
    }

    public static double a(Coordinate p1, Coordinate p2, double angle, boolean clockwise, Coordinate outCenter) {
        double R2 = kr.a(p1, p2) * 0.5 / Math.sin(kr.b(angle * 0.5));
        double midX = (p1.x() + p2.x()) / 2.0;
        double midY = (p1.y() + p2.y()) / 2.0;
        double delta = Math.sqrt(Math.pow(R2, 2.0) / (Math.pow(p1.x() - p2.x(), 2.0) + Math.pow(p1.y() - p2.y(), 2.0)) - 0.25);
        double deltaX = (p1.y() - p2.y()) * delta;
        double deltaY = (p2.x() - p1.x()) * delta;
        if (angle - 90.0 <= 1.0E-6) {
            deltaX = -deltaX;
            deltaY = -deltaY;
        }
        if (Double.isNaN(deltaX)) {
            deltaX = 0.0;
        }
        if (Double.isNaN(deltaY)) {
            deltaY = 0.0;
        }
        double x2 = clockwise ? midX + deltaX : midX - deltaX;
        double y2 = clockwise ? midY + deltaY : midY - deltaY;
        outCenter.setX(x2);
        outCenter.setY(y2);
        return R2;
    }

    public static <T extends Coordinate> void a(T center, double radius, T start, T end, boolean clockwise, IndexCallback<Pair<Double, Double>> outCallback) {
        T t2 = start;
        T t3 = center;
        double startAngle = Math.atan((t3.y() - t2.y()) / (t3.x() - t2.x())) * 180.0 / Math.PI;
        boolean deltaKChanged = center.x() > start.x() ? !clockwise : clockwise;
        double prevDeltaK = 0.0;
        for (int i2 = 0; i2 < 360; ++i2) {
            double curDeltaK = Math.tan(kr.b(clockwise ? startAngle - (double)i2 : startAngle + (double)i2));
            if (prevDeltaK != 0.0 && prevDeltaK * curDeltaK < 0.0 && Math.abs(curDeltaK) > 1.0) {
                deltaKChanged = !deltaKChanged;
            }
            prevDeltaK = curDeltaK;
            double d2 = curDeltaK;
            double deltaX = radius / Math.sqrt(d2 * d2 + 1.0);
            double deltaY = curDeltaK * deltaX;
            kh.b("TDZ", i2 + ":curDeltaK[" + curDeltaK + "]deltaKChanged[" + deltaKChanged + "]clockwise[" + clockwise + "]deltaX[" + deltaX + "]deltaY[" + deltaY + "]");
            if (deltaKChanged) {
                deltaX = -deltaX;
                deltaY = -deltaY;
            }
            double px2 = clockwise ? center.x() - deltaX : center.x() + deltaX;
            double py2 = clockwise ? center.y() - deltaY : center.y() + deltaY;
            double ret = kr.a(start.x(), start.y(), end.x(), end.y(), px2, py2);
            if (!(clockwise ? ret > 0.0 : ret < 0.0)) continue;
            outCallback.callback(i2, (Pair<Double, Double>)new Pair((Object)px2, (Object)py2));
        }
    }
}

