/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.util.Log;
import com.tencent.lbssearch.httpresponse.BaseObject;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.map.tools.json.JsonUtils;
import com.tencent.map.tools.net.NetConfig;
import com.tencent.map.tools.net.NetManager;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.http.HttpResponseListener;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class HttpProvider {
    public static <T extends BaseObject> void get(Context context, final String url, final RequestParams params, final Class<T> t2, final String secretKey, final HttpResponseListener<T> listener) {
        if (!NetManager.getInstance().available()) {
            NetManager.init(context, NetConfig.create());
        }
        new AsyncTask<Void, Void, T>(){

            private T a() {
                NetResponse response = NetManager.getInstance().builder(secretKey).url(HttpProvider.getUrlWithQueryString(url, params)).doGet();
                if (params.isDebuggable()) {
                    Log.v((String)"TencentSearch", (String)"[RESP]:\n".concat(String.valueOf(response)));
                }
                return HttpProvider.parse(response, t2);
            }

            private void a(T oj2) {
                super.onPostExecute(oj2);
                if (listener == null) {
                    return;
                }
                if (oj2 == null) {
                    listener.onFailure(-1, "unknown error", null);
                    return;
                }
                if (((BaseObject)oj2).isStatusOk()) {
                    listener.onSuccess(((BaseObject)oj2).status, oj2);
                    return;
                }
                listener.onFailure(((BaseObject)oj2).status, ((BaseObject)oj2).message, ((BaseObject)oj2).exception);
            }

            protected final /* synthetic */ void onPostExecute(Object object) {
                BaseObject baseObject = (BaseObject)object;
                1 var2_3 = this;
                super.onPostExecute((Object)baseObject);
                if (var2_3.listener != null) {
                    if (baseObject == null) {
                        var2_3.listener.onFailure(-1, "unknown error", null);
                        return;
                    }
                    if (baseObject.isStatusOk()) {
                        var2_3.listener.onSuccess(baseObject.status, baseObject);
                        return;
                    }
                    var2_3.listener.onFailure(baseObject.status, baseObject.message, baseObject.exception);
                }
            }

            protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
                1 var2_2 = this;
                NetResponse netResponse = NetManager.getInstance().builder(var2_2.secretKey).url(HttpProvider.getUrlWithQueryString(var2_2.url, var2_2.params)).doGet();
                if (var2_2.params.isDebuggable()) {
                    Log.v((String)"TencentSearch", (String)"[RESP]:\n".concat(String.valueOf(netResponse)));
                }
                return HttpProvider.parse(netResponse, var2_2.t2);
            }
        }.execute((Object[])new Void[0]);
    }

    public static <T extends BaseObject> T parse(@NonNull NetResponse response, Class<T> t2) {
        BaseObject obj;
        if (response.available()) {
            obj = (BaseObject)JsonUtils.parseToModel(response.toString(), t2, new Object[0]);
        } else {
            obj = (BaseObject)JsonUtils.parseToModel("", t2, new Object[0]);
            if (obj != null) {
                obj.exception = response.exception;
            }
        }
        return (T)obj;
    }

    private static String getUrlWithQueryString(String url, RequestParams params) {
        String paramString;
        if (url == null) {
            return null;
        }
        url = HttpProvider.decodeUrl(url);
        if (params != null && !(paramString = params.toString().trim()).equals("") && !paramString.equals("?")) {
            url = url + (url.contains("?") ? "&" : "?");
            url = url + paramString;
        }
        if (params != null && params.isDebuggable()) {
            Log.v((String)"TencentSearch", (String)"[REQ]: ".concat(String.valueOf(url)));
        }
        return url;
    }

    private static String decodeUrl(String url) {
        try {
            String decodeUrl = URLDecoder.decode(url, "UTF-8");
            URL _url = new URL(decodeUrl);
            url = new URI(_url.getProtocol(), _url.getUserInfo(), _url.getHost(), _url.getPort(), _url.getPath(), _url.getQuery(), _url.getRef()).toASCIIString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return url;
    }
}

