/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object;

import android.content.ContentValues;
import android.net.Uri;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RequestParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    protected static final String LOG_TAG = "RequestParams";
    protected boolean isRepeatable;
    protected boolean useJsonStreamer;
    protected boolean autoCloseInputStreams;
    protected final ConcurrentHashMap<String, String> urlParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Object> urlParamsWithObjects = new ConcurrentHashMap();
    private boolean mIsDebuggable;

    public RequestParams() {
        this(null);
    }

    public RequestParams(Map<String, String> source) {
        if (source != null) {
            for (Map.Entry<String, String> entry : source.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public RequestParams(final String key, final String value) {
        this((Map<String, String>)new HashMap<String, String>(){
            {
                1 v0 = this;
                v0.put(v0.key, value);
            }
        });
    }

    public RequestParams(Object ... keysAndValues) {
        int len = keysAndValues.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i2 = 0; i2 < len; i2 += 2) {
            String key = String.valueOf(keysAndValues[i2]);
            String val = String.valueOf(keysAndValues[i2 + 1]);
            this.put(key, val);
        }
    }

    public boolean isDebuggable() {
        return this.mIsDebuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.mIsDebuggable = debuggable;
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.urlParams.put(key, value);
        }
    }

    public void put(String key, Object value) {
        if (key != null && value != null) {
            this.urlParamsWithObjects.put(key, value);
        }
    }

    public void put(String key, int value) {
        if (key != null) {
            this.urlParams.put(key, String.valueOf(value));
        }
    }

    public void put(String key, long value) {
        if (key != null) {
            this.urlParams.put(key, String.valueOf(value));
        }
    }

    public void add(String key, String value) {
        if (key != null && value != null) {
            HashSet params = this.urlParamsWithObjects.get(key);
            if (params == null) {
                params = new HashSet();
                this.put(key, params);
            }
            if (params instanceof List) {
                ((List)((Object)params)).add(value);
                return;
            }
            if (params instanceof Set) {
                ((Set)params).add(value);
            }
        }
    }

    public void remove(String key) {
        this.urlParams.remove(key);
        this.urlParamsWithObjects.remove(key);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ContentValues kv2 : this.getParamsList()) {
            if (result.length() > 0) {
                result.append("&");
            }
            for (Map.Entry map : kv2.valueSet()) {
                result.append((String)map.getKey());
                result.append("=");
                result.append(map.getValue().toString());
            }
        }
        return result.toString();
    }

    protected List<ContentValues> getParamsList() {
        ArrayList keys = new ArrayList();
        LinkedList<ContentValues> lparams = new LinkedList<ContentValues>();
        keys.addAll(this.urlParams.keySet());
        keys.addAll(this.urlParamsWithObjects.keySet());
        Collections.sort(keys, new Comparator<String>(){

            private static int a(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }

            @Override
            public final /* synthetic */ int compare(Object object, Object object2) {
                return ((String)object).compareToIgnoreCase((String)object2);
            }
        });
        for (String key : keys) {
            String value = this.urlParams.get(key);
            if (value != null) {
                ContentValues contentValues = new ContentValues();
                contentValues.put(key, value);
                lparams.add(contentValues);
                continue;
            }
            Object value2 = this.urlParamsWithObjects.get(key);
            if (value2 == null) continue;
            lparams.addAll(this.getParamsList(key, value2));
        }
        return lparams;
    }

    private List<ContentValues> getParamsList(String key, Object value) {
        LinkedList<ContentValues> params = new LinkedList<ContentValues>();
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList list = new ArrayList(map.keySet());
            if (list.size() > 0 && list.get(0) instanceof Comparable) {
                Collections.sort(list);
            }
            for (Object nestedKey : list) {
                Object nestedValue;
                if (!(nestedKey instanceof String) || (nestedValue = map.get(nestedKey)) == null) continue;
                params.addAll(this.getParamsList(key == null ? (String)nestedKey : String.format("%s[%s]", key, nestedKey), nestedValue));
            }
        } else if (value instanceof List) {
            List list = (List)value;
            int listSize = list.size();
            for (int nestedValueIndex = 0; nestedValueIndex < listSize; ++nestedValueIndex) {
                params.addAll(this.getParamsList(String.format("%s[%d]", key, nestedValueIndex), list.get(nestedValueIndex)));
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int arrayLength = array.length;
            for (int nestedValueIndex = 0; nestedValueIndex < arrayLength; ++nestedValueIndex) {
                params.addAll(this.getParamsList(String.format("%s[%d]", key, nestedValueIndex), array[nestedValueIndex]));
            }
        } else if (value instanceof Set) {
            for (Object nestedValue : (Set)value) {
                params.addAll(this.getParamsList(key, nestedValue));
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put(key, value.toString());
            params.add(contentValues);
        }
        return params;
    }

    public String getParamString() {
        return Uri.encode((String)this.toString(), (String)"=&");
    }
}

