/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.deserializer;

import com.tencent.map.tools.json.JsonParser;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PolylineDeserializer
implements JsonParser.Deserializer<List<LatLng>> {
    private static List<LatLng> calcCoord(List<Double> coors) {
        if (coors == null || coors.size() < 2) {
            return null;
        }
        ArrayList<LatLng> list = new ArrayList<LatLng>();
        list.add(new LatLng(coors.get(0), coors.get(1)));
        for (int i2 = 2; i2 < coors.size(); i2 += 2) {
            double lng = ((LatLng)list.get((int)(i2 / 2 - 1))).longitude + coors.get(i2 + 1) / 1000000.0;
            double lat = (float)((double)Math.round((((LatLng)list.get((int)(i2 / 2 - 1))).latitude + coors.get(i2) / 1000000.0) * 1000000.0) / 1000000.0);
            lng = (float)((double)Math.round(lng * 1000000.0) / 1000000.0);
            list.add(new LatLng(lat, lng));
        }
        return list;
    }

    private static List<LatLng> normalCoord(List<Double> coors) {
        if (coors == null || coors.size() < 2) {
            return null;
        }
        ArrayList<LatLng> list = new ArrayList<LatLng>();
        for (int i2 = 0; i2 < coors.size(); i2 += 2) {
            double lng = coors.get(i2);
            double lat = (float)((double)Math.round(coors.get(i2 + 1) * 1000000.0) / 1000000.0);
            lng = (float)((double)Math.round(lng * 1000000.0) / 1000000.0);
            list.add(new LatLng(lat, lng));
        }
        return list;
    }

    @Override
    public List<LatLng> deserialize(Object model, String key, Object json) throws JSONException {
        JSONArray arrs;
        if (json == null) {
            return null;
        }
        if (json instanceof JSONArray && (arrs = (JSONArray)json).length() > 0) {
            List<LatLng> latLngs;
            if (arrs.get(0) instanceof JSONObject) {
                ArrayList<LatLng> latLngs2 = new ArrayList<LatLng>();
                for (int i2 = 0; i2 < arrs.length(); ++i2) {
                    JSONObject jo2 = arrs.getJSONObject(i2);
                    latLngs2.add(new LatLng(jo2.optDouble("lat"), jo2.optDouble("lng")));
                }
                return latLngs2;
            }
            ArrayList<Double> floatArrays = new ArrayList<Double>();
            for (int i3 = 0; i3 < arrs.length(); ++i3) {
                floatArrays.add(arrs.optDouble(i3));
            }
            try {
                latLngs = PolylineDeserializer.calcCoord(floatArrays);
            }
            catch (Exception exception) {
                latLngs = PolylineDeserializer.normalCoord(floatArrays);
            }
            return latLngs;
        }
        return null;
    }
}

