/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MatrixParam
implements ParamObject {
    protected String mode;
    protected List<HeadingLatLng> fromPoints = new ArrayList<HeadingLatLng>();
    protected List<LatLng> toPoints = new ArrayList<LatLng>();

    public MatrixParam addFromPoint(HeadingLatLng fromPoint) {
        if (fromPoint != null) {
            this.fromPoints.add(fromPoint);
        }
        return this;
    }

    public MatrixParam addFromPoints(Iterator<HeadingLatLng> lhs) {
        if (lhs != null) {
            Iterator<HeadingLatLng> it2 = lhs;
            while (it2.hasNext()) {
                HeadingLatLng l2 = it2.next();
                if (l2 == null) continue;
                this.fromPoints.add(l2);
            }
        }
        return this;
    }

    public MatrixParam addToPoint(LatLng toPoint) {
        if (toPoint != null) {
            this.toPoints.add(toPoint);
        }
        return this;
    }

    public MatrixParam addToPoints(Iterator<LatLng> ls2) {
        if (ls2 != null) {
            Iterator<LatLng> it2 = ls2;
            while (it2.hasNext()) {
                LatLng l2 = it2.next();
                if (l2 == null) continue;
                this.toPoints.add(l2);
            }
        }
        return this;
    }

    @Override
    public boolean checkParams() {
        return this.fromPoints != null && this.toPoints != null && this.mode != null;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (this.fromPoints.size() > 0) {
            StringBuilder b2 = new StringBuilder();
            for (HeadingLatLng headingLatLng : this.fromPoints) {
                b2.append(this.locationToParamsString(headingLatLng));
                b2.append(";");
            }
            StringBuilder stringBuilder = b2;
            stringBuilder.setLength(stringBuilder.length() - 1);
            params.put("from", b2.toString());
        }
        if (this.toPoints.size() > 0) {
            StringBuilder b2 = new StringBuilder();
            for (LatLng latLng : this.toPoints) {
                b2.append(this.locationToParamsString(latLng));
                b2.append(";");
            }
            StringBuilder stringBuilder = b2;
            stringBuilder.setLength(stringBuilder.length() - 1);
            params.put("to", b2.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mode)) {
            params.put("mode", this.mode);
        }
        return params;
    }

    protected MatrixParam setMode(ModeType mode) {
        this.mode = mode.mode;
        return this;
    }

    private String locationToParamsString(HeadingLatLng l2) {
        String paramString = l2.latitude + "," + l2.longitude;
        if (l2.mHeading != null) {
            paramString = paramString + "," + l2.mHeading;
        }
        return paramString;
    }

    private String locationToParamsString(LatLng l2) {
        return l2.latitude + "," + l2.longitude;
    }

    public static class HeadingLatLng
    extends LatLng {
        public Integer mHeading;

        public HeadingLatLng(LatLng mPoint, int mHeading) {
            this.latitude = mPoint.latitude;
            this.longitude = mPoint.longitude;
            this.mHeading = mHeading;
        }

        public HeadingLatLng(LatLng mPoint) {
            this.latitude = mPoint.latitude;
            this.longitude = mPoint.longitude;
        }
    }

    public static enum ModeType {
        DRIVING("driving"),
        WALKING("walking"),
        BICYCLING("bicycling"),
        TRUCKING("trucking");

        public final String mode;

        private ModeType(String value) {
            this.mode = value;
        }
    }
}

