/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.RoutePlanningParam;
import com.tencent.lbssearch.object.result.TransitResultObject;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class TransitParam
extends RoutePlanningParam {
    private String policy;
    private long departureTime;

    public TransitParam() {
    }

    public TransitParam(LatLng from, LatLng to2) {
        super(from, to2);
    }

    public TransitParam policy(RoutePlanningParam.TransitPolicy policy) {
        StringBuilder stringBuilder = new StringBuilder();
        if (policy != null) {
            stringBuilder.append(policy.name());
        }
        this.policy = stringBuilder.toString();
        return this;
    }

    public TransitParam policy(Policy policy, Preference ... preferences) {
        StringBuilder stringBuilder = new StringBuilder();
        if (policy != null) {
            stringBuilder.append(policy.name());
        }
        if (preferences != null && preferences.length > 0) {
            Preference[] preferenceArray = preferences;
            int n2 = preferences.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Preference preference = preferenceArray[i2];
                stringBuilder.append(",").append(preference.name());
            }
        }
        this.policy = stringBuilder.toString();
        return this;
    }

    public TransitParam departureTime(long departureTime) {
        this.departureTime = departureTime;
        return this;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = super.buildParameters();
        if (!TextUtils.isEmpty((CharSequence)this.policy)) {
            params.put("policy", this.policy);
        }
        if (this.departureTime > 0L) {
            params.put("departure_time", this.departureTime);
        }
        return params;
    }

    @Override
    public String getUrl() {
        return "https://apis.map.qq.com/ws/direction/v1/transit";
    }

    public Class<TransitResultObject> getResultClass() {
        return TransitResultObject.class;
    }

    public static enum Preference {
        NO_SUBWAY;

    }

    public static enum Policy {
        LEAST_TIME,
        LEAST_TRANSFER,
        LEAST_WALKING;

    }
}

