/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.MatrixParam;

public class TruckingMatrixParam
extends MatrixParam {
    private TruckSize truckSize = TruckSize.LIGHT;
    private double truckLength = 4.2;
    private double truckHeight = 1.8;
    private double truckWidth = 1.9;
    private double truckWeight = 2.5;
    private double axleWeight = 2.0;
    private double truckLoad = 2.0;
    private int axleCount = 2;
    private TrailerType trailerType = TrailerType.NONE;
    private GoodsType goodsType = GoodsType.ORIGINAL;
    private EnergyType energyType = EnergyType.UNLIMITED;
    private GasEmissionStandard gasEmissionStandard = GasEmissionStandard.UNLIMITED;
    private PassType passType = PassType.UNLIMITED_PASS;
    private String truckNumber;
    private PlateColor plateColor = PlateColor.BLUE;

    @Override
    public boolean checkParams() {
        this.setMode(MatrixParam.ModeType.TRUCKING);
        return super.checkParams();
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = super.buildParameters();
        params.put("size", this.truckSize.size);
        params.put("length", this.truckLength);
        params.put("height", this.truckHeight);
        params.put("width", this.truckWidth);
        params.put("weight", this.truckWeight);
        params.put("load", this.truckLoad);
        params.put("axle_weight", this.axleWeight);
        params.put("axle_count", this.axleCount);
        params.put("trailer_type", this.trailerType.trailerType);
        params.put("goods_type", this.goodsType.goodsType);
        params.put("energy_type", this.energyType.energyType);
        params.put("gas_emisstand", this.gasEmissionStandard.gasEmissionStandard);
        params.put("pass_type", this.passType.passType);
        if (!TextUtils.isEmpty((CharSequence)this.truckNumber)) {
            params.put("plate_number", this.truckNumber);
        }
        params.put("plate_color", this.plateColor.plateColor);
        return params;
    }

    public TruckingMatrixParam setTruckSize(TruckSize size) {
        this.truckSize = size;
        return this;
    }

    public TruckingMatrixParam setTruckLength(double length) {
        this.truckLength = length;
        return this;
    }

    public TruckingMatrixParam setTruckHeight(double height) {
        this.truckHeight = height;
        return this;
    }

    public TruckingMatrixParam setTruckWidth(double width) {
        this.truckWidth = width;
        return this;
    }

    public TruckingMatrixParam setTruckWeight(double weight) {
        this.truckWeight = weight;
        return this;
    }

    public TruckingMatrixParam setTruckLoad(double load) {
        this.truckLoad = load;
        return this;
    }

    public TruckingMatrixParam setAxleWeight(double axleWeight) {
        this.axleWeight = axleWeight;
        return this;
    }

    public TruckingMatrixParam setAxleCount(int axleCount) {
        this.axleCount = axleCount;
        return this;
    }

    public TruckingMatrixParam setTruckNumber(String truckNumber) {
        this.truckNumber = truckNumber;
        return this;
    }

    public TruckingMatrixParam setPlateColor(PlateColor color) {
        this.plateColor = color;
        return this;
    }

    public TruckingMatrixParam setTrailerType(TrailerType trailerType) {
        this.trailerType = trailerType;
        return this;
    }

    public TruckingMatrixParam setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
        return this;
    }

    public TruckingMatrixParam setEnergyType(EnergyType energyType) {
        this.energyType = energyType;
        return this;
    }

    public TruckingMatrixParam setGasEmissionStandard(GasEmissionStandard gasEmissionStandard) {
        this.gasEmissionStandard = gasEmissionStandard;
        return this;
    }

    public TruckingMatrixParam setPassType(PassType passType) {
        this.passType = passType;
        return this;
    }

    public static enum PassType {
        UNLIMITED_PASS(0),
        HAS_PASS(1),
        NO_PASS(2),
        RESERVE_PASS(3);

        public final int passType;

        private PassType(int value) {
            this.passType = value;
        }
    }

    public static enum GasEmissionStandard {
        UNLIMITED(0),
        NATIONAL_STANDARD_I(1),
        NATIONAL_STANDARD_II(2),
        NATIONAL_STANDARD_III(3),
        NATIONAL_STANDARD_IV(4),
        NATIONAL_STANDARD_V(5),
        NATIONAL_STANDARD_VI(6);

        public final int gasEmissionStandard;

        private GasEmissionStandard(int value) {
            this.gasEmissionStandard = value;
        }
    }

    public static enum EnergyType {
        UNLIMITED(0),
        DIESEL(1),
        GAS_ELECTRIC_HYBRID(2),
        ELECTRIC(3),
        GASOLINE(4);

        public final int energyType;

        private EnergyType(int value) {
            this.energyType = value;
        }
    }

    public static enum GoodsType {
        ORIGINAL(0),
        DANGEROUS(1);

        public final int goodsType;

        private GoodsType(int value) {
            this.goodsType = value;
        }
    }

    public static enum TrailerType {
        NONE(0),
        FLATBED(1),
        VAN(2),
        SEMITRAILER(3),
        FULLTRAILER(4);

        public final int trailerType;

        private TrailerType(int value) {
            this.trailerType = value;
        }
    }

    public static enum TruckSize {
        TINY(1),
        LIGHT(2),
        MIDDLE(3),
        HEAVY(4);

        public final int size;

        private TruckSize(int value) {
            this.size = value;
        }
    }

    public static enum PlateColor {
        BLUE(1),
        YELLOW(2),
        BLACK(3),
        WHITE(4),
        GREEN(5);

        public final int plateColor;

        private PlateColor(int value) {
            this.plateColor = value;
        }
    }
}

