/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.support.annotation.Keep;
import com.tencent.map.lib.models.OverlayListenerInfo;
import com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

@Keep
public class AggregationOverlayInfo
extends OverlayListenerInfo {
    protected int mType = 0;
    protected WeightedLatLng[] mNodes;
    protected float mSize = 2000.0f;
    protected float mGap = 0.0f;
    protected float mOpacity = 1.0f;
    private static final float DEFAULT_MIN_OPACITY = 0.0f;
    private static final float DEFAULT_MAX_OPACITY = 1.0f;
    private static final int DEFAULT_MAX_ZOOM = 22;
    private static final int DEFAULT_MIN_ZOOM = 3;
    protected boolean mVisibility = true;
    protected int mMinZoom = 3;
    protected int mMaxZoom = 22;
    protected int mDisplayLevel = 1;
    protected int mZIndex = 0;
    protected double mMinHeight = 0.0;
    protected double mMaxHeight = 1000.0;
    protected double mMinIntensity = 0.0;
    protected double mMaxIntensity = 2000.0;
    protected boolean mRangeFlag = false;
    protected int[] mColors = new int[]{1174031124, -1711650028, -637908204};
    protected double[] mStartPoints = new double[]{0.0, 0.6, 0.8};
    protected boolean mDraw3D = false;
    protected boolean mAnimate = false;
    protected int mAnimateDuration = 5000;
    protected LatLng mGeoReferencePoint;

    public AggregationOverlayInfo() {
        this.mNodes = new WeightedLatLng[0];
    }

    public void setType(int type) {
        this.mType = type;
    }

    public void setNodes(WeightedLatLng[] nodes) {
        this.mNodes = nodes;
    }

    public void setSize(float size) {
        this.mSize = size;
    }

    public void setGap(float gap) {
        this.mGap = gap;
    }

    public void setOpacity(float opacity) {
        if (opacity > 1.0f) {
            this.mOpacity = 1.0f;
            return;
        }
        if (opacity < 0.0f) {
            this.mOpacity = 0.0f;
            return;
        }
        this.mOpacity = opacity;
    }

    public void setVisibility(boolean visibility) {
        this.mVisibility = visibility;
    }

    public boolean isVisible() {
        return this.mVisibility;
    }

    public void setMinZoom(int minZoom) {
        if (minZoom >= 3) {
            this.mMinZoom = minZoom;
            return;
        }
        this.mMinZoom = 3;
    }

    public void setMaxZoom(int maxZoom) {
        if (maxZoom <= 22) {
            this.mMaxZoom = maxZoom;
            return;
        }
        this.mMaxZoom = 22;
    }

    public void setDisplayLevel(int displayLevel) {
        if (displayLevel == 1 || displayLevel == 2) {
            this.mDisplayLevel = displayLevel;
        }
    }

    public void setZIndex(int zIndex) {
        this.mZIndex = zIndex;
    }

    public void setColors(int[] colors) {
        this.mColors = colors;
    }

    public void setStartPoints(double[] startPoints) {
        this.mStartPoints = startPoints;
    }

    public void setDraw3D(boolean draw3D) {
        this.mDraw3D = draw3D;
    }

    public void setHeightRange(double start, double end) {
        if (start <= end && start >= 0.0) {
            this.mMaxHeight = end;
            this.mMinHeight = start;
            return;
        }
        this.mMinHeight = 0.0;
        this.mMaxHeight = 1000.0;
    }

    public void setShowRange(double start, double end) {
        if (start <= end && start >= 0.0) {
            this.mMinIntensity = start;
            this.mMaxIntensity = end;
            this.mRangeFlag = true;
            return;
        }
        this.mMinIntensity = 0.0;
        this.mMaxIntensity = 2000.0;
        this.mRangeFlag = false;
    }

    public void setAnimate(boolean animate) {
        this.mAnimate = animate;
    }

    public void setAnimateTime(int animateDuration) {
        this.mAnimateDuration = animateDuration;
    }

    public boolean isAnimate() {
        return this.mAnimate;
    }

    public void setZoomLevelRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            this.setMinZoom(minZoom);
            this.setMaxZoom(maxZoom);
        }
    }
}

