/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.support.annotation.Keep;
import com.tencent.map.lib.models.OverlayListenerInfo;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLngBounds;

@Keep
public class GLModelInfo
extends OverlayListenerInfo {
    protected String mModelFilePath;
    protected LatLng mPosition;
    protected int mCoordType;
    protected double mAltitude;
    protected double mScale = 1.0;
    protected float mRotationX;
    protected float mRotationY;
    protected float mRotationZ;
    protected LatLngBounds mLatLngBounds;
    protected int mAnimate = 0;
    protected int mMinZoom = 3;
    protected int mMaxZoom = 22;
    protected float opacity = 1.0f;
    private static final float DEFAULT_MIN_OPACITY = 0.0f;
    private static final float DEFAULT_MAX_OPACITY = 1.0f;
    private static final int DEFAULT_MAX_ZOOM = 22;
    private static final int DEFAULT_MIN_ZOOM = 3;
    protected int level = 1;
    protected int zIndex = 0;
    protected boolean visible = true;
    protected float exposure = 1.0f;
    protected boolean buildingHidden = true;
    protected boolean clickEnabled = false;
    protected int mPixelWidth = 64;
    protected int mPixelHeight = 64;
    protected boolean unlit = false;

    public void setOpacity(float opacity) {
        if (opacity > 1.0f) {
            this.opacity = 1.0f;
            return;
        }
        if (opacity < 0.0f) {
            this.opacity = 0.0f;
            return;
        }
        this.opacity = opacity;
    }

    public void setLevel(int level) {
        if (level == 1 || level == 2) {
            this.level = level;
        }
    }

    public void setzIndex(int zIndex) {
        this.zIndex = zIndex;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setMinZoom(int minZoom) {
        if (minZoom >= 3) {
            this.mMinZoom = minZoom;
            return;
        }
        this.mMinZoom = 3;
    }

    public void setMaxZoom(int maxZoom) {
        if (maxZoom <= 22) {
            this.mMaxZoom = maxZoom;
            return;
        }
        this.mMaxZoom = 22;
    }

    public void enableClick(boolean enable) {
        this.clickEnabled = enable;
    }

    public boolean isClickEnabled() {
        return this.clickEnabled;
    }

    public void setModelPosition(LatLng position) {
        this.mPosition = position;
        this.mAltitude = position.getAltitude();
    }

    public LatLng getPosition() {
        return this.mPosition;
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public double getScale() {
        return this.mScale;
    }

    public void setRotationX(float x2) {
        this.mRotationX = x2;
    }

    public void setRotationY(float y2) {
        this.mRotationY = y2;
    }

    public void setRotationZ(float z2) {
        this.mRotationZ = z2;
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public float getRotationZ() {
        return this.mRotationZ;
    }

    public void setPixelBound(int width, int height) {
        this.mPixelWidth = width;
        this.mPixelHeight = height;
    }

    public void setCoordType(int type) {
        this.mCoordType = type;
    }

    public void setExposure(float exposure) {
        this.exposure = exposure;
    }

    public float getExposure() {
        return this.exposure;
    }

    public void setUnlit(boolean unlit) {
        this.unlit = unlit;
    }

    public boolean getUnlit() {
        return this.unlit;
    }

    public void setZoomLevelRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            this.setMinZoom(minZoom);
            this.setMaxZoom(maxZoom);
        }
    }
}

