/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization.aggregation;

import android.graphics.Color;
import com.tencent.map.sdk.utilities.visualization.BaseOverlayProvider;
import com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public abstract class AggregationOverlayProvider
extends BaseOverlayProvider {
    private int mType = 0;
    private WeightedLatLng[] mNodes;
    private float mSize = 2000.0f;
    private static final int DEFAULT_MIN_SIZE = 10;
    private static final int DEFAULT_SIZE = 2000;
    private float mGap = 0.0f;
    private int[] mColors = DEFAULT_COLORS;
    private double[] mStartPoints = DEFAULT_START_POINTS;
    private static final int[] DEFAULT_COLORS = new int[]{Color.argb((int)255, (int)31, (int)44, (int)71), Color.argb((int)255, (int)40, (int)72, (int)138), Color.argb((int)255, (int)38, (int)97, (int)217), Color.argb((int)255, (int)90, (int)140, (int)242), Color.argb((int)255, (int)153, (int)187, (int)255)};
    private static final double[] DEFAULT_START_POINTS = new double[]{0.0, 0.1f, 0.15f, 0.3f, 0.5};
    private double mMinIntensity = 0.0;
    private double mMaxIntensity = 2000.0;
    private static final int DEFAULT_MIN_INTENSITY = 0;
    private static final int DEFAULT_MAX_INTENSITY = 2000;
    private boolean mRangeFlag = false;
    private double mMaxHeight = 100.0;
    private double mMinHeight = 0.0;
    private static final double DEFAULT_MAX_HEIGHT = 100.0;
    private static final double DEFAULT_MIN_HEIGHT = 0.0;
    private boolean mDraw3D = false;
    private LatLng mGeoReferencePoint;
    private boolean mAnimate = false;
    private int mAnimateDuration = 0;

    protected AggregationOverlayProvider type(AggregationOverlayType type) {
        this.mType = type.ordinal();
        return this;
    }

    public AggregationOverlayProvider nodes(WeightedLatLng[] nodes) {
        if (nodes != null) {
            this.mNodes = nodes;
        }
        return this;
    }

    public AggregationOverlayProvider size(float size) {
        if (size < 10.0f) {
            return this;
        }
        this.mSize = size;
        return this;
    }

    public AggregationOverlayProvider gap(float gap) {
        if (gap >= 0.0f) {
            this.mGap = gap;
        }
        return this;
    }

    @Override
    public float getOpacity() {
        return super.getOpacity();
    }

    @Override
    public AggregationOverlayProvider opacity(float opacity) {
        super.opacity(opacity);
        return this;
    }

    @Override
    public int getZIndex() {
        return super.getZIndex();
    }

    @Override
    public AggregationOverlayProvider zIndex(int zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    @Override
    public int getDisplayLevel() {
        return super.getDisplayLevel();
    }

    @Override
    public AggregationOverlayProvider displayLevel(int displayLevel) {
        super.displayLevel(displayLevel);
        return this;
    }

    @Override
    public boolean isVisibility() {
        return super.isVisibility();
    }

    @Override
    public AggregationOverlayProvider visibility(boolean visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public int getMinZoom() {
        return super.getMinZoom();
    }

    @Override
    public int getMaxZoom() {
        return super.getMaxZoom();
    }

    public AggregationOverlayProvider zoomRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            super.minZoom(minZoom);
            super.maxZoom(maxZoom);
        }
        return this;
    }

    public AggregationOverlayProvider colors(int[] colors, double[] startPoints) {
        if (colors != null && startPoints != null && colors.length > 0 && startPoints.length > 0 && colors.length == startPoints.length) {
            boolean flag = true;
            for (int i2 = 1; i2 < startPoints.length; ++i2) {
                if (!(startPoints[i2 - 1] > startPoints[i2])) continue;
                flag = false;
                break;
            }
            if (flag && startPoints[0] >= 0.0 && startPoints[startPoints.length - 1] <= 1.0) {
                this.mColors = colors;
                this.mStartPoints = startPoints;
            }
        }
        return this;
    }

    AggregationOverlayType getOverlayType() {
        return AggregationOverlayType.values()[this.mType];
    }

    public AggregationOverlayProvider setHeightRange(double minHeight, double maxHeight) {
        if (minHeight <= maxHeight && minHeight >= 0.0) {
            this.mMaxHeight = maxHeight;
            this.mMinHeight = minHeight;
        }
        return this;
    }

    public AggregationOverlayProvider setIntensityRange(double minIntensity, double maxIntensity) {
        if (minIntensity < maxIntensity && minIntensity >= 0.0) {
            this.mMaxIntensity = maxIntensity;
            this.mMinIntensity = minIntensity;
            this.mRangeFlag = true;
        }
        return this;
    }

    public AggregationOverlayProvider enable3D(boolean enable3D) {
        this.mDraw3D = enable3D;
        return this;
    }

    public boolean isEnable3D() {
        return this.mDraw3D;
    }

    public LatLng getGeoReferencePoint() {
        return this.mGeoReferencePoint;
    }

    public void setGeoReferencePoint(LatLng mGeoReferencePoint) {
        this.mGeoReferencePoint = mGeoReferencePoint;
    }

    public AggregationOverlayProvider setAnimateDuration(int animateDuration) {
        if (animateDuration == 0) {
            this.mAnimate = false;
            this.mAnimateDuration = 0;
        } else if (animateDuration > 0) {
            this.mAnimateDuration = animateDuration;
            this.mAnimate = true;
        }
        return this;
    }

    public int getAnimateDuration() {
        return this.mAnimateDuration;
    }

    public int getType() {
        return this.getOverlayType().ordinal();
    }

    public WeightedLatLng[] getNodes() {
        return this.mNodes;
    }

    public float getSize() {
        return this.mSize;
    }

    public float getGap() {
        return this.mGap;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public double[] getStartPoints() {
        return this.mStartPoints;
    }

    public double getMaxHeight() {
        return this.mMaxHeight;
    }

    public double getMinHeight() {
        return this.mMinHeight;
    }

    public double getMaxIntensity() {
        return this.mMaxIntensity;
    }

    public double getMinIntensity() {
        return this.mMinIntensity;
    }

    public boolean getRangeFlag() {
        return this.mRangeFlag;
    }

    public boolean isAnimate() {
        return this.mAnimate;
    }

    public static enum AggregationOverlayType {
        HoneyComb,
        Square;

    }
}

