/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization.scatterplot;

import com.tencent.map.sdk.utilities.visualization.BaseOverlayProvider;
import com.tencent.map.sdk.utilities.visualization.datamodels.ScatterLatLng;
import java.util.ArrayList;
import java.util.List;

public abstract class ScatterPlotOverlayProvider
extends BaseOverlayProvider {
    private List<ScatterLatLng> dataList = new ArrayList<ScatterLatLng>();
    private int mType = 0;
    private boolean mDraw3D = false;

    public List<ScatterLatLng> getData() {
        return this.dataList;
    }

    public ScatterPlotOverlayProvider data(List<ScatterLatLng> val) {
        if (val != null) {
            this.dataList = val;
        }
        return this;
    }

    protected ScatterPlotOverlayProvider type(ScatterPlotType type) {
        this.mType = type.ordinal();
        return this;
    }

    public int getType() {
        return ScatterPlotType.values()[this.mType].ordinal();
    }

    @Override
    public float getOpacity() {
        return super.getOpacity();
    }

    @Override
    public ScatterPlotOverlayProvider opacity(float opacity) {
        super.opacity(opacity);
        return this;
    }

    public boolean isEnable3D() {
        return this.mDraw3D;
    }

    public ScatterPlotOverlayProvider enable3D(boolean draw3D) {
        this.mDraw3D = draw3D;
        return this;
    }

    public ScatterPlotOverlayProvider zoomRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            super.minZoom(minZoom);
            super.maxZoom(maxZoom);
        }
        return this;
    }

    @Override
    public int getMinZoom() {
        return super.getMinZoom();
    }

    @Override
    public int getMaxZoom() {
        return super.getMaxZoom();
    }

    @Override
    public boolean isVisibility() {
        return super.isVisibility();
    }

    @Override
    public ScatterPlotOverlayProvider visibility(boolean visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public int getZIndex() {
        return super.getZIndex();
    }

    @Override
    public ScatterPlotOverlayProvider zIndex(int zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    @Override
    public int getDisplayLevel() {
        return super.getDisplayLevel();
    }

    @Override
    public ScatterPlotOverlayProvider displayLevel(int displayLevel) {
        super.displayLevel(displayLevel);
        return this;
    }

    public static enum ScatterPlotType {
        Dot,
        Bitmap;

    }
}

