/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.json;

import android.text.TextUtils;
import com.tencent.map.tools.Util;
import com.tencent.map.tools.json.JsonEncoder;
import com.tencent.map.tools.json.JsonParser;
import com.tencent.map.tools.json.annotation.JsonType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static <T> List<T> parseToList(JSONArray jsonArray, Class<T> modelClass, Object ... modelConstructParams) {
        ArrayList<T> list = new ArrayList<T>();
        if (jsonArray != null) {
            for (int i2 = 0; i2 < jsonArray.length(); ++i2) {
                list.add(JsonUtils.parseToModel(jsonArray.optJSONObject(i2), modelClass, modelConstructParams));
            }
        }
        return list;
    }

    public static <C extends Collection> C parseTo(Class<C> collectionClz, JSONArray jsonArray, Class modelClass, Object ... modelConstructParams) {
        Collection collection = (Collection)Util.newInstance(collectionClz, new Object[0]);
        if (jsonArray != null) {
            for (int i2 = 0; i2 < jsonArray.length(); ++i2) {
                Object o2 = jsonArray.opt(i2);
                if (o2 instanceof JSONArray) {
                    C nestColl = JsonUtils.parseTo(collectionClz, (JSONArray)o2, modelClass, modelConstructParams);
                    collection.add(nestColl);
                    continue;
                }
                if (o2 instanceof JSONObject) {
                    collection.add(JsonUtils.parseToModel((JSONObject)o2, modelClass, modelConstructParams));
                    continue;
                }
                if (o2.getClass() == modelClass) {
                    collection.add(o2);
                    continue;
                }
                if (o2 instanceof Integer) {
                    if (modelClass == Double.class) {
                        collection.add(((Integer)o2).doubleValue());
                        continue;
                    }
                    if (modelClass == Long.class) {
                        collection.add(((Integer)o2).longValue());
                        continue;
                    }
                    if (modelClass == Float.class) {
                        collection.add(Float.valueOf(((Integer)o2).floatValue()));
                        continue;
                    }
                    if (modelClass != String.class) continue;
                    collection.add(o2.toString());
                    continue;
                }
                if (o2 instanceof Double) {
                    if (modelClass == Integer.class) {
                        collection.add(((Double)o2).intValue());
                        continue;
                    }
                    if (modelClass == Long.class) {
                        collection.add(((Double)o2).longValue());
                        continue;
                    }
                    if (modelClass == Float.class) {
                        collection.add(Float.valueOf(((Double)o2).floatValue()));
                        continue;
                    }
                    if (modelClass != String.class) continue;
                    collection.add(o2.toString());
                    continue;
                }
                if (!(o2 instanceof Long)) continue;
                if (modelClass == Integer.class) {
                    collection.add(((Long)o2).intValue());
                    continue;
                }
                if (modelClass == Double.class) {
                    collection.add(((Long)o2).doubleValue());
                    continue;
                }
                if (modelClass == Float.class) {
                    collection.add(Float.valueOf(((Long)o2).floatValue()));
                    continue;
                }
                if (modelClass != String.class) continue;
                collection.add(o2.toString());
            }
        }
        return (C)collection;
    }

    public static <T> T parseToModel(JSONObject jsonObject, Class<T> modelClass, Object ... modelConstructParams) {
        Class<? extends JsonParser.Deserializer> deserializerClass;
        T model = null;
        JsonType jsonTypeAnnotation = modelClass.getAnnotation(JsonType.class);
        if (jsonTypeAnnotation != null && (deserializerClass = jsonTypeAnnotation.deserializer()) != JsonParser.Deserializer.class) {
            JsonParser.Deserializer deserializerObj = Util.newInstance(deserializerClass, new Object[0]);
            try {
                Object deserializerCreatedObj = deserializerObj.deserialize(null, "", jsonObject);
                if (deserializerCreatedObj != null && modelClass.isAssignableFrom(deserializerCreatedObj.getClass())) {
                    model = deserializerCreatedObj;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (model == null) {
            model = Util.newInstance(modelClass, modelConstructParams);
        }
        if (model instanceof JsonParser) {
            ((JsonParser)model).parse(jsonObject);
        }
        return model;
    }

    public static <T> T parseToModel(String json, Class<T> modelClass, Object ... modelConstructParams) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return JsonUtils.parseToModel(new JSONObject(json), modelClass, modelConstructParams);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public static <T> String modelToJsonString(T model) {
        JSONObject jsonObject = JsonUtils.modelToJson(model);
        if (jsonObject != null) {
            return jsonObject.toString();
        }
        return null;
    }

    public static <T> JSONObject modelToJson(T model) {
        if (model instanceof JsonEncoder) {
            return ((JsonEncoder)model).toJson();
        }
        return null;
    }

    public static <T> String collectionToJson(Collection<T> models) {
        if (models == null || models.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (T model : models) {
            if (model instanceof JsonEncoder) {
                JSONObject jsonObject = ((JsonEncoder)model).toJson();
                jsonArray.put((Object)jsonObject);
                continue;
            }
            jsonArray.put(null);
        }
        return jsonArray.toString();
    }

    public static Object parseToArray(JSONArray array, Class clz) {
        if (array == null) {
            return null;
        }
        int length = array.length();
        Object arrayClz = Array.newInstance(clz, length);
        for (int i2 = 0; i2 < length; ++i2) {
            try {
                Object value = array.get(i2);
                Array.set(arrayClz, i2, value);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return arrayClz;
    }
}

