/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import com.tencent.map.tools.net.NetRequest;
import com.tencent.map.tools.net.exception.NetErrorException;
import com.tencent.map.tools.net.processor.Processor;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetResponse {
    public int errorCode = -1;
    public int statusCode;
    public byte[] data;
    public String charset = "GBK";
    public Exception exception;
    public byte[] errorData;
    public String contentEncoding;
    public int contentLength;
    public String requestUrl;
    public InputStream dataStream;
    public final Map<String, String> respHeads = new HashMap<String, String>();
    private List<Processor> respProcessorSet;
    public long mRequestId;

    public NetResponse() {
    }

    public NetResponse(NetRequest request) {
        this.mRequestId = request.mRequestId;
        this.respProcessorSet = request.processors;
        this.requestUrl = request.url;
    }

    public boolean available() {
        return this.errorCode == 0 && this.statusCode == 200 || this.data != null && this.data.length > 0;
    }

    public void exception(Exception exception) {
        this.exception = exception;
        if (exception instanceof NetErrorException) {
            this.errorCode = ((NetErrorException)exception).errorCode;
            this.statusCode = ((NetErrorException)exception).statusCode;
        }
    }

    public void clone(NetResponse netResponse) {
        if (netResponse != null) {
            this.errorCode = netResponse.errorCode;
            this.statusCode = netResponse.statusCode;
            this.data = netResponse.data;
            this.charset = netResponse.charset;
            this.exception = netResponse.exception;
            this.errorData = netResponse.errorData;
        }
    }

    public String toString() {
        try {
            if (this.data != null) {
                return new String(this.data, this.charset);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public String toHumanString() {
        if (this.data != null) {
            return "[DATA] " + (float)this.data.length / 1024.0f + "KB " + new String(this.data, Charset.forName("utf-8"));
        }
        if (this.errorData != null) {
            if (this.exception != null) {
                this.exception.printStackTrace();
            }
            return "[ERROR] " + new String(this.errorData);
        }
        return "";
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getData() {
        if (this.data != null) {
            return new String(this.data);
        }
        return "";
    }

    public String getErrorMessage() {
        if (this.errorData != null) {
            return new String(this.errorData);
        }
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return "";
    }

    public String getHeaderField(String key) {
        return this.respHeads.get(key);
    }

    public InputStream getInputStream() {
        return this.dataStream;
    }

    public List<Processor> getProcessors() {
        return this.respProcessorSet;
    }
}

