/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@SuppressLint(value={"MissingPermission"})
public class NetUtil {
    public static final int TYPE_NET_WORK_DISABLED = 0;
    public static final int TYPE_CMWAP = 1;
    public static final int TYPE_UNIWAP = 2;
    public static final int TYPE_3GWAP = 3;
    public static final int TYPE_CTWAP = 4;
    public static final int TYPE_WIFI = 5;
    public static final int TYPE_OTHER_NET = 6;
    public static final String MAP_USER_AGENT = "QQ Map Mobile";
    public static final String STR_UserAgent = "androidsdk";
    public static final int DEFAULT_TIME_OUT = 10000;
    public static final String WIFI = "wifi";
    private static final String CTWAP = "ctwap";
    private static final String CMWAP = "cmwap";
    private static final String WAP_3G = "3gwap";
    private static final String NET_3G = "3gnet";
    private static final String UNIWAP = "uniwap";
    private static final int BUF_SIZE = 4096;

    public static NetworkInfo getNetworkInfo(Context ctx) {
        try {
            return ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getNetType(Context ctx) {
        return NetUtil.getNetType(NetUtil.getNetworkInfo(ctx));
    }

    public static String getNetTypeStr(Context ctx) {
        int netType = NetUtil.getNetType(ctx);
        String netTypeStr = "";
        switch (netType) {
            case 5: {
                netTypeStr = WIFI;
                break;
            }
            case 3: {
                netTypeStr = WAP_3G;
                break;
            }
            case 2: {
                netTypeStr = UNIWAP;
                break;
            }
            case 1: {
                netTypeStr = CMWAP;
                break;
            }
            case 4: {
                netTypeStr = CTWAP;
            }
        }
        return netTypeStr;
    }

    private static int getNetType(NetworkInfo networkInfo) {
        if (networkInfo == null || !networkInfo.isAvailable()) {
            return 0;
        }
        int netType = networkInfo.getType();
        if (netType == 1) {
            return 5;
        }
        if (netType != 0) {
            return 6;
        }
        String netMode = networkInfo.getExtraInfo();
        if (TextUtils.isEmpty((CharSequence)netMode)) {
            return 6;
        }
        if (netMode.equalsIgnoreCase(CMWAP)) {
            return 1;
        }
        if (netMode.equalsIgnoreCase(WAP_3G)) {
            return 3;
        }
        if (netMode.equalsIgnoreCase(UNIWAP)) {
            return 2;
        }
        if (netMode.equalsIgnoreCase(CTWAP)) {
            return 4;
        }
        return 3;
    }

    public static String getNetworkType(Context ctx) {
        try {
            NetworkInfo networkInfo = ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo != null) {
                int type = networkInfo.getType();
                if (type == 1) {
                    return WIFI;
                }
                if (type == 0) {
                    switch (networkInfo.getSubtype()) {
                        case 4: {
                            return "2g";
                        }
                        case 2: {
                            return "2g";
                        }
                        case 5: {
                            return "3g";
                        }
                        case 6: {
                            return "3g";
                        }
                        case 1: {
                            return "2g";
                        }
                        case 8: {
                            return "3g";
                        }
                        case 3: {
                            return "3g";
                        }
                    }
                    return "other";
                }
                return "other";
            }
            return "unknown";
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public static boolean isNetAvailable(Context ctx) {
        try {
            ConnectivityManager manager = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo active = NetUtil.getNetworkInfo(ctx);
            if (active != null) {
                return active.isAvailable();
            }
            for (NetworkInfo info : manager.getAllNetworkInfo()) {
                if (!info.isAvailable() || !info.isConnectedOrConnecting()) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean isWifi(Context ctx) {
        return NetUtil.getNetType(ctx) == 5;
    }

    public static boolean isMobile(Context ctx) {
        int netType = NetUtil.getNetType(ctx);
        return netType != 0 && netType != 5;
    }

    public static final void safeClose(Closeable c2) {
        if (c2 != null) {
            try {
                c2.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] toBytesThrow(InputStream is2) throws IOException {
        ByteArrayOutputStream baos = null;
        if (is2 == null) {
            return null;
        }
        try {
            int count;
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((count = is2.read(buf, 0, 4096)) != -1) {
                baos.write(buf, 0, count);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            NetUtil.safeClose(baos);
        }
    }

    public static byte[] toBytes(InputStream is2) {
        try {
            return NetUtil.toBytesThrow(is2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void writeBytesWithoutClose(byte[] data, OutputStream outputStream) {
        if (data == null || data.length == 0 || outputStream == null) {
            return;
        }
        try {
            outputStream.write(data);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

