/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net.http;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;

public class HttpProxy {
    private final Proxy mProxy;
    private final String mProxyUrl;
    private final boolean mIsForward;

    public HttpProxy(Proxy proxy, String proxyUrl, boolean isForward) {
        this.mProxy = proxy;
        this.mProxyUrl = proxyUrl;
        this.mIsForward = isForward;
    }

    public Proxy getProxy() {
        return this.mProxy;
    }

    public String getProxyUrl() {
        return this.mProxyUrl;
    }

    public boolean isForward() {
        return this.mIsForward;
    }

    public static URL getProxyURL(HttpProxy proxy) throws MalformedURLException {
        if (proxy != null && !proxy.isForward()) {
            return new URL(proxy.getProxyUrl());
        }
        return null;
    }

    public static Proxy getForwardProxy(HttpProxy proxy) {
        if (proxy != null && proxy.isForward()) {
            return proxy.getProxy();
        }
        return Proxy.NO_PROXY;
    }

    public String toString() {
        return "HttpProxy{mProxy=" + this.mProxy + ", mProxyUrl='" + this.mProxyUrl + '\'' + ", mIsForward=" + this.mIsForward + '}';
    }
}

