/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.engine.jni;

import android.graphics.Rect;
import android.support.annotation.Keep;
import com.tencent.map.lib.JNIInterface;
import com.tencent.map.lib.callbacks.TileOverlayCallback;
import com.tencent.map.lib.models.AggregationOverlayInfo;
import com.tencent.map.lib.models.AnnocationText;
import com.tencent.map.lib.models.AnnocationTextResult;
import com.tencent.map.lib.models.ArcLineOverlayInfo;
import com.tencent.map.lib.models.CircleInfo;
import com.tencent.map.lib.models.CityTrafficInfo;
import com.tencent.map.lib.models.GLModelInfo;
import com.tencent.map.lib.models.GeoPoint;
import com.tencent.map.lib.models.GroundOverlayInfo;
import com.tencent.map.lib.models.HeatmapInfo;
import com.tencent.map.lib.models.IndoorCellInfo;
import com.tencent.map.lib.models.IntersectionOverlayInfo;
import com.tencent.map.lib.models.MarkerInfo;
import com.tencent.map.lib.models.MaskLayer;
import com.tencent.map.lib.models.PolygonInfo;
import com.tencent.map.lib.models.ScatterPlotInfo;
import com.tencent.map.lib.models.TrailOverlayInfo;
import com.tencent.mapsdk.engine.jni.JNICallback;
import com.tencent.mapsdk.internal.bu;
import com.tencent.mapsdk.internal.kp;
import com.tencent.mapsdk.internal.oe;
import com.tencent.mapsdk.internal.oh;
import com.tencent.mapsdk.internal.oj;
import com.tencent.mapsdk.internal.ok;
import com.tencent.mapsdk.internal.oo;
import com.tencent.mapsdk.internal.op;
import com.tencent.mapsdk.internal.oq;
import com.tencent.mapsdk.internal.or;
import com.tencent.mapsdk.internal.os;
import com.tencent.mapsdk.internal.ot;
import com.tencent.mapsdk.internal.w;
import com.tencent.mapsdk.shell.events.EngineWriteDataModel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLngBounds;
import com.tencent.tencentmap.mapsdk.maps.model.LightColor;
import com.tencent.tencentmap.mapsdk.maps.model.LightDirection;
import com.tencent.tencentmap.mapsdk.maps.model.LightType;
import com.tencent.tencentmap.mapsdk.maps.model.PolylineOptions;
import com.tencent.tencentmap.mapsdk.maps.model.TrafficStyle;
import com.tencent.tencentmap.mapsdk.maps.model.VectorHeatAggregationUnit;
import java.util.ArrayList;
import java.util.List;

@Keep
public class JNI {
    private JNICallback mCallback;
    private JNIInterface mJNIInterface;

    public void initCallback(oe mapGLRender, w res, ok downloadCallback, oj cancelDownloadCallback, os mapLoadFinishedCallback, oo indoorBuildingChangedCallback, or mapAnimCallback, bu crashInfoRecorder, ot paramChangedCallback, oq mapCameraChangeCallback, oh mapLayerClickResultCallback) {
        this.mCallback = new JNICallback(mapGLRender, res, downloadCallback, cancelDownloadCallback, mapLoadFinishedCallback, indoorBuildingChangedCallback, mapAnimCallback, crashInfoRecorder, paramChangedCallback, mapCameraChangeCallback, mapLayerClickResultCallback);
        this.mJNIInterface = new JNIInterface(this.mCallback);
    }

    public void registerCallback(long handle) {
        this.nativeSetCallback(handle);
    }

    public void destory() {
        this.mCallback.destory();
        this.mCallback = null;
        this.mJNIInterface = null;
    }

    public void setMapCallbackGetGLContext(op cbk) {
        if (this.mCallback != null) {
            this.mCallback.setMapCallbackGetGLContext(cbk);
        }
    }

    public float[] nativeGLProjectMatrix() {
        return this.mJNIInterface.nativeGLProjectMatrix();
    }

    public double[] nativeGLViewMatrix() {
        return this.mJNIInterface.nativeGLViewMatrix();
    }

    public float nativeGLViewScaleRatio() {
        return this.mJNIInterface.nativeGLViewScaleRatio();
    }

    public int[] nativeGLViewport() {
        return this.mJNIInterface.nativeGLViewport();
    }

    public static synchronized void nativeStartProfile() {
        JNIInterface.nativeStartProfile();
    }

    public static synchronized void nativeEndProfile() {
        JNIInterface.nativeEndProfile();
    }

    public long nativeInitEngine(String cfgPath, String dataPath, String satPath, float density, int tileSize, float textScale, int[] resultCodeOut, boolean useShareContext, int language) {
        return this.mJNIInterface.nativeInitEngine(cfgPath, dataPath, satPath, density, tileSize, textScale, resultCodeOut, useShareContext, language);
    }

    public void nativeDestroyEngine(long handle) {
        this.mJNIInterface.nativeDestroyEngine(handle);
    }

    public void nativeResetEnginePath(long handle, String cfgPath, String dataPath, String satPath) {
        this.mJNIInterface.nativeResetEnginePath(handle, cfgPath, dataPath, satPath);
    }

    public boolean nativeGenerateTextures(long handle) {
        return this.mJNIInterface.nativeGenerateTextures(handle);
    }

    public void nativeSetViewport(long handle, int x2, int y2, int width, int height) {
        this.mJNIInterface.nativeSetViewport(handle, x2, y2, width, height);
    }

    public void nativeSetMapParam(long handle, byte[] mapParamBytes) {
        this.mJNIInterface.nativeSetMapParam(handle, mapParamBytes);
    }

    public void nativeUpdateFrame(long handle, double curTimeBySecond) {
        this.mJNIInterface.nativeUpdateFrame(handle, curTimeBySecond);
    }

    public boolean nativeDrawFrame(long handle) {
        return this.mJNIInterface.nativeDrawFrame(handle);
    }

    public boolean nativeNeedDispaly(long handle) {
        return this.mJNIInterface.nativeNeedDispaly(handle);
    }

    public void nativeSetNeedDisplay(long handle, boolean needDisplay) {
        this.mJNIInterface.nativeSetNeedDisplay(handle, needDisplay);
    }

    public void nativeSetCallback(long handle) {
        this.mJNIInterface.nativeSetCallback(handle);
    }

    public boolean nativeNeedRedraw(long handle) {
        return this.mJNIInterface.nativeNeedRedraw(handle);
    }

    public byte[] nativeOnTap(long handle, float winx, float winy) {
        return this.mJNIInterface.nativeOnTap(handle, winx, winy);
    }

    public EngineWriteDataModel nativeWriteMapDataBlock(long handle, String url, byte[] data) {
        return this.mJNIInterface.nativeWriteMapDataBlock(handle, url, data);
    }

    public void nativeClearDownloadURLCache(long handle) {
        this.mJNIInterface.nativeClearDownloadURLCache(handle);
    }

    public void nativeLockEngine(long handle) {
        this.mJNIInterface.nativeLockEngine(handle);
    }

    public void nativeUnlockEngine(long handle) {
        this.mJNIInterface.nativeUnlockEngine(handle);
    }

    @Deprecated
    public boolean nativeIsMapDrawFinished(long handle) {
        return this.mJNIInterface.nativeIsMapDrawFinished(handle);
    }

    public int nativeClearCache(long handle) {
        return this.mJNIInterface.nativeClearCache(handle);
    }

    public void nativeHideCompass(long handle) {
        this.mJNIInterface.nativeHideCompass(handle);
    }

    public boolean nativeHasStreetRoad(long handle, String cityName) {
        return this.mJNIInterface.nativeHasStreetRoad(handle, cityName);
    }

    public void nativeShowStreetRoad(long handle) {
        this.mJNIInterface.nativeShowStreetRoad(handle);
    }

    public void nativeHideStreetRoad(long handle) {
        this.mJNIInterface.nativeHideStreetRoad(handle);
    }

    public void nativeSetSatelliteEnabled(long handle, boolean enabled) {
        this.mJNIInterface.nativeSetSatelliteEnabled(handle, enabled);
    }

    public void nativeShowTraffic(long handle) {
        this.mJNIInterface.nativeShowTraffic(handle);
    }

    public void nativeHideTraffic(long handle) {
        this.mJNIInterface.nativeHideTraffic(handle);
    }

    public void nativeSetTrafficColor(long handle, int blocked, int normal, int unblocked, int seriousBlocked) {
        this.mJNIInterface.nativeSetTrafficColor(handle, blocked, normal, unblocked, seriousBlocked);
    }

    public int nativeRefreshTrafficData(long handle, byte[] byteData, int dataLen, boolean bSwitch, boolean isChina) {
        return this.mJNIInterface.nativeRefreshTrafficData(handle, byteData, dataLen, bSwitch, isChina);
    }

    public void nativeSetTrafficMode(long handle, int mode, int zoomLevel) {
        this.mJNIInterface.nativeSetTrafficMode(handle, mode, zoomLevel);
    }

    public void nativeCheckTrafficBlockCache(long handle, int scaleLevel, int left, int top, int right, int bottom) {
        this.mJNIInterface.nativeCheckTrafficBlockCache(handle, scaleLevel, left, top, right, bottom);
    }

    public void nativeCheckTrafficBlockCacheForReplay(long handle, int scaleLevel, int left, int top, int right, int bottom) {
        this.mJNIInterface.nativeCheckTrafficBlockCacheForReplay(handle, scaleLevel, left, top, right, bottom);
    }

    public int[] nativeFetchLackedTrafficBlocks(long handle) {
        return this.mJNIInterface.nativeFetchLackedTrafficBlocks(handle);
    }

    public int nativeIsCityHasTraffic(long handle, String cityName) {
        return this.mJNIInterface.nativeIsCityHasTraffic(handle, cityName);
    }

    public boolean nativeGetTrafficCityInfo(long handle, String cityName, CityTrafficInfo cityTrafficInfoOut) {
        return this.mJNIInterface.nativeGetTrafficCityInfo(handle, cityName, cityTrafficInfoOut);
    }

    public void nativeSetBuilding3DEffect(long handler, boolean use3DEffect) {
        this.mJNIInterface.nativeSetBuilding3DEffect(handler, use3DEffect);
    }

    public void nativeSetBuildingBlackList(long handler, LatLngBounds[] latLngBounds) {
        this.mJNIInterface.nativeSetBuildingBlackList(handler, latLngBounds);
    }

    public int nativeAddPolygon(long handle, PolygonInfo polygon) {
        return this.mJNIInterface.nativeAddPolygon(handle, polygon);
    }

    public void nativeRemovePolygon(long handle, int polygonId, int polygonBordId, int[] holeLineIds) {
        this.mJNIInterface.nativeDeletePolygon(handle, polygonId, polygonBordId, holeLineIds);
    }

    public int nativeAddCircle(long handle, CircleInfo circleInfo) {
        return this.mJNIInterface.nativeAddCircle(handle, circleInfo);
    }

    public void nativeUpdateCircle(long handle, int circleId, CircleInfo circleInfo) {
        this.mJNIInterface.nativeUpdateCircle(handle, circleId, circleInfo);
    }

    public void nativeDeleteCircle(long handle, int circleId) {
        this.mJNIInterface.nativeDeleteCircle(handle, circleId);
    }

    public void nativeUpdatePolygon(long handle, int polygonId, int borldLineId, PolygonInfo polygon) {
        this.mJNIInterface.nativeUpdatePolygon(handle, polygonId, borldLineId, polygon);
    }

    public void nativeSetPolygonHidden(long handle, int polygonId, int borderLineId, boolean hide, int[] holeLineIds) {
        int[] nArray = new int[holeLineIds.length + 2];
        int[] icons = nArray;
        nArray[0] = polygonId;
        icons[1] = borderLineId;
        for (int i2 = 0; i2 < holeLineIds.length; ++i2) {
            icons[i2 + 2] = holeLineIds[i2];
        }
        this.nativeSetIconsHidden(handle, icons, holeLineIds.length + 2, hide);
    }

    public void nativeDeletePolygon(long handle, int polygonId, int borderLineId, int[] holeLineIds) {
        this.mJNIInterface.nativeDeletePolygon(handle, polygonId, borderLineId, holeLineIds);
    }

    public int nativeAddMaskLayer(long handle, MaskLayer layer) {
        return this.mJNIInterface.nativeAddMaskLayer(handle, layer);
    }

    public void nativeUpdateMaskLayer(long handle, int maskLayerId, int alpha) {
        this.mJNIInterface.nativeUpdateMaskLayer(handle, maskLayerId, alpha);
    }

    public void nativeRemoveMaskLayer(long handle, int maskLayerId) {
        this.mJNIInterface.nativeRemoveMaskLayer(handle, maskLayerId);
    }

    public void nativeFromScreenLocation(long handle, byte[] mapParam, float screenX, float screenY, double[] geoOut) {
        this.mJNIInterface.nativeFromScreenLocation(handle, mapParam, screenX, screenY, geoOut);
    }

    public void nativeToScreenLocation(long handle, byte[] mapParam, double lat, double lon, float[] screenOut) {
        this.mJNIInterface.nativeToScreenLocation(handle, mapParam, lat, lon, screenOut);
    }

    public void nativeFromMapSight(long handle, double[] geoOut) {
        this.mJNIInterface.nativeFromMapSight(handle, geoOut);
    }

    public byte[] nativeGetCityName(long handle, GeoPoint point) {
        return this.mJNIInterface.nativeGetCityName(handle, point);
    }

    public void nativeUpdateMapResource(long handle, String fileName) {
        this.mJNIInterface.nativeUpdateMapResource(handle, fileName);
    }

    public void nativeSetPriority(long handle, int id2, float zIndex) {
        this.mJNIInterface.nativeSetPriority(handle, id2, zIndex);
    }

    public int nativeCreateOrUpdateLine(long handle, int lineID, int[] segColors, int[] segIndexes, GeoPoint[] points, String imageName, float width, int drawType, boolean drawCap, boolean isSingleColor, boolean isRoad, boolean isGradient, float zIndex, boolean isARGBColor, int[] rgbaColorSet, int[] borderColorSet, float borderWidth, int[] pattern, float alpha, int level, boolean visible) {
        kp.b("TDZ", "create or update line = " + lineID + " p:" + points.length + " w:" + width + " v:" + visible + " a:" + alpha + " bw:" + borderWidth);
        return this.mJNIInterface.nativeCreateOrUpdateLine(handle, lineID, segColors, segIndexes, points, imageName, width, drawType, drawCap, isSingleColor, isRoad, isGradient, (int)zIndex, isARGBColor, rgbaColorSet, borderColorSet, borderWidth, pattern, alpha, level, visible);
    }

    public void nativeSetTurnArrow(long handle, long lineHandle, List<GeoPoint> points, int pointIndex, int actionLength) {
        if (points != null) {
            GeoPoint[] geoPoints = points.toArray(new GeoPoint[0]);
            this.mJNIInterface.nativeSetTurnArrow(handle, lineHandle, geoPoints, pointIndex, actionLength);
        }
    }

    public void nativeSetTurnArrowStyle(long handle, long lineHandle, int fillColor, int borderColor) {
        this.mJNIInterface.nativeSetTurnArrowStyle(handle, lineHandle, fillColor, borderColor);
    }

    public void nativeSetLineDirectionArrowTextureName(long handle, long lineHandle, String textureName) {
        this.mJNIInterface.nativeSetLineDirectionArrowTextureName(handle, lineHandle, textureName);
    }

    public void nativeLineInsertPoint(long handle, long lineHandle, GeoPoint point, int pointIndex) {
        this.mJNIInterface.nativeLineInsertPoint(handle, lineHandle, point, pointIndex);
    }

    public void nativeLineClearPoint(long handle, long lineHandle, GeoPoint poitn, int pointIndex) {
        this.mJNIInterface.nativeLineClearPoint(handle, lineHandle, poitn, pointIndex);
    }

    public void nativeSetLineDrawArrow(long handle, long lineHandle, boolean draw) {
        this.mJNIInterface.nativeSetLineDrawArrow(handle, lineHandle, draw);
    }

    public void nativeSetLineSelected(long handle, long lineHandle, boolean selected) {
        this.mJNIInterface.nativeSetLineSelected(handle, lineHandle, selected);
    }

    public void nativeDeleteLine(long handle, long lineHandle, boolean isRoad) {
        this.mJNIInterface.nativeDeleteLine(handle, lineHandle, isRoad);
    }

    public boolean nativeOnTapLine(long lineHandle, float winx, float winy) {
        return this.mJNIInterface.nativeOnTapLine(lineHandle, winx, winy);
    }

    public void nativeSetDrawCap(long handle, long lineHandle, boolean drawCap) {
        this.mJNIInterface.nativeSetDrawCap(handle, lineHandle, drawCap);
    }

    public void nativeSetLocationInfo(long handle, double lat, double lon, float course, float accuracy, boolean animation) {
        this.mJNIInterface.nativeSetLocationInfo(handle, lat, lon, course, accuracy, animation);
    }

    public void nativeSetLocationFollow(long handle, boolean bFollow, boolean bHeadingNorth, boolean bWalkNavigation, boolean bNavigating) {
        this.mJNIInterface.nativeSetLocationFollow(handle, bFollow, bHeadingNorth, bWalkNavigation, bNavigating);
    }

    public void nativeSetLocationHeading(long handle, float angle) {
        this.mJNIInterface.nativeSetLocationHeading(handle, angle);
    }

    public int nativeAddMarker(long handle, String name, double posX, double posY, float anchorX, float anchorY, float scaleX, float scaleY, float alpha, float angle, boolean flat, boolean fixPos, boolean fastLoad, boolean isAvoidAnno, boolean isAvoidMarker, int zIndex, int level) {
        return this.mJNIInterface.nativeAddMarker(handle, name, posX, posY, anchorX, anchorY, scaleX, scaleY, alpha, angle, flat, fixPos, fastLoad, isAvoidAnno, isAvoidMarker, zIndex, level);
    }

    public void nativeUpdateMarkerInfo(long handle, int markerId, String name, double posX, double posY, float anchorX, float anchorY, float scaleX, float scaleY, float alpha, float angle, boolean flat, boolean fixPos, boolean fastLoad, boolean isAvoidAnno, boolean isAvoidMarker, int zIndex, int level) {
        this.mJNIInterface.nativeUpdateMarkerInfo(handle, markerId, name, posX, posY, anchorX, anchorY, scaleX, scaleY, alpha, angle, flat, fixPos, fastLoad, isAvoidAnno, isAvoidMarker, zIndex, level);
    }

    public void nativeDeleteIcons(long handle, int[] iconIds, int size) {
        this.mJNIInterface.nativeDeleteIcons(handle, iconIds, size);
    }

    public void nativeHideIcons(long handle, int[] iconIds, int size) {
        this.mJNIInterface.nativeHideIcons(handle, iconIds, size);
    }

    public void nativeSetIconsHidden(long handle, int[] iconIds, int size, boolean hide) {
        this.mJNIInterface.nativeSetIconsHidden(handle, iconIds, size, hide);
    }

    public void nativeSetCompassVisible(long handle, boolean visible) {
        this.mJNIInterface.nativeSetCompassVisible(handle, visible);
    }

    public void nativeSetCompassPosition(long handle, int x2, int y2) {
        this.mJNIInterface.nativeSetCompassPosition(handle, x2, y2);
    }

    public void nativeSetCompassImage(long handle, String name) {
        this.mJNIInterface.nativeSetCompassImage(handle, name);
    }

    public double nativeGetTargetScale(long handle, Rect geoRect, Rect devRec) {
        return this.mJNIInterface.nativeGetTargetScale(handle, geoRect, devRec);
    }

    public void nativeZoomToSpan(long handle, Rect geoRect, Rect devRec, boolean anim) {
        this.mJNIInterface.nativeZoomToSpan(handle, geoRect, devRec, anim);
    }

    public void nativeIndoorBuildingEnabled(long handle, boolean isEnable) {
        this.mJNIInterface.nativeIndoorBuildingEnabled(handle, isEnable);
    }

    public void nativeSetIndoorBuildingStyle(long handle, int indoorStyle) {
        kp.b("TDZ", "nativeSetIndoorBuildingStyle:".concat(String.valueOf(indoorStyle)));
        this.mJNIInterface.nativeSetIndoorBuildingStyle(handle, indoorStyle);
    }

    public void nativeSetIndoorFloor(long handle, int floorId) {
        this.mJNIInterface.nativeSetIndoorFloor(handle, floorId);
    }

    public String[] nativeGetIndoorFloorNames(long handle) {
        return this.mJNIInterface.nativeGetIndoorFloorNames(handle);
    }

    public String nativeGetActiveIndoorBuildingGUID(long handle) {
        return this.mJNIInterface.nativeGetActiveIndoorBuildingGUID(handle);
    }

    public String nativeGetCurIndoorName(long handle, GeoPoint outPosition) {
        return this.mJNIInterface.nativeGetCurIndoorName(handle, outPosition);
    }

    public int nativeGetIndoorCurrentFloorId(long handle) {
        return this.mJNIInterface.nativeGetIndoorCurrentFloorId(handle);
    }

    public Rect nativeGetIndoorBound(long handle) {
        return this.mJNIInterface.nativeGetIndoorBound(handle);
    }

    public void nativeSetIndoorMaskColor(long handle, int rgbaColor) {
        this.mJNIInterface.nativeSetIndoorMaskColor(handle, rgbaColor);
    }

    public void nativeSetIndoorActiveScreenArea(long handle, float x2, float y2, float width, float height) {
        this.mJNIInterface.nativeSetIndoorActiveScreenArea(handle, x2, y2, width, height);
    }

    public void nativeSetIndoorBuildingPickEnabled(long handle, boolean isEnable) {
        this.mJNIInterface.nativeSetIndoorBuildingPickEnabled(handle, isEnable);
    }

    public void nativeSetShowIndoorBuildingWhiteList(long handle, String[] buildingIdList) {
        this.mJNIInterface.nativeSetShowIndoorBuildingWhiteList(handle, buildingIdList);
    }

    public int nativeSetLocationMarkerImage(long handle, String imageName, float anchorU, float anchorV) {
        return this.mJNIInterface.nativeSetLocationMarkerImage(handle, imageName, anchorU, anchorV);
    }

    public void nativeSetLocationCircleColor(long handle, int rgbaColor) {
        this.mJNIInterface.nativeSetLocationCircleColor(handle, rgbaColor);
    }

    public void nativeSetLocationCircleHidden(long handle, boolean hidden) {
        this.mJNIInterface.nativeSetLocationCircleHidden(handle, hidden);
    }

    public void nativeSetLocationMarkerHidden(long handle, boolean hide) {
        this.mJNIInterface.nativeSetLocationMarkerHidden(handle, hide);
    }

    public void nativeSetLocationCompassMarkerImage(long handle, String imageName) {
        this.mJNIInterface.nativeSetLocationCompassMarkerImage(handle, imageName);
    }

    public void nativeSetLocationCompassGroupImages(long handle, String ringName, String eastImageName, String southImageName, String westImageName, String northImageName) {
        this.mJNIInterface.nativeSetLocationCompassGroupImages(handle, ringName, eastImageName, southImageName, westImageName, northImageName);
    }

    public void nativeSetLocationCompassMarkerHidden(long handle, boolean hide) {
        this.mJNIInterface.nativeSetLocationCompassMarkerHidden(handle, hide);
    }

    public void nativeSetLocationRedLineHidden(long handle, boolean hide) {
        this.mJNIInterface.nativeSetLocationRedLineHidden(handle, hide);
    }

    public void nativeSetLocationRedLineInfo(long handle, float width, int color, LatLng destination) {
        this.mJNIInterface.nativeSetLocationRedLineInfo(handle, width, color, destination);
    }

    public void nativeMoveBy(long handle, float dx2, float dy2, boolean animated) {
        this.mJNIInterface.nativeMoveBy(handle, dx2, dy2, animated);
    }

    public void nativeSetCenter(long handle, GeoPoint mapPoint, boolean animated) {
        this.mJNIInterface.nativeSetCenter(handle, mapPoint, animated);
    }

    public void nativeSetCenterMapPointAndScaleLevel(long handle, GeoPoint mapPoint, int scaleLevel, boolean animated) {
        this.mJNIInterface.nativeSetCenterMapPointAndScaleLevel(handle, mapPoint, scaleLevel, animated);
    }

    public void nativeGetCenterMapPoint(long handle, GeoPoint outPosition) {
        this.mJNIInterface.nativeGetCenterMapPoint(handle, outPosition);
    }

    public void nativeSetScale(long handle, double scale, boolean animated) {
        this.mJNIInterface.nativeSetScale(handle, scale, animated);
    }

    public double nativeGetScale(long handle) {
        return this.mJNIInterface.nativeGetScale(handle);
    }

    public void nativeSetScaleLevel(long handle, int scaleLevel, boolean animated) {
        this.mJNIInterface.nativeSetScaleLevel(handle, scaleLevel, animated);
    }

    public int nativeGetScaleLevel(long handle) {
        return this.mJNIInterface.nativeGetScaleLevel(handle);
    }

    public void nativeSetMarkerScaleLevelRange(long handle, int markerId, int minScaleLevel, int maxScaleLevel) {
        this.mJNIInterface.nativeSetMarkerScaleLevelRange(handle, markerId, minScaleLevel, maxScaleLevel);
    }

    public void nativeZoomIn(long handle, float x2, float y2) {
        this.mJNIInterface.nativeZoomIn(handle, x2, y2);
    }

    public void nativeZoomOut(long handle) {
        this.mJNIInterface.nativeZoomOut(handle);
    }

    public void nativeSetFlagOfZoomToSpanForLocation(long handle, float topPadding, float leftPadding, float bottomPadding, float rightPadding) {
        this.mJNIInterface.nativeSetFlagOfZoomToSpanForLocation(handle, topPadding, leftPadding, bottomPadding, rightPadding);
    }

    public void nativeZoomToSpanForNavigation(long handle, GeoPoint targetPoint, int minScaleLevel, int maxScaleLevel, boolean animated) {
        this.mJNIInterface.nativeZoomToSpanForNavigation(handle, targetPoint, minScaleLevel, maxScaleLevel, animated);
    }

    public void nativeSetScreenCenterOffset(long handle, float xOffset, float yOffse, boolean withAnim) {
        this.mJNIInterface.nativeSetScreenCenterOffset(handle, xOffset, yOffse, withAnim);
    }

    public void nativeSetMaxScaleLevel(long handle, int maxScaleLevel) {
        this.mJNIInterface.nativeSetMaxScaleLevel(handle, maxScaleLevel);
    }

    public void nativeSetMinScaleLevel(long handle, int minScaleLevel) {
        this.mJNIInterface.nativeSetMinScaleLevel(handle, minScaleLevel);
    }

    public void nativeSetRotate(long handle, float rotate, boolean animated) {
        this.mJNIInterface.nativeSetRotate(handle, rotate, animated);
    }

    public void nativeSetSkew(long handle, float skew, boolean animated) {
        this.mJNIInterface.nativeSetSkew(handle, skew, animated);
    }

    public void nativeSetMapStyle(long handle, int styleId, boolean reuseOnSwitch) {
        this.mJNIInterface.nativeSetMapStyle(handle, styleId, reuseOnSwitch);
    }

    public float nativeGetSkew(long handle) {
        return this.mJNIInterface.nativeGetSkew(handle);
    }

    public float nativeGetRotate(long handle) {
        return this.mJNIInterface.nativeGetRotate(handle);
    }

    public float nativeMapSightGetOnScreenHeight(long handle) {
        return this.mJNIInterface.nativeMapSightGetOnScreenHeight(handle);
    }

    public int nativeGetMapStyle(long handle) {
        return this.mJNIInterface.nativeGetMapStyle(handle);
    }

    public int nativeAddTileOverlay(long handle, TileOverlayCallback callback, boolean betterQuality, boolean reuse) {
        return this.mJNIInterface.nativeAddTileOverlay(handle, callback, betterQuality, reuse);
    }

    public void nativeSetTileOverlayPriority(long handle, int tileOverlayId, int priority) {
        this.mJNIInterface.nativeSetTileOverlayPriority(handle, tileOverlayId, priority);
    }

    public void nativeRemoveTileOverlay(long handle, int tileOverlayId) {
        this.mJNIInterface.nativeRemoveTileOverlay(handle, tileOverlayId);
    }

    public void nativeReloadTileOverlay(long handle, int tileOverlayId) {
        this.mJNIInterface.nativeReloadTileOverlay(handle, tileOverlayId);
    }

    public boolean nativeIsTileOverlayEnabled(long handle) {
        return this.mJNIInterface.nativeIsTileOverlayEnabled(handle);
    }

    public void nativeSetTileOverlayEnabled(long handle, boolean enable) {
        this.mJNIInterface.nativeSetTileOverlayEnabled(handle, enable);
    }

    public void nativeSetTileOverlayDataLevelRange(long handle, int tileOverlayId, int minDataLevel, int maxDataLevel) {
        this.mJNIInterface.nativeSetTileOverlayDataLevelRange(handle, tileOverlayId, minDataLevel, maxDataLevel);
    }

    public void nativeBringElementAbove(long handle, int srcElementID, int dstElementID) {
        this.mJNIInterface.nativeBringElementAbove(handle, srcElementID, dstElementID);
    }

    public void nativeBringElementBelow(long handle, int srcElementID, int dstElementID) {
        this.mJNIInterface.nativeBringElementBelow(handle, srcElementID, dstElementID);
    }

    public AnnocationTextResult nativeCreateAnnotationTextBitmap(long handle, AnnocationText annocationText) {
        return this.mJNIInterface.nativeCreateAnnotationText(handle, annocationText);
    }

    public void nativeAddRouteNameSegments(long handle, byte[][] sectionWithNameBytes, int sectionSize, GeoPoint[] points, int pointSize) {
        this.mJNIInterface.nativeAddRouteNameSegments(handle, sectionWithNameBytes, sectionSize, points, pointSize);
    }

    public void nativeClearRouteNameSegments(long handle) {
        this.mJNIInterface.nativeClearRouteNameSegments(handle);
    }

    public void nativeSetLanguage(long handle, int language) {
        this.mJNIInterface.nativeSetLanguage(handle, language);
    }

    public int nativeGetLanguage(long handle) {
        return this.mJNIInterface.nativeGetLanguage(handle);
    }

    public int nativeQueryCityCodeList(long handle, Rect geoRect, int scaleLevel, int[] citycodeList, int count) {
        return this.mJNIInterface.nativeQueryCityCodeList(handle, geoRect, scaleLevel, citycodeList, count);
    }

    public void nativeLoadBlockRouteCityList(long handle, int[] citycodeList, int[] versionList, int count) {
        this.mJNIInterface.nativeLoadBlockRouteCityList(handle, citycodeList, versionList, count);
    }

    public void nativeMapLoadKMLFile(long handle, String filePath) {
        this.mJNIInterface.nativeMapLoadKMLFile(handle, filePath);
    }

    public void nativeSetBlockRouteVisible(long handle, boolean hide) {
        this.mJNIInterface.nativeSetBlockRouteVisible(handle, hide);
    }

    public String nativeGetBlockRouteInfo(long handle, int citycode, int routeId) {
        return this.mJNIInterface.nativeGetBlockRouteInfo(handle, citycode, routeId);
    }

    public void nativeResumeRenderMsgQueue(long handle) {
        this.mJNIInterface.nativeMapResumeRenderMsgQueue(handle);
    }

    public void nativeSwitchEngineForeGround(long handle, boolean foreground) {
        this.mJNIInterface.nativeSwitchEngineForeGround(handle, foreground);
    }

    public void nativeSetLineArrowSpacing(long handle, int lineId, float spacing) {
        this.mJNIInterface.nativeSetLineArrowSpacing(handle, lineId, spacing);
    }

    public void nativeSetLineFootPrintSpacing(long handle, int lineId, float spacing) {
        this.mJNIInterface.nativeSetLineFootPrintSpacing(handle, lineId, spacing);
    }

    public void nativeSetServerHost(long handle, String host) {
        this.mJNIInterface.nativeSetServerHost(handle, host);
    }

    public void nativeMapSetSatelliteServerFullUrl(long handle, String fullURL) {
        this.mJNIInterface.nativeMapSetSatelliteServerFullUrl(handle, fullURL);
    }

    public void nativeEnablePOI(long handle, boolean isEnable) {
        this.mJNIInterface.nativeEnablePOI(handle, isEnable);
    }

    public void nativeEnableBaseMap(long handle, boolean enabled) {
        this.mJNIInterface.nativeEnableBaseMap(handle, enabled);
    }

    public void nativeEnableBuilding(long handle, boolean enabled) {
        this.mJNIInterface.nativeEnableBuilding(handle, enabled);
    }

    public String nativeGetMapEngineVersion(long handle) {
        return this.mJNIInterface.nativeGetDataEngineVersion(handle);
    }

    public String nativeGetDataEngineVersion(long handle) {
        return this.mJNIInterface.nativeGetDataEngineVersion(handle);
    }

    public void nativeSetBuildingToSpecificFloor(long handle, String buildingId, String floorName) {
        this.mJNIInterface.nativeSetBuildingToSpecificFloor(handle, buildingId, floorName);
    }

    public ArrayList nativeGetPoisInScreen(long handle) {
        return this.mJNIInterface.nativeGetPoisInScreen(handle);
    }

    public String nativeGetEngineLogInfo(long handle) {
        return this.mJNIInterface.nativeGetEngineLogInfo(handle);
    }

    public long nativeAddMarker2(long handle, MarkerInfo markerInfo) {
        return this.mJNIInterface.nativeAddMarker2(handle, markerInfo);
    }

    public int nativeGetEngineId(long engineOverlayHandle) {
        return this.mJNIInterface.nativeGetEngineId(engineOverlayHandle);
    }

    public void nativeUpdateMarker(long markerId, MarkerInfo markerInfo) {
        this.mJNIInterface.nativeUpdateMarker(markerId, markerInfo);
    }

    public void nativeRemoveEngineOverlay(long engineOverlayHandle) {
        this.mJNIInterface.nativeRemoveEngineOverlay(engineOverlayHandle);
    }

    public long nativeAddAggregatioinOverlay(long handle, AggregationOverlayInfo info) {
        return this.mJNIInterface.nativeAddAggregationOverlay(handle, info);
    }

    public void nativeUpdateAggregatioinOverlay(long handle, long overlayHandle, AggregationOverlayInfo info) {
        this.mJNIInterface.nativeUpdateAggregationOverlay(handle, overlayHandle, info);
    }

    public long nativeAddHeatmapOverlay(long handle, HeatmapInfo info) {
        return this.mJNIInterface.nativeAddHeatmapOverlay(handle, info);
    }

    public void nativeUpdateHeatmapOverlay(long handle, long overlayHandle, HeatmapInfo info) {
        this.mJNIInterface.nativeUpdateHeatmapOverlay(handle, overlayHandle, info);
    }

    public long nativeAddArcLineOverlay(long handle, ArcLineOverlayInfo info) {
        return this.mJNIInterface.nativeAddArcLineOverlay(handle, info);
    }

    public void nativeUpdateArcLineOverlay(long handle, long overlayHandle, ArcLineOverlayInfo info) {
        this.mJNIInterface.nativeUpdateArcLineOverlay(handle, overlayHandle, info);
    }

    public boolean nativeGetAndResetDirty(long handle) {
        return this.mJNIInterface.nativeGetAndResetDirty(handle);
    }

    public long nativeAddScatterOverlay(long handle, ScatterPlotInfo info) {
        return this.mJNIInterface.nativeAddScatterPlotOverlay(handle, info);
    }

    public void nativeUpdateScatterPlotOverlay(long handle, long overlayHandle, ScatterPlotInfo info) {
        this.mJNIInterface.nativeUpdateScatterPlotOverlay(handle, overlayHandle, info);
    }

    public long nativeAddTrailOverlay(long handle, TrailOverlayInfo info) {
        return this.mJNIInterface.nativeAddTrailOverlay(handle, info);
    }

    public void nativeUpdateTrailOverlay(long handle, long overlayHandle, TrailOverlayInfo info) {
        this.mJNIInterface.nativeUpdateTrailOverlay(handle, overlayHandle, info);
    }

    public long nativeAddGroundOverlay(long handle, GroundOverlayInfo info) {
        return this.mJNIInterface.nativeAddGroundOverlay(handle, info);
    }

    public void nativeUpdateGroundOverlay(long handle, long overlayHandle, GroundOverlayInfo info) {
        this.mJNIInterface.nativeUpdateGroundOverlay(handle, overlayHandle, info);
    }

    public long nativeAddGLModel(long handle, GLModelInfo info) {
        return this.mJNIInterface.nativeAddGLModel(handle, info);
    }

    public void nativeUpdateGLModel(long engineHandle, long overlayHandle, GLModelInfo info) {
        this.mJNIInterface.nativeUpdateGLModel(engineHandle, overlayHandle, info);
    }

    public void nativeStartGLModelSkeletonAnimation(long engineHandle, long overlayHandle, int index, float speed, boolean autoRepeat) {
        this.mJNIInterface.nativeStartGLModelSkeletonAnimation(engineHandle, overlayHandle, index, speed, autoRepeat);
    }

    public void nativeStopGLModelSkeletonAnimation(long engineHandle, long overlayHandle) {
        this.mJNIInterface.nativeStopGLModelSkeletonAnimation(engineHandle, overlayHandle);
    }

    public int nativeGetGLModelSkeletonAnimationCount(long engineHandle, long overlayHandle) {
        return this.mJNIInterface.nativeGetGLModelSkeletonAnimationCount(engineHandle, overlayHandle);
    }

    public float[] nativeGetGLModelSkeletonAnimationDuration(long engineHandle, long overlayHandle) {
        return this.mJNIInterface.nativeGetGLModelSkeletonAnimationDuration(engineHandle, overlayHandle);
    }

    public String[] nativeGetGLModelSkeletonAnimationName(long engineHandle, long overlayHandle) {
        return this.mJNIInterface.nativeGetGLModelSkeletonAnimationName(engineHandle, overlayHandle);
    }

    public String[] nativeGetVariantNames(long engineHandle, long overlayHandle) {
        return this.mJNIInterface.nativeGetVariantNames(engineHandle, overlayHandle);
    }

    public int nativeGetCurrentMaterialVariant(long engineHandle, long overlayHandle) {
        return this.mJNIInterface.nativeGetCurrentMaterialVariant(engineHandle, overlayHandle);
    }

    public void nativeSetMaterialVariant(long engineHandle, long overlayHandle, int variantIndex) {
        this.mJNIInterface.nativeSetMaterialVariant(engineHandle, overlayHandle, variantIndex);
    }

    public void nativeSetMonoColor(long engineHandle, long overlayHandle, float r2, float g2, float b2) {
        this.mJNIInterface.nativeSetMonoColor(engineHandle, overlayHandle, r2, g2, b2);
    }

    public void nativeResetMonoColor(long engineHandle, long overlayHandle) {
        this.mJNIInterface.nativeResetMonoColor(engineHandle, overlayHandle);
    }

    public void nativeSetAmbientLight(long engineHandle, LightColor color, float intensity) {
        this.mJNIInterface.nativeSetAmbientLight(engineHandle, color.getR(), color.getG(), color.getB(), intensity);
    }

    public void nativeSetSpotOrDirectionalLight(long engineHandle, LightType type, LightColor lightColor, LightDirection lightDirection, float intensity) {
        this.mJNIInterface.nativeSetSpotOrDirectionalLight(engineHandle, type.ordinal(), lightColor.getR(), lightColor.getG(), lightColor.getB(), lightDirection.getX(), lightDirection.getY(), lightDirection.getZ(), intensity);
    }

    public void nativeRemoveGLVisualizationOverlay(long handle, long overlayHandle) {
        this.mJNIInterface.nativeRemoveGLVisualizationOverlay(handle, overlayHandle);
    }

    public VectorHeatAggregationUnit getAggregationUnit(long handle, long overlayHandle, LatLng latLng) {
        return this.mJNIInterface.nativeGetAggregationUnit(handle, overlayHandle, latLng);
    }

    public long nativeAddIntersectionOverlay(long handle, IntersectionOverlayInfo info) {
        return this.mJNIInterface.nativeAddIntersectionOverlay(handle, info);
    }

    public void nativeUpdateIntersectionOverlay(long overlayHandle, IntersectionOverlayInfo info) {
        this.mJNIInterface.nativeUpdateIntersectionOverlay(overlayHandle, info);
    }

    public void setTrafficStyle(long handle, TrafficStyle trafficStyle) {
        this.mJNIInterface.nativeSetTrafficStyle(handle, trafficStyle);
    }

    public int getIndoorOutlineZoom(long handle, String buildingId) {
        return this.mJNIInterface.getIndoorOutlineZoom(handle, buildingId);
    }

    public String getMapEngineRenderStatus(long handle) {
        return this.mJNIInterface.getMapEngineRenderStatus(handle);
    }

    public boolean checkMapLoadFinishedTask(long handle, int taskType) {
        return this.mJNIInterface.checkMapLoadFinishedTask(handle, taskType);
    }

    public void setRestrictBounds(long handle, double[] restrictBounds, double[] contentRect, int fitMode) {
        this.mJNIInterface.setRestrictBounds(handle, restrictBounds, contentRect, fitMode);
    }

    public int addLineText(long handle, GeoPoint[] points, PolylineOptions.Text text) {
        return this.mJNIInterface.addLineText(handle, points, text);
    }

    public void removeLineText(long handle, int lineTextHandle) {
        this.mJNIInterface.removeLineText(handle, lineTextHandle);
    }

    public void setLineTextStyle(long handle, int lineTextHandle, PolylineOptions.Text text) {
        this.mJNIInterface.setLineTextStyle(handle, lineTextHandle, text);
    }

    public void nativeSetIndoorConfigType(long handle, int type) {
        this.mJNIInterface.nativeSetIndoorConfigType(handle, type);
    }

    public void nativeSetMarkerMainSubRelation(long handle, int mainId, int subId) {
        this.mJNIInterface.nativeSetMarkerMainSubRelation(handle, mainId, subId);
    }

    public void nativeSetMapFontSize(long handle, int fontSize) {
        this.mJNIInterface.nativeSetMapFontSize(handle, fontSize);
    }

    public void nativeSetIndoorCellInfo(long handle, List<IndoorCellInfo> indoorCellInfoList) {
        if (indoorCellInfoList != null) {
            ArrayList<IndoorCellInfo> validList = new ArrayList<IndoorCellInfo>();
            for (IndoorCellInfo info : indoorCellInfoList) {
                if (info == null || info.getStyle() == null) continue;
                validList.add(info);
            }
            this.mJNIInterface.nativeSetIndoorCellInfo(handle, validList.toArray(new IndoorCellInfo[0]));
        }
    }

    public void nativeResetIndoorCellInfo(long handle) {
        this.mJNIInterface.nativeResetIndoorCellInfo(handle);
    }

    public void scheduleClickOnNextRender(long handle, float winx, float winy) {
        this.mJNIInterface.nativeScheduleClickOnNextRender(handle, winx, winy);
    }
}

