/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.engine.jni;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Typeface;
import android.os.AsyncTask;
import android.support.annotation.Keep;
import com.tencent.map.lib.JNIInterfaceCallback;
import com.tencent.map.lib.models.MapTileID;
import com.tencent.mapsdk.engine.jni.JNIEvent;
import com.tencent.mapsdk.engine.jni.models.IconImageInfo;
import com.tencent.mapsdk.engine.jni.models.TextBitmapInfo;
import com.tencent.mapsdk.internal.bu;
import com.tencent.mapsdk.internal.hh;
import com.tencent.mapsdk.internal.ki;
import com.tencent.mapsdk.internal.kj;
import com.tencent.mapsdk.internal.kp;
import com.tencent.mapsdk.internal.kt;
import com.tencent.mapsdk.internal.lk;
import com.tencent.mapsdk.internal.mq;
import com.tencent.mapsdk.internal.oe;
import com.tencent.mapsdk.internal.oh;
import com.tencent.mapsdk.internal.oj;
import com.tencent.mapsdk.internal.ok;
import com.tencent.mapsdk.internal.oo;
import com.tencent.mapsdk.internal.op;
import com.tencent.mapsdk.internal.oq;
import com.tencent.mapsdk.internal.or;
import com.tencent.mapsdk.internal.os;
import com.tencent.mapsdk.internal.ot;
import com.tencent.mapsdk.internal.w;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

@Keep
public class JNICallback
implements JNIInterfaceCallback {
    private static final int CB_TYPE_DRAW_TEXT = 1;
    private static final int CB_TYPE_CAL_TEXT_SIZE = 2;
    private static final int CB_TYPE_DOWNLOAD = 3;
    private static final int CB_TYPE_LOAD_RES = 4;
    private static final int CB_TYPE_WRITE_FILE = 5;
    private static final int CB_TYPE_UPDATE_MAP_PARAM = 6;
    private static final int CB_TYPE_REPORT_ENGINE_CRASH_INFO = 7;
    private static final int CB_TYPE_INDOOR_BUILDING_CHANGED = 8;
    private static final int CB_TYPE_NOTIFY_SET_CENTER_AND_SCALE_ANIM_FINISHED = 9;
    private static final int CB_TYPE_CANCEL_DOWNLOAD = 10;
    private static final int CB_TYPE_DECODE_IMG = 11;
    private static final int IMG_TYPE_SAT = 1;
    private w mResources;
    private ok mDownloadCallback;
    private oj mCancelDownloadCallback;
    private os mMapLoadFinishedCallback;
    private oq mMapCameraChangeCallback;
    private ot mMapParamChangeCallback;
    private oo mIndoorBuildingChangeCallback;
    private or mMapAnimCallback;
    private op mCbkGetGLContext;
    private bu mEngineCrashInfoRecorder;
    private Hashtable<Long, Paint> mTextPaints = new Hashtable();
    private Hashtable<Long, PointF> mTextSizeBuffers = new Hashtable();
    private oe mRender;
    private oh mMapLayerClickResultCallback;
    private Bitmap textCanvas;

    public JNICallback(oe render, w res, ok downloader, oj cancelDownloader, os mapLoadFinishedCallback, oo indoorBuildingChangeCallback, or mapAnimCallback, bu engineCrashInfoRecorder, ot paramChangeCallback, oq mapCameraChangeCallback, oh mapLayerClickResultCallback) {
        this.mRender = render;
        this.mResources = res;
        this.mDownloadCallback = downloader;
        this.mCancelDownloadCallback = cancelDownloader;
        this.mMapLoadFinishedCallback = mapLoadFinishedCallback;
        this.mMapParamChangeCallback = paramChangeCallback;
        this.mIndoorBuildingChangeCallback = indoorBuildingChangeCallback;
        this.mMapCameraChangeCallback = mapCameraChangeCallback;
        this.mMapAnimCallback = mapAnimCallback;
        this.mEngineCrashInfoRecorder = engineCrashInfoRecorder;
        this.mMapLayerClickResultCallback = mapLayerClickResultCallback;
    }

    public void destory() {
        if (this.mTextPaints != null) {
            this.mTextPaints.clear();
            this.mTextPaints = null;
        }
        if (this.mTextSizeBuffers != null) {
            this.mTextSizeBuffers.clear();
            this.mTextSizeBuffers = null;
        }
        this.mResources = null;
        this.mDownloadCallback = null;
        this.mCancelDownloadCallback = null;
        this.mMapParamChangeCallback = null;
        this.mIndoorBuildingChangeCallback = null;
        this.mMapCameraChangeCallback = null;
        this.mRender = null;
    }

    public void setMapCallbackGetGLContext(op cbk) {
        this.mCbkGetGLContext = cbk;
    }

    @Override
    public Object callback(int what, int arg1, String arg2, byte[] arg3, Object arg4) {
        JNIEvent event = new JNIEvent();
        new JNIEvent().id = arg1;
        event.name = arg2;
        event.data = arg3;
        event.extra = arg4;
        return this.callback(what, event);
    }

    public Object callback(int what, JNIEvent event) {
        Object returnParam = null;
        switch (what) {
            case 1: {
                returnParam = this.drawText(event.id, event.name, event.data);
                break;
            }
            case 2: {
                returnParam = this.calTextSize(event.name, event.id);
                break;
            }
            case 3: {
                if (hh.a(event.name)) break;
                lk entry = new lk();
                new lk().a = event.id;
                if (event.extra instanceof MapTileID) {
                    MapTileID mapTileID = (MapTileID)event.extra;
                    entry.b = mapTileID.getDataSource().getValue();
                    entry.c = mapTileID.getPriority().getValue();
                }
                entry.d = event.extra;
                this.download(event.name, entry);
                break;
            }
            case 4: {
                returnParam = this.loadImage(event.id, event.data);
                if (event.data == null) break;
                new String(event.data);
                break;
            }
            case 5: {
                kp.b("TDZ", "CB_TYPE_WRITE_FILE:" + event.name);
                this.writeFile(event.name, event.data);
                break;
            }
            case 6: {
                if (this.mMapParamChangeCallback == null) break;
                this.mMapParamChangeCallback.g();
                break;
            }
            case 7: {
                if (this.mEngineCrashInfoRecorder == null) break;
                this.mEngineCrashInfoRecorder.a(event.name);
                break;
            }
            case 8: {
                if (this.mIndoorBuildingChangeCallback == null) break;
                this.mIndoorBuildingChangeCallback.c();
                break;
            }
            case 9: {
                if (this.mMapAnimCallback == null) break;
                this.mMapAnimCallback.a(event.id > 0);
                break;
            }
            case 10: {
                kt.a("CB_TYPE_CANCEL_DOWNLOAD", event);
                if (hh.a(event.name)) break;
                lk entry = new lk();
                new lk().a = event.id;
                if (event.extra instanceof MapTileID) {
                    MapTileID mapTileID = (MapTileID)event.extra;
                    entry.b = mapTileID.getDataSource().getValue();
                    entry.c = mapTileID.getPriority().getValue();
                }
                entry.d = event.extra;
                this.cancelDownload(event.name, entry);
                break;
            }
            case 11: {
                kt.a("CB_TYPE_DECODE_IMG", event);
                returnParam = this.decodeImage(event.data);
            }
        }
        return returnParam;
    }

    @Override
    public void onMapLoaded() {
        if (this.mMapLoadFinishedCallback != null) {
            this.mMapLoadFinishedCallback.m_();
        }
    }

    @Override
    public void onMapCameraChanged() {
        if (this.mMapCameraChangeCallback != null) {
            this.mMapCameraChangeCallback.h();
        }
    }

    @Override
    public void onMapCameraChangeStopped() {
        if (this.mMapCameraChangeCallback != null) {
            this.mMapCameraChangeCallback.i();
        }
    }

    @Override
    public int callbackGetGLContext() {
        if (this.mCbkGetGLContext != null) {
            return this.mCbkGetGLContext.getEGLContextHash();
        }
        return 0;
    }

    @Override
    public boolean onJniCallbackRenderMapFrame(int renderLayerType) {
        boolean renderRefreshed = false;
        if (this.mRender != null) {
            renderRefreshed = this.mRender.b(renderLayerType);
        }
        return renderRefreshed;
    }

    @Override
    public void onVisualLayerClickResult(float fx2, float fy2, long layerHandle, String objIdentifier, String objName) {
        if (this.mMapLayerClickResultCallback != null) {
            this.mMapLayerClickResultCallback.a(fx2, fy2, layerHandle, objIdentifier, objName);
        }
    }

    private Paint getTextPaint() {
        if (this.mTextPaints == null) {
            return null;
        }
        return this.mTextPaints.get(Thread.currentThread().getId());
    }

    private void cacheTextPaint(Paint paint) {
        if (this.mTextPaints != null) {
            this.mTextPaints.put(Thread.currentThread().getId(), paint);
        }
    }

    private PointF getTextSize() {
        if (this.mTextSizeBuffers == null) {
            return null;
        }
        return this.mTextSizeBuffers.get(Thread.currentThread().getId());
    }

    private void cacheTextSize(PointF point) {
        if (this.mTextSizeBuffers != null) {
            this.mTextSizeBuffers.put(Thread.currentThread().getId(), point);
        }
    }

    private Paint initTextPaint(int fontSize) {
        Paint paint = this.getTextPaint();
        if (paint == null) {
            paint = new mq(this.mResources.a);
            paint.setTypeface(Typeface.DEFAULT);
            paint.setAntiAlias(true);
            paint.setStyle(Paint.Style.FILL);
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setLinearText(true);
            this.cacheTextPaint(paint);
        }
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize((float)fontSize);
        return paint;
    }

    private Bitmap drawText(int fontSize, String text, byte[] textBitmapInfoBytes) {
        TextBitmapInfo bitmapInfo = new TextBitmapInfo();
        bitmapInfo.fill(textBitmapInfoBytes);
        if (bitmapInfo.width == 0 || bitmapInfo.height == 0) {
            return null;
        }
        if (this.textCanvas == null) {
            this.textCanvas = Bitmap.createBitmap((int)400, (int)400, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        }
        if (this.textCanvas == null) {
            return null;
        }
        Paint paint = this.initTextPaint(fontSize);
        this.textCanvas.eraseColor(0);
        Canvas canvas = new Canvas(this.textCanvas);
        float y2 = 200.0f - (paint.descent() + paint.ascent()) / 2.0f;
        paint.setFakeBoldText(bitmapInfo.bold);
        canvas.drawText(text, 200.0f, y2, paint);
        return this.textCanvas;
    }

    private PointF calTextSize(String text, int fontSize) {
        float width = this.initTextPaint(fontSize).measureText(text) + 1.0f;
        int height = fontSize + 2;
        PointF textSize = this.getTextSize();
        if (textSize == null) {
            textSize = new PointF();
            this.cacheTextSize(textSize);
        }
        textSize.x = width;
        textSize.y = height;
        return textSize;
    }

    private IconImageInfo loadImage(int type, byte[] name) {
        if (name == null || name.length == 0) {
            return null;
        }
        try {
            String fileName = new String(name);
            if (type == 1) {
                String string = fileName;
                w w2 = this.mResources;
                IconImageInfo iconImageInfo = new IconImageInfo();
                new IconImageInfo().scale = w2.c;
                iconImageInfo.anchorPointX1 = 0.5f;
                iconImageInfo.anchorPointY1 = 0.5f;
                iconImageInfo.bitmap = w2.a(string, Bitmap.Config.RGB_565);
                return iconImageInfo;
            }
            return this.mResources.a(fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private IconImageInfo decodeImage(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        IconImageInfo imageInfo = new IconImageInfo();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        try {
            BitmapFactory.Options opt = new BitmapFactory.Options();
            new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
            imageInfo.bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)opt);
            imageInfo.scale = 1.0f;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            kp.b("Engine callback decodeImg: failed to decode stream.");
        }
        finally {
            kj.a((Closeable)stream);
        }
        return imageInfo;
    }

    private void download(String uri, lk entry) {
        if (this.mDownloadCallback != null) {
            kp.a("Engine callback download:" + uri + ":" + entry);
            this.mDownloadCallback.b(uri, entry);
        }
    }

    private void cancelDownload(String uri, lk entry) {
        if (this.mCancelDownloadCallback != null) {
            kp.a("Engine callback cancel download:".concat(String.valueOf(uri)));
            this.mCancelDownloadCallback.a(uri, entry);
        }
    }

    private void writeFile(String filePath, byte[] data) {
        if (data == null) {
            return;
        }
        new a(filePath, data).execute(new Void[0]);
    }

    static final class a
    extends AsyncTask<Void, Void, Void> {
        private String a;
        private byte[] b;

        a(String filePath, byte[] data) {
            this.a = filePath;
            this.b = data;
        }

        /*
         * Unable to fully structure code
         */
        private Void a() {
            block19: {
                tmpFile = new File(this.a + ".tmp");
                isFull = false;
                fos = null;
                if (!tmpFile.exists()) {
                    ki.a(tmpFile);
                }
                fos = new FileOutputStream(tmpFile);
                fos.write(this.b);
                isFull = true;
                try {
                    fos.close();
                }
                catch (IOException v0) {
                    v0.printStackTrace();
                }
                break block19;
                catch (FileNotFoundException v1) {
                    v1.printStackTrace();
                    ** if (fos == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fos.close();
                        }
                        catch (IOException v2) {
                            v2.printStackTrace();
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (IOException v3) {
                    v3.printStackTrace();
                    ** if (fos == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fos.close();
                        }
                        catch (IOException v4) {
                            v4.printStackTrace();
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    {
                        catch (Throwable var5_4) {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException v5) {
                                    v5.printStackTrace();
                                }
                            }
                            throw var5_4;
                        }
                    }
                }
            }
            if (isFull) {
                target = new File(this.a);
                tmpFile.renameTo(target);
            }
            return null;
        }

        protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a();
        }
    }
}

