/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.engine.jni.models;

import android.support.annotation.Keep;
import com.tencent.mapsdk.internal.mj;

@Keep
public class TappedElement {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ANNO = 1;
    public static final int TYPE_COMPASS = 3;
    public static final int TYPE_OVERLAY_ITEM = 4;
    public static final int TYPE_LINE = 5;
    public static final int TYPE_LOCATION_MARKER = 6;
    public static final int TYPE_BLOCKROUTE_ANNO = 7;
    public static final int TYPE_INDOORMAP_AREA = 8;
    public static final int TYPE_ANNO_INDOOR_MAP = 1;
    private static final int BUILDING_ID_LENGTH = 128;
    private static final int BUILDING_NAME_LENGTH = 68;
    private static final int FLOOR_NAME_LENGTH = 32;
    private static final int POI_ID_LENGTH = 64;
    public int type;
    public int pixelX;
    public int pixelY;
    public int nameLen;
    public String name;
    public long itemId;
    public int itemType;
    public String buildingId;
    public String buildingName;
    public String floorName;
    public String poiId;

    private TappedElement() {
    }

    public static TappedElement fromBytes(byte[] bytes) {
        TappedElement te2 = new TappedElement();
        byte[] intData = new byte[4];
        int pos = 0;
        System.arraycopy(bytes, 0, intData, 0, 4);
        pos += 4;
        te2.type = mj.a(intData);
        System.arraycopy(bytes, 4, intData, 0, 4);
        pos += 4;
        te2.pixelX = mj.a(intData);
        System.arraycopy(bytes, 8, intData, 0, 4);
        pos += 4;
        te2.pixelY = mj.a(intData);
        System.arraycopy(bytes, 12, intData, 0, 4);
        pos += 4;
        te2.itemType = mj.a(intData);
        System.arraycopy(bytes, 16, intData, 0, 4);
        pos += 4;
        te2.nameLen = mj.a(intData);
        if (te2.type != 7) {
            byte[] strData = new byte[64];
            System.arraycopy(bytes, 20, strData, 0, 64);
            pos += 64;
            te2.name = te2.type != 8 ? mj.b(strData) : mj.a(strData, "UTF-8");
        }
        System.arraycopy(bytes, pos, intData, 0, 4);
        int upperBytes = mj.a(intData);
        System.arraycopy(bytes, pos += 4, intData, 0, 4);
        int lowerBytes = mj.a(intData);
        te2.itemId = ((long)upperBytes << 32) + (long)lowerBytes;
        byte[] longData = new byte[64];
        System.arraycopy(bytes, pos += 4, longData, 0, 64);
        te2.poiId = String.valueOf(mj.a(longData, "UTF-8"));
        pos += 64;
        if (te2.itemType == 1) {
            byte[] strData = new byte[128];
            System.arraycopy(bytes, pos, strData, 0, 128);
            te2.buildingId = mj.a(strData, "UTF-8");
            strData = new byte[68];
            System.arraycopy(bytes, pos += 128, strData, 0, 68);
            te2.buildingName = mj.b(strData);
            strData = new byte[32];
            System.arraycopy(bytes, pos += 68, strData, 0, 32);
            te2.floorName = mj.a(strData, "UTF-8");
        }
        return te2;
    }
}

