/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.graphics.Bitmap;
import android.view.View;
import com.tencent.tencentmap.mapsdk.maps.TencentMapContext;
import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class BitmapDescriptorFactory {
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;
    private static final List<TencentMapContext> sTencentMapContextList = new CopyOnWriteArrayList<TencentMapContext>();
    private static final AtomicInteger sAttachIndex = new AtomicInteger(0);

    private BitmapDescriptorFactory() {
    }

    public static void attachMapContext(TencentMapContext mapContext) {
        if (!sTencentMapContextList.contains(mapContext)) {
            sTencentMapContextList.add(mapContext);
            sAttachIndex.incrementAndGet();
        }
    }

    public static void detachMapContext(TencentMapContext mapContext) {
        if (sTencentMapContextList.remove(mapContext)) {
            sAttachIndex.decrementAndGet();
        }
    }

    private static TencentMapContext getActiveMapContext() {
        int index = sAttachIndex.get();
        if (index > 0 && index <= sTencentMapContextList.size()) {
            return sTencentMapContextList.get(index - 1);
        }
        return null;
    }

    public static BitmapDescriptor fromResource(int resId) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromResource(context, resId);
        }
        return null;
    }

    public static BitmapDescriptor fromAsset(String assetName) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromAsset(context, assetName);
        }
        return null;
    }

    public static BitmapDescriptor fromFile(String filename) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromFile(context, filename);
        }
        return null;
    }

    public static BitmapDescriptor fromPath(String filename) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromPath(context, filename);
        }
        return null;
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromBitmap(context, bitmap);
        }
        return null;
    }

    public static BitmapDescriptor fromView(View view) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromView(context, view);
        }
        return null;
    }

    public static BitmapDescriptor defaultMarker() {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.defaultMarker(context);
        }
        return null;
    }

    public static BitmapDescriptor defaultMarker(float color) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.defaultMarker(context, color);
        }
        return null;
    }

    public static BitmapDescriptor fromResource(TencentMapContext context, int resId) {
        return context.createBitmapDescriptor(resId, 1);
    }

    public static BitmapDescriptor fromAsset(TencentMapContext context, String assetName) {
        return context.createBitmapDescriptor(assetName, 2);
    }

    public static BitmapDescriptor fromFile(TencentMapContext context, String filename) {
        return context.createBitmapDescriptor(filename, 3);
    }

    public static BitmapDescriptor fromPath(TencentMapContext context, String filename) {
        return context.createBitmapDescriptor(filename, 4);
    }

    public static BitmapDescriptor defaultMarker(TencentMapContext context) {
        return context.createBitmapDescriptor(5);
    }

    public static BitmapDescriptor defaultMarker(TencentMapContext context, float color) {
        return context.createBitmapDescriptor(color, 6);
    }

    public static BitmapDescriptor fromBitmap(TencentMapContext context, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap mapNew = BitmapDescriptorFactory.createBitmapFromBitmap(bitmap);
        return context.createBitmapDescriptor(mapNew, 7);
    }

    private static Bitmap createBitmapFromBitmap(Bitmap map) {
        Bitmap bmp = null;
        try {
            if (map != null && !map.isRecycled()) {
                bmp = map.copy(Bitmap.Config.ARGB_8888, true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bmp;
    }

    public static synchronized BitmapDescriptor fromView(TencentMapContext context, View view) {
        if (view == null) {
            return null;
        }
        try {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            view.buildDrawingCache();
            Bitmap bitmap = view.getDrawingCache();
            BitmapDescriptor result = BitmapDescriptorFactory.fromBitmap(context, bitmap);
            view.destroyDrawingCache();
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BitmapDescriptor fromBitmaps(Bitmap ... bitmaps) {
        TencentMapContext context = BitmapDescriptorFactory.getActiveMapContext();
        if (context != null) {
            return BitmapDescriptorFactory.fromBitmaps(context, bitmaps);
        }
        return null;
    }

    public static BitmapDescriptor fromBitmaps(TencentMapContext context, Bitmap ... bitmaps) {
        if (context == null || bitmaps == null) {
            return null;
        }
        Bitmap[] mapNews = BitmapDescriptorFactory.createBitmapFromBitmaps(bitmaps);
        return context.createBitmapDescriptor(mapNews, 10);
    }

    private static Bitmap[] createBitmapFromBitmaps(Bitmap ... bitmaps) {
        Bitmap[] newBitmaps = new Bitmap[bitmaps.length];
        try {
            for (int i2 = 0; i2 < newBitmaps.length; ++i2) {
                Bitmap bitmap = bitmaps[i2];
                newBitmaps[i2] = BitmapDescriptorFactory.createBitmapFromBitmap(bitmap);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return newBitmaps;
    }
}

