/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.os.Parcel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.List;

public class CircleOptions {
    private LatLng latlngCenter = new LatLng(39.984253, 116.307439);
    private double dRadius = 1.0;
    private float fStrokeWidth = 1.0f;
    private int iStrokeColor = -16777216;
    private int iFillColor = 0;
    private int iZindex;
    private boolean boVisible;
    private boolean mClickable;
    private List<Integer> pattern;
    private CircleBorderType borderType;
    private int iLevel = 2;

    public List<Integer> getPattern() {
        return this.pattern;
    }

    public CircleOptions pattern(List<Integer> pattern) {
        if (pattern != null && pattern.size() == 2) {
            this.pattern = pattern;
        }
        return this;
    }

    public CircleBorderType getBorderType() {
        return this.borderType;
    }

    public CircleOptions borderType(CircleBorderType borderType) {
        this.borderType = borderType;
        return this;
    }

    public CircleOptions() {
        this.iZindex = 0;
        this.boVisible = true;
        this.borderType = CircleBorderType.REALLINE_DEFAULT;
    }

    CircleOptions(int i2, LatLng latlng, double d2, float f2, int k2, int l2, int f1, boolean flag) {
        this.boVisible = true;
        this.latlngCenter = latlng;
        this.dRadius = d2;
        this.fStrokeWidth = f2;
        this.iStrokeColor = k2;
        this.iFillColor = l2;
        this.iZindex = f1;
        this.boVisible = flag;
    }

    public CircleOptions center(LatLng latlng) {
        this.latlngCenter = latlng;
        return this;
    }

    public CircleOptions radius(double radius) {
        this.dRadius = radius;
        return this;
    }

    public CircleOptions strokeWidth(float width) {
        this.fStrokeWidth = width < 0.0f ? 1.0f : width;
        return this;
    }

    public CircleOptions strokeColor(int color) {
        this.iStrokeColor = color;
        return this;
    }

    public CircleOptions fillColor(int color) {
        this.iFillColor = color;
        return this;
    }

    public CircleOptions zIndex(int zIndex) {
        this.iZindex = zIndex;
        return this;
    }

    public CircleOptions visible(boolean flag) {
        this.boVisible = flag;
        return this;
    }

    public LatLng getCenter() {
        return this.latlngCenter;
    }

    public double getRadius() {
        return this.dRadius;
    }

    public float getStrokeWidth() {
        return this.fStrokeWidth;
    }

    public int getStrokeColor() {
        return this.iStrokeColor;
    }

    public int getFillColor() {
        return this.iFillColor;
    }

    public int getZIndex() {
        return this.iZindex;
    }

    public boolean isVisible() {
        return this.boVisible;
    }

    public CircleOptions clickable(boolean clickable) {
        this.mClickable = clickable;
        return this;
    }

    public boolean isClickable() {
        return this.mClickable;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            return;
        }
        out.writeDouble(this.dRadius);
    }

    public CircleOptions level(int level) {
        if (level < 0 || level > 2) {
            return this;
        }
        this.iLevel = level;
        return this;
    }

    public int getLevel() {
        return this.iLevel;
    }

    public static enum CircleBorderType {
        REALLINE_DEFAULT,
        DOTTEDLINE_SQUARE,
        DOTTEDLINE_CIRCLE;

    }
}

