/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.map.tools.json.JsonParser;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class LatLngDeserializer
implements JsonParser.Deserializer<LatLng> {
    @Override
    public LatLng deserialize(Object model, String key, Object json) throws JSONException {
        if (json == null) {
            return null;
        }
        if (json instanceof JSONObject) {
            JSONObject object = (JSONObject)json;
            double lat = object.optDouble("lat");
            double lng = object.optDouble("lng");
            return new LatLng(lat, lng);
        }
        if (json instanceof JSONArray) {
            JSONArray array = (JSONArray)json;
            if (array.length() < 2) {
                return null;
            }
            if (array.length() > 2) {
                return new LatLng(array.getDouble(0), array.getDouble(1), array.getDouble(2));
            }
            return new LatLng(array.getDouble(0), array.getDouble(1));
        }
        if (json instanceof JSONStringer || json instanceof String) {
            String[] latlng = json.toString().split(",");
            if (latlng.length < 2) {
                return null;
            }
            if (latlng.length > 2) {
                return new LatLng(Double.parseDouble(latlng[0]), Double.parseDouble(latlng[1]), Double.parseDouble(latlng[2]));
            }
            return new LatLng(Double.parseDouble(latlng[0]), Double.parseDouble(latlng[1]));
        }
        return null;
    }
}

