/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.graphics.Color;
import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptor;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PolygonOptions {
    private static final int COLOR_DEFAULT_POLYGON = Color.argb((int)200, (int)0, (int)163, (int)255);
    private final List<LatLng> listPts;
    private int iFillColor = COLOR_DEFAULT_POLYGON;
    private int iZindex = 0;
    private boolean boIsVisble = true;
    private boolean mClickable = true;
    private final List<List<LatLng>> holePts;
    private float fStrokeWidth = 1.0f;
    private int iStrokeColor = -16777216;
    private List<Integer> pattern;
    private BitmapDescriptor texture;
    private int textureSpacing;
    private int iLevel = 2;

    public PolygonOptions() {
        this.listPts = new ArrayList<LatLng>();
        this.holePts = new ArrayList<List<LatLng>>();
    }

    public void setPoints(Iterable<LatLng> points) {
        this.listPts.clear();
        if (points == null) {
            return;
        }
        this.addAll(points);
    }

    public PolygonOptions add(LatLng latLng) {
        if (latLng != null) {
            this.listPts.add(latLng);
        }
        return this;
    }

    public PolygonOptions add(LatLng ... latLngs) {
        if (latLngs != null) {
            this.listPts.addAll(Arrays.asList(latLngs));
        }
        return this;
    }

    public PolygonOptions add(List<LatLng> points) {
        if (points != null) {
            this.listPts.addAll(points);
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> latLngs) {
        if (latLngs != null) {
            for (LatLng latlng : latLngs) {
                this.listPts.add(latlng);
            }
        }
        return this;
    }

    public PolygonOptions setHolePoints(List<List<LatLng>> holePoints) {
        this.holePts.clear();
        if (holePoints == null) {
            return this;
        }
        this.holePts.addAll(holePoints);
        return this;
    }

    public List<List<LatLng>> getHolePoints() {
        return this.holePts;
    }

    public PolygonOptions strokeWidth(float strokeWidth) {
        this.fStrokeWidth = strokeWidth < 0.0f ? 1.0f : strokeWidth;
        return this;
    }

    public PolygonOptions strokeColor(int strokeColor) {
        this.iStrokeColor = strokeColor;
        this.texture = null;
        return this;
    }

    public PolygonOptions fillColor(int fillColor) {
        this.iFillColor = fillColor;
        return this;
    }

    public PolygonOptions zIndex(int zIndex) {
        this.iZindex = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean flag) {
        this.boIsVisble = flag;
        return this;
    }

    public PolygonOptions clickable(boolean clickable) {
        this.mClickable = clickable;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.listPts;
    }

    public float getStrokeWidth() {
        return this.fStrokeWidth;
    }

    public int getStrokeColor() {
        return this.iStrokeColor;
    }

    public int getFillColor() {
        return this.iFillColor;
    }

    public float getZIndex() {
        return this.iZindex;
    }

    public boolean isVisible() {
        return this.boIsVisble;
    }

    public boolean isClickable() {
        return this.mClickable;
    }

    public PolygonOptions level(int level) {
        if (level < 0 || level > 2) {
            return this;
        }
        this.iLevel = level;
        return this;
    }

    public int getLevel() {
        return this.iLevel;
    }

    public boolean isValid() {
        return this.listPts != null && this.listPts.size() > 2;
    }

    public List<Integer> getPattern() {
        return this.pattern;
    }

    public PolygonOptions pattern(List<Integer> pattern) {
        this.pattern = pattern;
        this.texture = null;
        return this;
    }

    public BitmapDescriptor getTexture() {
        return this.texture;
    }

    public PolygonOptions texture(BitmapDescriptor texture) {
        this.texture = texture;
        return this;
    }

    public int getTextureSpacing() {
        return this.textureSpacing;
    }

    public PolygonOptions textureSpacing(int textureSpacing) {
        this.textureSpacing = textureSpacing;
        return this;
    }
}

