/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model.transform;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;

public abstract class OverlayAnimator {
    private Object mObject;
    private long mDuration;
    private AnimatorSet mAnimatorSet;
    private Animator.AnimatorListener mAnimatorListener;

    protected OverlayAnimator(Object object, long duration) {
        this.mObject = object;
        this.mDuration = duration;
        this.mAnimatorSet = new AnimatorSet();
    }

    protected void innerAnimationEnd() {
    }

    protected void addAnimationListener() {
        if (this.mAnimatorSet == null) {
            return;
        }
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new Animator.AnimatorListener(){

                public final void onAnimationStart(Animator animation) {
                }

                public final void onAnimationEnd(Animator animation) {
                    OverlayAnimator.this.innerAnimationEnd();
                }

                public final void onAnimationCancel(Animator animation) {
                }

                public final void onAnimationRepeat(Animator animation) {
                }
            };
        }
        this.mAnimatorSet.addListener(this.mAnimatorListener);
    }

    protected void removeAnimationListener() {
        if (this.mAnimatorSet == null) {
            return;
        }
        this.mAnimatorSet.removeListener(this.mAnimatorListener);
        this.mAnimatorListener = null;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public Object getObject() {
        return this.mObject;
    }

    public void setObject(Object object) {
        this.mObject = object;
    }

    protected AnimatorSet getAnimatorSet() {
        return this.mAnimatorSet;
    }

    protected void setAnimatorSet(AnimatorSet animatorSet) {
        this.mAnimatorSet = animatorSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation() {
        OverlayAnimator overlayAnimator = this;
        synchronized (overlayAnimator) {
            if (!this.mAnimatorSet.isRunning()) {
                this.mAnimatorSet.start();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAnimation() {
        OverlayAnimator overlayAnimator = this;
        synchronized (overlayAnimator) {
            this.mAnimatorSet.cancel();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAnimation() {
        OverlayAnimator overlayAnimator = this;
        synchronized (overlayAnimator) {
            this.mAnimatorSet.end();
            return;
        }
    }

    protected abstract ValueAnimator createSegmentAnimator(int var1);

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.mAnimatorSet.addListener(listener);
    }
}

