/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import com.tencent.mapsdk.internal.hh;
import com.tencent.mapsdk.internal.ki;
import java.io.File;

public class StorageManager {
    private Context mContext;
    private String mCustomCacheRootPath;
    private String mAppRootDir;
    private static final String ROOT_DIR = "/tencentmapsdk/";
    private static StorageManager mInstance;

    public static StorageManager getInstance(Context context, String customCacheRootPath) {
        if (mInstance == null) {
            mInstance = new StorageManager(context, customCacheRootPath);
        }
        return mInstance;
    }

    private StorageManager(Context context, String customCacheRootPath) {
        if (context == null) {
            throw new Error("context can not be null");
        }
        this.mContext = context.getApplicationContext();
        this.mCustomCacheRootPath = customCacheRootPath;
        this.updatePublicPath();
    }

    public static void clearMapCache(Context context, String customCacheRootPath) {
        ki.f(StorageManager.getInstance(context, customCacheRootPath).getCacheDir());
    }

    public File getCacheDir() {
        return new File(this.mAppRootDir);
    }

    private void updatePublicPath() {
        String strPath = this.getStorageRootPath();
        String packageName = ki.a(this.mContext);
        if (hh.a(packageName)) {
            this.mAppRootDir = strPath + ROOT_DIR;
            return;
        }
        this.mAppRootDir = strPath + ROOT_DIR + packageName;
    }

    private String getStorageRootPath() {
        if (!TextUtils.isEmpty((CharSequence)this.mCustomCacheRootPath)) {
            return this.mCustomCacheRootPath;
        }
        Context context = this.mContext;
        String strSdkDirectory = StorageManager.getExternalStoragePath(context);
        if (StorageManager.getAvailableStorageSize(strSdkDirectory) < 5L && StorageManager.getAvailableStorageSize(strSdkDirectory = context.getFilesDir().getPath()) < 5L) {
            strSdkDirectory = StorageManager.getExternalStoragePath(context);
        }
        return strSdkDirectory;
    }

    private static String getExternalStoragePath(Context context) {
        File externalFile = context.getExternalFilesDir(null);
        if (externalFile != null) {
            return externalFile.getAbsolutePath();
        }
        return context.getFilesDir().getPath();
    }

    @SuppressLint(value={"NewApi"})
    private static long getAvailableStorageSize(String path) {
        try {
            long availBlocks;
            long blockSize;
            StatFs stfs = new StatFs(path);
            if (Build.VERSION.SDK_INT < 18) {
                blockSize = stfs.getBlockSize();
                availBlocks = stfs.getAvailableBlocks();
            } else {
                blockSize = stfs.getBlockSizeLong();
                availBlocks = stfs.getAvailableBlocksLong();
            }
            return blockSize * availBlocks / 1024L / 1024L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

