/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.lbssearch.HttpProvider;
import com.tencent.lbssearch.httpresponse.BaseObject;
import com.tencent.lbssearch.httpresponse.HttpResponseListener;
import com.tencent.lbssearch.httpresponse.UrlConstant;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.Address2GeoParam;
import com.tencent.lbssearch.object.param.DistrictChildrenParam;
import com.tencent.lbssearch.object.param.DistrictSearchParam;
import com.tencent.lbssearch.object.param.ExploreParam;
import com.tencent.lbssearch.object.param.Geo2AddressParam;
import com.tencent.lbssearch.object.param.MatrixParam;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.lbssearch.object.param.RoutePlanningParam;
import com.tencent.lbssearch.object.param.SearchIDParam;
import com.tencent.lbssearch.object.param.SearchParam;
import com.tencent.lbssearch.object.param.StreetViewParam;
import com.tencent.lbssearch.object.param.SuggestionParam;
import com.tencent.lbssearch.object.param.TranslateParam;
import com.tencent.lbssearch.object.result.Address2GeoResultObject;
import com.tencent.lbssearch.object.result.DistanceMatrixResultObject;
import com.tencent.lbssearch.object.result.DistrictResultObject;
import com.tencent.lbssearch.object.result.ExploreResultObject;
import com.tencent.lbssearch.object.result.Geo2AddressResultObject;
import com.tencent.lbssearch.object.result.SearchDetailResultObject;
import com.tencent.lbssearch.object.result.SearchResultObject;
import com.tencent.lbssearch.object.result.StreetViewResultObject;
import com.tencent.lbssearch.object.result.SuggestionResultObject;
import com.tencent.lbssearch.object.result.TranslateResultObject;
import com.tencent.map.tools.Util;
import com.tencent.mapsdk.internal.ho;
import com.tencent.tencentmap.mapsdk.maps.TencentMapInitializer;

public class TencentSearch
implements UrlConstant {
    private final Context mContext;
    private final String mSecretKey;
    private final String mApiKey;
    private boolean mIsDebuggable = false;

    public TencentSearch(Context context) {
        this(context, null);
    }

    public TencentSearch(Context context, String secretKey) {
        this(context, null, secretKey);
    }

    public TencentSearch(Context context, String apiKey, String secretKey) {
        this.mContext = context;
        this.mApiKey = apiKey;
        this.mSecretKey = secretKey;
        ho.a(context, apiKey, context.getPackageName(), "");
    }

    public void setDebuggable(boolean debuggable) {
        this.mIsDebuggable = debuggable;
    }

    public void search(SearchParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/place/v1/search", object, SearchResultObject.class, listener);
    }

    public void explore(ExploreParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/place/v1/explore", object, ExploreResultObject.class, listener);
    }

    public void detail(SearchIDParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/place/v1/detail", object, SearchDetailResultObject.class, listener);
    }

    public void suggestion(SuggestionParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/place/v1/suggestion", object, SuggestionResultObject.class, listener);
    }

    public void geo2address(Geo2AddressParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/geocoder/v1", object, Geo2AddressResultObject.class, listener);
    }

    public void address2geo(Address2GeoParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/geocoder/v1", object, Address2GeoResultObject.class, listener);
    }

    public void getDistrictList(HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/district/v1/list", new DistrictChildrenParam(), DistrictResultObject.class, listener);
    }

    public void getDistrictChildren(DistrictChildrenParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/district/v1/getchildren", object, DistrictResultObject.class, listener);
    }

    public void getDistrictSearch(DistrictSearchParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/district/v1/search", object, DistrictResultObject.class, listener);
    }

    public void translate(TranslateParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/coord/v1/translate", object, TranslateResultObject.class, listener);
    }

    public void getpano(StreetViewParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/streetview/v1/getpano", object, StreetViewResultObject.class, listener);
    }

    public void getRoutePlan(RoutePlanningParam param, HttpResponseListener listener) {
        RoutePlanningParam routePlanningParam = param;
        this.doHttpGet(param.getUrl(), routePlanningParam, routePlanningParam.getResultClass(), listener);
    }

    public void getDistanceMatrix(MatrixParam param, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/distance/v1/matrix", param, DistanceMatrixResultObject.class, listener);
    }

    private <T extends BaseObject> void doHttpGet(String url, ParamObject object, Class<T> t2, HttpResponseListener<T> listener) {
        if (!TencentMapInitializer.getAgreePrivacy()) {
            if (listener != null) {
                listener.onFailure(-1, "\u8bf7\u786e\u4fdd\u9690\u79c1\u653f\u7b56\u5df2\u53d6\u5f97\u7528\u6237\u540c\u610f", null);
            }
            return;
        }
        if (object == null || !object.checkParams()) {
            if (this.mIsDebuggable) {
                Log.e((String)"search", (String)"wrong parameter");
            }
            if (listener != null) {
                listener.onFailure(-1, "\u53c2\u6570\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5", null);
            }
            return;
        }
        String authKey = this.mApiKey;
        if (TextUtils.isEmpty((CharSequence)authKey) && TextUtils.isEmpty((CharSequence)(authKey = Util.getMetaKey(this.mContext, "TencentMapSDK")))) {
            if (listener != null) {
                listener.onFailure(-1, "\u8bf7\u7533\u8bf7\u5e76\u586b\u5199\u5f00\u53d1\u8005\u5bc6\u94a5", null);
            }
            return;
        }
        RequestParams params = object.buildParameters();
        if (params != null) {
            params.add("key", authKey);
            params.add("output", "json");
        } else {
            params = new RequestParams();
        }
        if (!TextUtils.isEmpty((CharSequence)ho.d())) {
            params.add("__suid", ho.d());
        }
        if (!TextUtils.isEmpty((CharSequence)ho.e())) {
            params.add("__duid", ho.e());
        }
        params.add("__pf", "android");
        params.add("__chan", "search");
        params.add("__pid", Util.getRawAppName(this.mContext));
        params.add("__psv", Util.getAppVersion(this.mContext));
        params.add("__ver", "1.0.0");
        params.setDebuggable(this.mIsDebuggable);
        HttpProvider.get(this.mContext, url, params, t2, this.mSecretKey, listener);
    }
}

