/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.lbssearch.object.param.SearchParam;
import com.tencent.map.tools.Util;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class ExploreParam
implements ParamObject {
    private static final String BOUNDARY = "boundary";
    private static final String POLICY = "policy";
    private static final String FILTER = "filter";
    private static final String ORDERBY = "orderby";
    private static final String ADDRESS_FORMAT = "address_format";
    private static final String PAGE_SIZE = "page_size";
    private static final String PAGE_INDEX = "page_index";
    private static final String DISTANCE_ASCE = "_distance";
    private static final String DISTANCE_DESC = "_distance desc";
    private static final String NEARBY = "nearby";
    private static final String SHORT_ADDRESS = "short";
    private SearchParam.Boundary boundary;
    private String filter;
    private boolean distance_order = true;
    private int policy;
    private int page_size;
    private int page_index;
    private boolean address_format;

    public ExploreParam(SearchParam.Boundary boundary) {
        this.policy = Policy.DEFAULT.policyValue;
        this.page_size = -1;
        this.page_index = 1;
        this.address_format = false;
        this.boundary = boundary;
    }

    public ExploreParam boundary(SearchParam.Boundary boundary) {
        this.boundary = boundary;
        return this;
    }

    public ExploreParam policy(Policy policy) {
        this.policy = policy.policyValue;
        return this;
    }

    public ExploreParam filter(String ... values) {
        this.filter = Util.filterBuilder(values);
        return this;
    }

    public ExploreParam orderby(boolean asce) {
        this.distance_order = asce;
        return this;
    }

    public ExploreParam pageSize(int pagesize) {
        this.page_size = pagesize;
        return this;
    }

    public ExploreParam pageIndex(int page_index) {
        this.page_index = page_index;
        return this;
    }

    public ExploreParam addressFormat(boolean isShort) {
        this.address_format = isShort;
        return this;
    }

    @Override
    public boolean checkParams() {
        return this.boundary != null;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (this.boundary != null) {
            String b2 = this.boundary.toString();
            params.add(BOUNDARY, b2);
        }
        if (!TextUtils.isEmpty((CharSequence)this.filter)) {
            params.add(FILTER, this.filter);
        }
        params.add(ORDERBY, this.distance_order ? DISTANCE_ASCE : DISTANCE_DESC);
        params.add(POLICY, String.valueOf(this.policy));
        if (this.page_size > 0) {
            params.add(PAGE_SIZE, String.valueOf(this.page_size));
        }
        if (this.page_index > 0) {
            params.add(PAGE_INDEX, String.valueOf(this.page_index));
        }
        if (this.address_format) {
            params.add(ADDRESS_FORMAT, SHORT_ADDRESS);
        }
        return params;
    }

    public static enum Policy {
        DEFAULT(1),
        SHARE_LOCATION(2);

        public final int policyValue;

        private Policy(int value) {
            this.policyValue = value;
        }
    }

    public static class Nearby
    implements SearchParam.Boundary {
        private LatLng point;
        private int radius;
        private boolean autoExtend = true;

        public Nearby() {
        }

        public Nearby(LatLng point, int radius) {
            this.point = point;
            this.radius = radius;
        }

        public Nearby point(LatLng point) {
            this.point = point;
            return this;
        }

        public Nearby r(int radius) {
            this.radius = radius;
            return this;
        }

        public Nearby autoExtend(boolean extend) {
            this.autoExtend = extend;
            return this;
        }

        @Override
        public String toString() {
            return "nearby(" + this.point.latitude + "," + this.point.longitude + "," + this.radius + "," + (this.autoExtend ? 1 : 0) + ")";
        }
    }
}

