/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.httpresponse.BaseObject;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public abstract class RoutePlanningParam
implements ParamObject {
    private LatLng from;
    private LatLng to;
    private String toPOI;

    public RoutePlanningParam() {
    }

    public RoutePlanningParam(LatLng from, LatLng to2) {
        this.from = from;
        this.to = to2;
    }

    public RoutePlanningParam from(LatLng from) {
        this.from = from;
        return this;
    }

    public RoutePlanningParam to(LatLng to2) {
        this.to = to2;
        return this;
    }

    public RoutePlanningParam toPOI(String toPOI) {
        this.toPOI = toPOI;
        return this;
    }

    public abstract String getUrl();

    @Override
    public boolean checkParams() {
        return this.from != null && this.to != null;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        RoutePlanningParam routePlanningParam = this;
        params.put("from", routePlanningParam.locationToParamsString(routePlanningParam.from));
        RoutePlanningParam routePlanningParam2 = this;
        params.put("to", routePlanningParam2.locationToParamsString(routePlanningParam2.to));
        if (!TextUtils.isEmpty((CharSequence)this.toPOI)) {
            params.put("to_poi", this.toPOI);
        }
        return params;
    }

    protected String locationToParamsString(LatLng l2) {
        return l2.latitude + "," + l2.longitude;
    }

    public abstract <T extends BaseObject> Class<T> getResultClass();

    public static enum TransitPolicy {
        LEAST_TIME,
        LEAST_TRANSFER,
        LEAST_WALKING;

    }

    public static enum DrivingPolicy {
        LEAST_TIME,
        LEAST_FEE,
        LEAST_DISTANCE,
        REAL_TRAFFIC;

    }
}

