/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.map.tools.Util;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class SearchParam
implements ParamObject {
    private static final String KEYWORD = "keyword";
    private static final String BOUNDARY = "boundary";
    private static final String FILTER = "filter";
    private static final String ORDERBY = "orderby";
    private static final String PAGE_SIZE = "page_size";
    private static final String PAGE_INDEX = "page_index";
    private static final String DISTANCE_ASCE = "_distance";
    private static final String DISTANCE_DESC = "_distance desc";
    private static final String GET_SUBPOIS = "get_subpois";
    private static final String SUB_TITLE_FORMAT = "sub_title_format";
    private static final String ADDED_FIELDS = "added_fields";
    private static final String CATEGORY_CODE = "category_code";
    private static final String REGION = "region";
    private static final String NEARBY = "nearby";
    private static final String RECTANGLE = "rectangle";
    private String keyword;
    private Boundary boundary;
    private String filter;
    private boolean distance_order = true;
    private int page_size = -1;
    private int page_index = 1;
    private int get_subpois = 0;
    private int sub_title_format = 0;
    private boolean get_category_code = false;

    public SearchParam() {
    }

    public SearchParam(String keyword, Boundary boundary) {
        this.keyword = keyword;
        this.boundary = boundary;
    }

    public SearchParam keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public SearchParam boundary(Boundary boundary) {
        this.boundary = boundary;
        return this;
    }

    public SearchParam filter(String ... values) {
        this.filter = Util.filterBuilder(values);
        return this;
    }

    public SearchParam orderby(boolean asce) {
        this.distance_order = asce;
        return this;
    }

    public SearchParam pageSize(int pagesize) {
        this.page_size = pagesize;
        return this;
    }

    public SearchParam page_size(int pagesize) {
        this.page_size = pagesize;
        return this;
    }

    public SearchParam pageIndex(int page_index) {
        this.page_index = page_index;
        return this;
    }

    public SearchParam page_index(int page_index) {
        this.page_index = page_index;
        return this;
    }

    public SearchParam subPois(boolean isNeeded) {
        this.get_subpois = isNeeded ? 1 : 0;
        return this;
    }

    public SearchParam subTitleFormat(boolean isShort) {
        this.sub_title_format = isShort ? 1 : 0;
        return this;
    }

    public SearchParam getCategoryCode(boolean isNeeded) {
        this.get_category_code = isNeeded;
        return this;
    }

    public SearchParam region(Region region) {
        return this;
    }

    @Override
    public boolean checkParams() {
        return !TextUtils.isEmpty((CharSequence)this.keyword) && this.boundary != null;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (!TextUtils.isEmpty((CharSequence)this.keyword)) {
            params.add(KEYWORD, this.keyword);
        }
        if (this.boundary != null) {
            String b2 = this.boundary.toString();
            params.add(BOUNDARY, b2);
        }
        if (!TextUtils.isEmpty((CharSequence)this.filter)) {
            params.add(FILTER, this.filter);
        }
        params.add(ORDERBY, this.distance_order ? DISTANCE_ASCE : DISTANCE_DESC);
        if (this.page_size > 0) {
            params.add(PAGE_SIZE, String.valueOf(this.page_size));
        }
        if (this.page_index > 0) {
            params.add(PAGE_INDEX, String.valueOf(this.page_index));
        }
        params.add(GET_SUBPOIS, String.valueOf(this.get_subpois));
        params.add(SUB_TITLE_FORMAT, String.valueOf(this.sub_title_format));
        if (this.get_category_code) {
            params.add(ADDED_FIELDS, CATEGORY_CODE);
        }
        return params;
    }

    public static class Rectangle
    implements Boundary {
        private LatLng leftBottom;
        private LatLng rightTop;

        public Rectangle() {
        }

        public Rectangle(LatLng leftBottom, LatLng rightTop) {
            this.leftBottom = leftBottom;
            this.rightTop = rightTop;
        }

        public Rectangle point(LatLng leftBottom, LatLng rightTop) {
            this.leftBottom = leftBottom;
            this.rightTop = rightTop;
            return this;
        }

        @Override
        public String toString() {
            return "rectangle(" + this.leftBottom.latitude + "," + this.leftBottom.longitude + "," + this.rightTop.latitude + "," + this.rightTop.longitude + ")";
        }
    }

    public static class Nearby
    implements Boundary {
        private LatLng point;
        private int radius;
        private boolean autoExtend = true;

        public Nearby() {
        }

        public Nearby(LatLng point, int radius) {
            this.point = point;
            this.radius = radius;
        }

        public Nearby point(LatLng point) {
            this.point = point;
            return this;
        }

        public Nearby r(int radius) {
            this.radius = radius;
            return this;
        }

        public Nearby autoExtend(boolean extend) {
            this.autoExtend = extend;
            return this;
        }

        @Override
        public String toString() {
            return "nearby(" + this.point.latitude + "," + this.point.longitude + "," + this.radius + "," + (this.autoExtend ? 1 : 0) + ")";
        }
    }

    public static class Region
    implements Boundary {
        private String city;
        private boolean autoExtend = false;
        private LatLng latLng;

        public Region() {
        }

        public Region(String city) {
            this.city = city;
        }

        public Region poi(String city) {
            this.city = city;
            return this;
        }

        public Region autoExtend(boolean extend) {
            this.autoExtend = extend;
            return this;
        }

        public Region center(LatLng latLng) {
            this.latLng = latLng;
            return this;
        }

        @Override
        public String toString() {
            return "region(" + this.city + "," + (this.autoExtend ? 1 : 0) + (this.latLng != null ? "," + this.latLng.latitude + "," + this.latLng.longitude : "") + ")";
        }
    }

    public static interface Boundary {
        public String toString();
    }
}

