/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.RoutePlanningParam;
import com.tencent.lbssearch.object.result.TruckingResultObject;
import com.tencent.mapsdk.internal.hs;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TruckingParam
extends RoutePlanningParam {
    private String fromPOI;
    private TruckSize truckSize = TruckSize.LIGHT;
    private double truckLength = 4.2;
    private double truckHeight = 1.8;
    private double truckWidth = 1.9;
    private double truckWeight = 2.5;
    private double truckLoad = 2.0;
    private double axleWeight = 2.0;
    private int axleCount = 2;
    private TrailerType trailerType = TrailerType.NONE;
    private int isTrailer = 0;
    private GoodsType goodsType = GoodsType.ORIGINAL;
    private EnergyType energyType = EnergyType.UNLIMITED;
    private GasEmissionStandard gasEmissionStandard = GasEmissionStandard.UNLIMITED;
    private PassType passType = PassType.UNLIMITED_PASS;
    private static final int MAX_WAT_POINTS = 30;
    private List<LatLng> waypoints = new ArrayList<LatLng>();
    private Policy policy = Policy.REAL_TRAFFIC;
    private String truckNumber;
    private PlateColor plateColor = PlateColor.BLUE;
    private boolean trafficSpeed;
    private int multRoute = 0;
    private int noStep = 0;
    private int noPolyline = 0;
    private final Set<String> mExtraFields = new HashSet<String>();

    @Override
    public RequestParams buildParameters() {
        RequestParams params = super.buildParameters();
        if (!TextUtils.isEmpty((CharSequence)this.fromPOI)) {
            params.put("from_poi", this.fromPOI);
        }
        params.put("size", this.truckSize.size);
        params.put("length", this.truckLength);
        params.put("height", this.truckHeight);
        params.put("width", this.truckWidth);
        params.put("weight", this.truckWeight);
        params.put("load", this.truckLoad);
        params.put("axle_weight", this.axleWeight);
        params.put("axle_count", this.axleCount);
        params.put("is_trailer", this.isTrailer);
        params.put("trailer_type", this.trailerType.trailerType);
        params.put("goods_type", this.goodsType.goodsType);
        params.put("energy_type", this.energyType.energyType);
        params.put("gas_emisstand", this.gasEmissionStandard.gasEmissionStandard);
        params.put("pass_type", this.passType.passType);
        if (this.waypoints.size() > 0) {
            StringBuilder b2 = new StringBuilder();
            for (LatLng l2 : this.waypoints) {
                b2.append(this.locationToParamsString(l2));
                b2.append(";");
            }
            StringBuilder stringBuilder = b2;
            stringBuilder.setLength(stringBuilder.length() - 1);
            params.put("waypoints", b2.toString());
        }
        params.put("policy", this.policy.policyValue);
        if (!TextUtils.isEmpty((CharSequence)this.truckNumber)) {
            params.put("plate_number", this.truckNumber);
        }
        params.put("plate_color", this.plateColor.plateColor);
        if (this.trafficSpeed) {
            params.put("get_speed", 1);
        }
        if (!this.mExtraFields.isEmpty()) {
            params.put("added_fields", hs.a(this.mExtraFields, ","));
        }
        params.put("get_mp", this.multRoute);
        params.put("no_step", this.noStep);
        params.put("no_polyline", this.noPolyline);
        return params;
    }

    public TruckingParam fromPOI(String fromPOI) {
        this.fromPOI = fromPOI;
        return this;
    }

    @Override
    public TruckingParam toPOI(String toPOI) {
        return (TruckingParam)super.toPOI(toPOI);
    }

    public TruckingParam setTruckSize(TruckSize size) {
        this.truckSize = size;
        return this;
    }

    public TruckingParam setTruckLength(double length) {
        this.truckLength = length;
        return this;
    }

    public TruckingParam setTruckHeight(double height) {
        this.truckHeight = height;
        return this;
    }

    public TruckingParam setTruckWidth(double width) {
        this.truckWidth = width;
        return this;
    }

    public TruckingParam setTruckWeight(double weight) {
        this.truckWeight = weight;
        return this;
    }

    public TruckingParam setTruckLoad(double load) {
        this.truckLoad = load;
        return this;
    }

    public TruckingParam setAxleWeight(double axleWeight) {
        this.axleWeight = axleWeight;
        return this;
    }

    public TruckingParam setAxleCount(int axleCount) {
        this.axleCount = axleCount;
        return this;
    }

    public TruckingParam setTrailer(int isTrailer) {
        this.isTrailer = isTrailer;
        return this;
    }

    public TruckingParam addWayPoint(LatLng l2) {
        if (this.waypoints.size() < 30) {
            this.waypoints.add(l2);
        }
        return this;
    }

    public TruckingParam addWayPoints(Iterable<LatLng> ls2) {
        if (ls2 != null) {
            int i2 = 0;
            for (LatLng l2 : ls2) {
                this.waypoints.add(l2);
                if (++i2 <= 30) continue;
                return this;
            }
        }
        return this;
    }

    public TruckingParam setPolicy(Policy policy) {
        this.policy = policy;
        return this;
    }

    public TruckingParam setTruckNumber(String truckNumber) {
        this.truckNumber = truckNumber;
        return this;
    }

    public TruckingParam setPlateColor(PlateColor color) {
        this.plateColor = color;
        return this;
    }

    public TruckingParam setTrailerType(TrailerType trailerType) {
        this.trailerType = trailerType;
        return this;
    }

    public TruckingParam setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
        return this;
    }

    public TruckingParam setEnergyType(EnergyType energyType) {
        this.energyType = energyType;
        return this;
    }

    public TruckingParam setGasEmissionStandard(GasEmissionStandard gasEmissionStandard) {
        this.gasEmissionStandard = gasEmissionStandard;
        return this;
    }

    public TruckingParam setPassType(PassType passType) {
        this.passType = passType;
        return this;
    }

    public TruckingParam trafficSpeed(boolean enable) {
        this.trafficSpeed = enable;
        return this;
    }

    public TruckingParam setMultRoute(int multRoute) {
        this.multRoute = multRoute;
        return this;
    }

    public TruckingParam setNoStep(int noStep) {
        this.noStep = noStep;
        return this;
    }

    public TruckingParam setNoPolyline(int noPolyline) {
        this.noPolyline = noPolyline;
        return this;
    }

    public TruckingParam setExtraFields(String ... extraFields) {
        this.mExtraFields.addAll(Arrays.asList(extraFields));
        return this;
    }

    @Override
    public String getUrl() {
        return "https://apis.map.qq.com/ws/direction/v1/trucking";
    }

    public Class<TruckingResultObject> getResultClass() {
        return TruckingResultObject.class;
    }

    public static enum PassType {
        UNLIMITED_PASS(0),
        HAS_PASS(1),
        NO_PASS(2),
        RESERVE_PASS(3);

        public final int passType;

        private PassType(int value) {
            this.passType = value;
        }
    }

    public static enum GasEmissionStandard {
        UNLIMITED(0),
        NATIONAL_STANDARD_I(1),
        NATIONAL_STANDARD_II(2),
        NATIONAL_STANDARD_III(3),
        NATIONAL_STANDARD_IV(4),
        NATIONAL_STANDARD_V(5),
        NATIONAL_STANDARD_VI(6);

        public final int gasEmissionStandard;

        private GasEmissionStandard(int value) {
            this.gasEmissionStandard = value;
        }
    }

    public static enum EnergyType {
        UNLIMITED(0),
        DIESEL(1),
        GAS_ELECTRIC_HYBRID(2),
        ELECTRIC(3),
        GASOLINE(4);

        public final int energyType;

        private EnergyType(int value) {
            this.energyType = value;
        }
    }

    public static enum GoodsType {
        ORIGINAL(0),
        DANGEROUS(1);

        public final int goodsType;

        private GoodsType(int value) {
            this.goodsType = value;
        }
    }

    public static enum TrailerType {
        NONE(0),
        FLATBED(1),
        VAN(2),
        SEMITRAILER(3),
        FULLTRAILER(4);

        public final int trailerType;

        private TrailerType(int value) {
            this.trailerType = value;
        }
    }

    public static enum TruckSize {
        TINY(1),
        LIGHT(2),
        MIDDLE(3),
        HEAVY(4);

        public final int size;

        private TruckSize(int value) {
            this.size = value;
        }
    }

    public static enum PlateColor {
        BLUE(1),
        YELLOW(2),
        BLACK(3),
        WHITE(4),
        GREEN(5);

        public final int plateColor;

        private PlateColor(int value) {
            this.plateColor = value;
        }
    }

    public static enum Policy {
        REAL_TRAFFIC(1),
        AVOID_HIGHWAY(2),
        LEAST_FEE(3),
        AVOID_JAM_HIGHWAY(4),
        AVOID_HIGHWAY_LESS_FEE(5),
        AVOID_JAM_LESS_FEE(6),
        AVOID_JAM_HIGHWAY_LESS_FEE(7),
        HIGHWAY_FIRST(8),
        HIGHWAY_FIRST_AVOID_JAM(9);

        public final int policyValue;

        private Policy(int value) {
            this.policyValue = value;
        }
    }
}

