/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import com.tencent.map.tools.json.JsonComposer;
import com.tencent.map.tools.json.annotation.Json;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class EventParamsModelClass {

    public static class TranslateAnimationCompleteEventParams
    extends EventParams {
        public TranslateAnimationCompleteEventParams(String layerId) {
            this.eventType = "onTranslateAnimationCompleteEvent";
            this.layerId = layerId;
        }
    }

    public static class LoadFinishEventParams
    extends EventParams {
        public int errorCode;
        public String errorMsg;

        public LoadFinishEventParams(String layerId, LoadFinishInfo error) {
            this.eventType = "onLayerLoadFinishEvent";
            this.layerId = layerId;
            this.errorCode = error.errorCode;
            this.errorMsg = error.errorMsg;
        }

        public static enum LoadFinishInfo {
            ok(0, ""),
            errNetwork(1, "network error"),
            errAuth(2, "authentication error"),
            errDataDecode(3, "data protocol decode error"),
            errDataAvailable(4, "data check available error"),
            errInternal(20, "internal error");

            private int errorCode;
            private String errorMsg;

            private LoadFinishInfo(int key, String value) {
                this.errorCode = key;
                this.errorMsg = value;
            }

            public final int getErrorCode() {
                return this.errorCode;
            }

            public final String getErrorMsg() {
                return this.errorMsg;
            }

            public final boolean checkStatus(int status) {
                return this.errorCode == status;
            }

            public static LoadFinishInfo getById(int status) {
                for (LoadFinishInfo type : LoadFinishInfo.values()) {
                    if (!type.checkStatus(status)) continue;
                    return type;
                }
                return ok;
            }
        }
    }

    public static class ClickEventParams
    extends EventParams {
        @Json(name="clickedPosition")
        public float[] clickedPosition;
        @Json(name="identifier")
        public String identifier;
        @Json(name="name")
        public String name;

        public ClickEventParams(String layerId, LatLng position, String identifier, String name) {
            this.eventType = "onClickEvent";
            this.layerId = layerId;
            this.clickedPosition = new float[2];
            this.clickedPosition[0] = (float)position.getLatitude();
            this.clickedPosition[1] = (float)position.getLongitude();
            this.identifier = identifier;
            this.name = name;
        }
    }

    public static class EventParams
    extends JsonComposer {
        @Json(name="eventType")
        public String eventType;
        @Json(name="layerId")
        public String layerId;
    }
}

