/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import com.tencent.map.lib.models.CommonParamsModelClass;
import com.tencent.map.tools.json.JsonComposer;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public class ReturnInfoModelClass {

    public static class MaterialVariantsReturnInfo
    extends ReturnStatus {
        public CommonParamsModelClass.MaterialVariantsInfoParams value = new CommonParamsModelClass.MaterialVariantsInfoParams();

        public MaterialVariantsReturnInfo(List<CommonParamsModelClass.MaterialVariantInfo> variantInfoList) {
            this.value.materialVariantInfoList = variantInfoList;
        }
    }

    public static class SkeletonAnimationReturnInfo
    extends ReturnStatus {
        public CommonParamsModelClass.SkeletonAnimationParams value = new CommonParamsModelClass.SkeletonAnimationParams();

        public SkeletonAnimationReturnInfo(List<CommonParamsModelClass.AnimationInfo> info) {
            this.value.animationInfoList = info == null ? new ArrayList() : info;
        }
    }

    public static class RotationReturnInfo
    extends ReturnStatus {
        public CommonParamsModelClass.RotationParams value = new CommonParamsModelClass.RotationParams();

        public RotationReturnInfo(float x2, float y2, float z2) {
            this.value.rotationX = x2;
            this.value.rotationY = y2;
            this.value.rotationZ = z2;
        }
    }

    public static class PositionReturnInfo
    extends ReturnStatus {
        public CommonParamsModelClass.PositionParams value = new CommonParamsModelClass.PositionParams();

        public PositionReturnInfo(LatLng latLng) {
            this.value.lat = latLng.latitude;
            this.value.lng = latLng.longitude;
            this.value.altitude = latLng.altitude;
        }
    }

    public static class ErrorReturnInfo
    extends ReturnStatus {
        public int errorCode;
        public String errorMsg;

        public ErrorReturnInfo(ErrorMsg msg) {
            this.status = "failed";
            this.errorCode = msg.getErrorCode();
            this.errorMsg = msg.getErrorMsg();
        }

        public static enum ErrorMsg {
            success(0, "none"),
            jsonparse(1, "json parse error"),
            unsupported(2, "unsupported function"),
            internal(3, "internal error"),
            invalidparam(4, "invalid param error");

            private int errorCode;
            private String errorMsg;

            private ErrorMsg(int key, String value) {
                this.errorCode = key;
                this.errorMsg = value;
            }

            public final int getErrorCode() {
                return this.errorCode;
            }

            public final String getErrorMsg() {
                return this.errorMsg;
            }

            public final ErrorMsg bindErrorMsg(String bindValue) {
                this.errorMsg = this.errorMsg + " | " + bindValue;
                return this;
            }
        }
    }

    public static class BaseFloatReturnInfo
    extends ReturnStatus {
        public float value;

        public BaseFloatReturnInfo(float value) {
            this.status = "success";
            this.value = value;
        }
    }

    public static class BaseBooleanReturnInfo
    extends ReturnStatus {
        public boolean value;

        public BaseBooleanReturnInfo(boolean value) {
            this.status = "success";
            this.value = value;
        }
    }

    public static class BaseIntReturnInfo
    extends ReturnStatus {
        public int value;

        public BaseIntReturnInfo(int value) {
            this.status = "success";
            this.value = value;
        }
    }

    public static class BaseStringReturnInfo
    extends ReturnStatus {
        public String value;

        public BaseStringReturnInfo(String value) {
            this.status = "success";
            this.value = value;
        }
    }

    public static class ReturnStatus
    extends JsonComposer {
        public String status = "success";
    }
}

