/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization.glmodel;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tencent.map.sdk.utilities.visualization.BaseOverlayProvider;
import com.tencent.tencentmap.mapsdk.maps.model.IAnimatorModel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLngBounds;
import java.io.File;
import java.util.List;

public final class GLModelOverlayProvider
extends BaseOverlayProvider {
    private CoordType mCoordType = CoordType.GeoGraphicType;
    private String mModelFilePath;
    private LatLng mPosition;
    private double mScale = 1.0;
    private float mRotationX;
    private float mRotationY;
    private float mRotationZ;
    private LatLngBounds mLatLngBounds;
    private int mPixelWidth;
    private int mPixelHeight;
    private AnimationType mAnimated = AnimationType.None;
    private float mExposure = 1.0f;
    private boolean mBuildingHidden = true;
    private boolean mUnlit = false;
    private IAnimatorModel.IAnimatorEndListener transAnimatorEndListener;

    public final int getPixelWidth() {
        return this.mPixelWidth;
    }

    public final int getPixelHeight() {
        return this.mPixelHeight;
    }

    public final IAnimatorModel.IAnimatorEndListener getTransAnimatorEndListener() {
        return this.transAnimatorEndListener;
    }

    public final void setTransAnimatorEndListener(IAnimatorModel.IAnimatorEndListener transAnimatorEndListener) {
        this.transAnimatorEndListener = transAnimatorEndListener;
    }

    public GLModelOverlayProvider(@NonNull String modelFilePath, @NonNull LatLng position) {
        this.mModelFilePath = this.isModelFileValid(modelFilePath) ? modelFilePath : "";
        this.mPosition = position;
    }

    public final String getModelFilePath() {
        return this.mModelFilePath;
    }

    public final GLModelOverlayProvider modelFilePath(@NonNull String modelFilePath) {
        if (this.isModelFileValid(modelFilePath)) {
            this.mModelFilePath = modelFilePath;
        }
        return this;
    }

    private boolean isModelFileValid(String path) {
        return (path.endsWith(".gltf") || path.endsWith(".GLTF")) && new File(path).exists();
    }

    public final CoordType getCoordType() {
        return this.mCoordType;
    }

    public final GLModelOverlayProvider coordType(CoordType type) {
        this.mCoordType = type;
        return this;
    }

    public final LatLng getPosition() {
        return this.mPosition;
    }

    public final GLModelOverlayProvider position(@NonNull LatLng position) {
        this.mPosition = position;
        return this;
    }

    public final double getScale() {
        return this.mScale;
    }

    public final GLModelOverlayProvider scale(double scale) {
        if (scale > 0.0) {
            this.mScale = scale;
        }
        return this;
    }

    public final float getRotationX() {
        return this.mRotationX;
    }

    public final GLModelOverlayProvider rotationX(float rotationX) {
        this.mRotationX = rotationX;
        return this;
    }

    public final float getRotationY() {
        return this.mRotationY;
    }

    public final GLModelOverlayProvider rotationY(float rotationY) {
        this.mRotationY = rotationY;
        return this;
    }

    public final float getRotationZ() {
        return this.mRotationZ;
    }

    public final GLModelOverlayProvider rotationZ(float rotationZ) {
        this.mRotationZ = rotationZ;
        return this;
    }

    public final LatLngBounds getLatLngBounds() {
        return this.mLatLngBounds;
    }

    public final GLModelOverlayProvider latLngBounds(@Nullable List<LatLng> latLngBounds) {
        this.mLatLngBounds = latLngBounds != null && latLngBounds.size() >= 2 ? new LatLngBounds.Builder().include(latLngBounds).build() : null;
        return this;
    }

    public final GLModelOverlayProvider pixelBounds(int width, int height) {
        this.mPixelWidth = width;
        this.mPixelHeight = height;
        return this;
    }

    public final GLModelOverlayProvider animateType(AnimationType animate) {
        this.mAnimated = animate;
        return this;
    }

    public final AnimationType getAnimationType() {
        return this.mAnimated;
    }

    public final GLModelOverlayProvider setExposure(float mExposure) {
        this.mExposure = mExposure;
        return this;
    }

    public final float getExposure() {
        return this.mExposure;
    }

    public final GLModelOverlayProvider unlit(boolean unlit) {
        this.mUnlit = unlit;
        return this;
    }

    public final boolean getUnlit() {
        return this.mUnlit;
    }

    public final GLModelOverlayProvider zoomRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            super.minZoom(minZoom);
            super.maxZoom(maxZoom);
        }
        return this;
    }

    @Override
    public final int getMinZoom() {
        return super.getMinZoom();
    }

    @Override
    public final int getMaxZoom() {
        return super.getMaxZoom();
    }

    @Override
    public final int getDisplayLevel() {
        return super.getDisplayLevel();
    }

    @Override
    public final GLModelOverlayProvider displayLevel(int displayLevel) {
        super.displayLevel(displayLevel);
        return this;
    }

    @Override
    public final boolean isVisibility() {
        return super.isVisibility();
    }

    @Override
    public final GLModelOverlayProvider visibility(boolean visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public final float getOpacity() {
        return super.getOpacity();
    }

    @Override
    public final GLModelOverlayProvider opacity(float opacity) {
        super.opacity(opacity);
        return this;
    }

    @Override
    public final int getZIndex() {
        return super.getZIndex();
    }

    @Override
    public final GLModelOverlayProvider zIndex(int zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    public final GLModelOverlayProvider setBuildingHidden(boolean hidden) {
        this.mBuildingHidden = hidden;
        return this;
    }

    public final boolean isBuildingHidden() {
        return this.mBuildingHidden;
    }

    public final GLModelOverlayProvider setClickEnable(boolean enable) {
        super.enableClick(enable);
        return this;
    }

    @Override
    public final boolean isClickEnabled() {
        return this.mClickEnabled;
    }

    @Override
    public final String toString() {
        return "GLModelOverlayProvider{mOpacity=" + this.mOpacity + ", mVisibility=" + this.mVisibility + ", mMinZoom=" + this.mMinZoom + ", mMaxZoom=" + this.mMaxZoom + ", mDisplayLevel=" + this.mDisplayLevel + ", mZIndex=" + this.mZIndex + ", mCoordType=" + (Object)((Object)this.mCoordType) + ", mModelFilePath='" + this.mModelFilePath + '\'' + ", mPosition=" + this.mPosition + ", mScale=" + this.mScale + ", mRotationX=" + this.mRotationX + ", mRotationY=" + this.mRotationY + ", mRotationZ=" + this.mRotationZ + ", mLatLngBounds=" + this.mLatLngBounds + ", mAnimated=" + (Object)((Object)this.mAnimated) + ", mExposure=" + this.mExposure + ", mBuildingHidden=" + this.mBuildingHidden + ", mClickEnabled=" + this.mClickEnabled + '}';
    }

    public static enum AnimationType {
        None,
        FlattenRise;

    }

    public static enum CoordType {
        PixelType,
        GeoGraphicType;

    }
}

